/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.datetime.BaseTemporalAccessorConverter;
import com.oracle.coherence.io.json.genson.datetime.DateTimeConverterOptions;
import com.oracle.coherence.io.json.genson.datetime.DateTimeUtil;
import com.oracle.coherence.io.json.genson.datetime.TimestampHandler;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.LinkedHashMap;

class LocalTimeConverter
extends BaseTemporalAccessorConverter<LocalTime> {
    LocalTimeConverter(DateTimeConverterOptions options) {
        super(options, new LocalTimeTimestampHandler(options), LocalTime::from);
    }

    private static LocalTime localTimeFromMillisOfDay(long millis) {
        long seconds = DateTimeUtil.getSecondsFromMillis(millis);
        long nanos = DateTimeUtil.getNanosFromMillis(millis);
        return LocalTime.ofSecondOfDay(seconds).withNano((int)nanos);
    }

    private static class LocalTimeTimestampHandler
    extends TimestampHandler<LocalTime> {
        private static final LinkedHashMap<String, TemporalField> LOCAL_TIME_TEMPORAL_FIELDS = new LinkedHashMap();

        private LocalTimeTimestampHandler(DateTimeConverterOptions options) {
            super(lt -> DateTimeUtil.getMillis(lt.toSecondOfDay(), lt.getNano()), x$0 -> LocalTimeConverter.localTimeFromMillisOfDay(x$0), LocalTime::toNanoOfDay, LocalTime::ofNanoOfDay, LOCAL_TIME_TEMPORAL_FIELDS, LocalTime::now);
        }

        static {
            LOCAL_TIME_TEMPORAL_FIELDS.put("hour", ChronoField.HOUR_OF_DAY);
            LOCAL_TIME_TEMPORAL_FIELDS.put("minute", ChronoField.MINUTE_OF_HOUR);
            LOCAL_TIME_TEMPORAL_FIELDS.put("second", ChronoField.SECOND_OF_MINUTE);
            LOCAL_TIME_TEMPORAL_FIELDS.put("nano", ChronoField.NANO_OF_SECOND);
        }
    }
}

