/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.ext.jsr353.JSR353Bundle;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

class GensonJsonArray
implements JsonArray {
    private final List<JsonValue> values;

    GensonJsonArray(List<JsonValue> values) {
        this.values = values;
    }

    public JsonObject getJsonObject(int index) {
        return (JsonObject)JsonObject.class.cast(this.values.get(index));
    }

    public JsonArray getJsonArray(int index) {
        return (JsonArray)JsonArray.class.cast(this.values.get(index));
    }

    public JsonNumber getJsonNumber(int index) {
        return (JsonNumber)JsonNumber.class.cast(this.values.get(index));
    }

    public JsonString getJsonString(int index) {
        return (JsonString)JsonString.class.cast(this.values.get(index));
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.values;
    }

    public String getString(int index) {
        return this.getJsonString(index).getString();
    }

    public String getString(int index, String defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getString(index);
    }

    public int getInt(int index) {
        return this.getJsonNumber(index).intValue();
    }

    public int getInt(int index, int defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getInt(index);
    }

    public boolean getBoolean(int index) {
        JsonValue value = this.values.get(index);
        if (JsonValue.TRUE.equals((Object)value)) {
            return true;
        }
        if (JsonValue.FALSE.equals((Object)value)) {
            return false;
        }
        throw new ClassCastException();
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        if (this.isNull(index)) {
            return defaultValue;
        }
        return this.getBoolean(index);
    }

    public boolean isNull(int index) {
        return JsonValue.NULL.equals((Object)this.values.get(index));
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    public Iterator<JsonValue> iterator() {
        return this.values.iterator();
    }

    public Object[] toArray() {
        return this.values.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.values.toArray(a);
    }

    public boolean add(JsonValue jsonValue) {
        return this.values.add(jsonValue);
    }

    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.values.containsAll(c);
    }

    public boolean addAll(Collection<? extends JsonValue> c) {
        return this.values.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends JsonValue> c) {
        return this.values.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.values.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.values.retainAll(c);
    }

    public void replaceAll(UnaryOperator<JsonValue> operator) {
        this.values.replaceAll(operator);
    }

    public void sort(Comparator<? super JsonValue> c) {
        this.values.sort(c);
    }

    public void clear() {
        this.values.clear();
    }

    public JsonValue get(int index) {
        return this.values.get(index);
    }

    public JsonValue set(int index, JsonValue element) {
        return this.values.set(index, element);
    }

    public void add(int index, JsonValue element) {
        this.values.add(index, element);
    }

    public JsonValue remove(int index) {
        return this.values.remove(index);
    }

    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    public ListIterator<JsonValue> listIterator() {
        return this.values.listIterator();
    }

    public ListIterator<JsonValue> listIterator(int index) {
        return this.values.listIterator(index);
    }

    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return this.values.subList(fromIndex, toIndex);
    }

    public Spliterator<JsonValue> spliterator() {
        return this.values.spliterator();
    }

    public boolean removeIf(Predicate<? super JsonValue> filter) {
        return this.values.removeIf(filter);
    }

    public Stream<JsonValue> stream() {
        return this.values.stream();
    }

    public Stream<JsonValue> parallelStream() {
        return this.values.parallelStream();
    }

    public void forEach(Consumer<? super JsonValue> action) {
        this.values.forEach(action);
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return JSR353Bundle.toString((JsonValue)this);
    }
}

