/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.jpa;

import com.tangosol.net.cache.CacheLoader;
import com.tangosol.util.Base;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JpaCacheLoader<K, V>
extends Base
implements CacheLoader<K, V> {
    protected static final Map<String, EntityManagerFactory> s_mapFactories = new HashMap<String, EntityManagerFactory>();
    protected String m_sEntityName;
    protected Class<?> m_sEntityClass;
    protected EntityManagerFactory m_emf;

    public JpaCacheLoader(String sEntityName, String sEntityClassName, String sUnitName) {
        this.initialize(sEntityName, sEntityClassName, sUnitName, null);
    }

    public JpaCacheLoader(String sEntityName, String sEntityClassName, String sUnitName, ClassLoader loader) {
        this.initialize(sEntityName, sEntityClassName, sUnitName, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(K oKey) {
        try (EntityManager em = this.getEntityManager();){
            Object object = em.find(this.m_sEntityClass, oKey);
            return (V)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> loadAll(Collection<? extends K> colKeys) {
        try (EntityManager em = this.getEntityManager();){
            HashMap<K, Object> mapResult = new HashMap<K, Object>();
            for (K oKey : colKeys) {
                Object oValue = em.find(this.m_sEntityClass, oKey);
                if (oValue == null) continue;
                mapResult.put(oKey, oValue);
            }
            HashMap<K, Object> hashMap = mapResult;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String sEntityName, String sEntityClassName, String sUnitName, ClassLoader loader) {
        if (sEntityName == null | sEntityClassName == null | sUnitName == null) {
            throw new IllegalArgumentException("Entity name, fully-qualified entity class name, and persistence unit name must be specified");
        }
        this.m_sEntityName = sEntityName;
        if (loader == null) {
            loader = JpaCacheLoader.getContextClassLoader();
        }
        try {
            this.m_sEntityClass = loader.loadClass(sEntityClassName);
        }
        catch (ClassNotFoundException e) {
            throw JpaCacheLoader.ensureRuntimeException((Throwable)e, (String)("Class " + sEntityClassName + " could not be loaded"));
        }
        Map<String, EntityManagerFactory> map = s_mapFactories;
        synchronized (map) {
            this.m_emf = s_mapFactories.get(sUnitName);
            if (this.m_emf == null) {
                this.m_emf = Persistence.createEntityManagerFactory((String)sUnitName);
                s_mapFactories.put(sUnitName, this.m_emf);
            }
        }
    }

    protected EntityManager getEntityManager() {
        return this.m_emf.createEntityManager();
    }
}

