/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.Constants;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public class JCacheEntryMetaInf
implements ExternalizableLite,
PortableObject {
    private long m_ldtCreation;
    private long m_ldtAccess;
    private long m_cAccess;
    private long m_ldtModification;
    private long m_cModification;
    private long m_ldtExpiry;

    public JCacheEntryMetaInf() {
    }

    public JCacheEntryMetaInf(JCacheEntryMetaInf metaInf) {
        this.m_ldtCreation = metaInf.m_ldtCreation;
        this.m_ldtAccess = metaInf.m_ldtAccess;
        this.m_cAccess = metaInf.m_cAccess;
        this.m_ldtModification = metaInf.m_ldtModification;
        this.m_cModification = metaInf.m_cModification;
        this.m_ldtExpiry = metaInf.m_ldtExpiry;
    }

    public JCacheEntryMetaInf(long ldtCreated, ExpiryPolicy expiryPolicy) {
        Duration duration;
        this.m_ldtCreation = ldtCreated;
        this.m_ldtAccess = ldtCreated;
        this.m_ldtModification = ldtCreated;
        this.m_cAccess = 0L;
        this.m_cModification = 0L;
        try {
            duration = expiryPolicy.getExpiryForCreation();
        }
        catch (Throwable e) {
            duration = Constants.DEFAULT_EXPIRY_DURATION;
            Logger.warn((String)("defaulting to implemention-specifc ExpiryForCreation default due to handling unexpected exception in user-provided ExpiryPolicy:\n" + Base.printStackTrace((Throwable)e)));
        }
        this.m_ldtExpiry = duration.getAdjustedTime(ldtCreated);
    }

    public long getCreationTime() {
        return this.m_ldtCreation;
    }

    public long getAccessTime() {
        return this.m_ldtAccess;
    }

    public long getAccessCount() {
        return this.m_cAccess;
    }

    public long getModificationTime() {
        return this.m_ldtModification;
    }

    public long getModificationCount() {
        return this.m_cModification;
    }

    public long getExpiryTime() {
        return this.m_ldtExpiry;
    }

    public void setExpiryTime(long expiryTime) {
        this.m_ldtExpiry = expiryTime;
    }

    public boolean isExpiredAt(long now) {
        return this.m_ldtExpiry > -1L && this.m_ldtExpiry <= now;
    }

    public void setAccessTime(long accessTime) {
        this.m_ldtAccess = accessTime;
        ++this.m_cAccess;
    }

    public void setModificationTime(long modificationTime) {
        this.m_ldtModification = modificationTime;
        ++this.m_cModification;
    }

    public void accessed(long ldtAccessed, ExpiryPolicy expiryPolicy) {
        Duration duration;
        this.setAccessTime(ldtAccessed);
        try {
            duration = expiryPolicy.getExpiryForAccess();
        }
        catch (Throwable e) {
            duration = null;
            Logger.warn((String)"handled unexpected exception in user-provided ExpiryPolicy:", (Throwable)e);
        }
        if (duration != null) {
            this.setExpiryTime(duration.getAdjustedTime(ldtAccessed));
        }
    }

    public void modified(long ldtModified, ExpiryPolicy expiryPolicy) {
        Duration duration;
        this.setModificationTime(ldtModified);
        try {
            duration = expiryPolicy.getExpiryForUpdate();
        }
        catch (Throwable e) {
            duration = null;
            Logger.warn((String)"handled unexpected exception in user-provided ExpiryPolicy:", (Throwable)e);
        }
        if (duration != null) {
            this.setExpiryTime(duration.getAdjustedTime(ldtModified));
        }
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.m_ldtCreation = dataInput.readLong();
        this.m_ldtAccess = dataInput.readLong();
        this.m_cAccess = dataInput.readLong();
        this.m_ldtModification = dataInput.readLong();
        this.m_cModification = dataInput.readLong();
        this.m_ldtExpiry = dataInput.readLong();
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.m_ldtCreation);
        dataOutput.writeLong(this.m_ldtAccess);
        dataOutput.writeLong(this.m_cAccess);
        dataOutput.writeLong(this.m_ldtModification);
        dataOutput.writeLong(this.m_cModification);
        dataOutput.writeLong(this.m_ldtExpiry);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        long now = Helper.getCurrentTimeMillis();
        buf.append("JCacheEntryMetaInf:[ created ");
        buf.append(now - this.m_ldtCreation);
        buf.append(" ms ago:");
        buf.append(" accessed ");
        buf.append(now - this.m_ldtAccess);
        buf.append(" ms ago:");
        buf.append(" modified ");
        buf.append(now - this.m_ldtModification);
        buf.append(" ms ago:");
        buf.append(" expires in ");
        buf.append(now - this.m_ldtExpiry);
        buf.append(" ms ");
        buf.append(" accessCnt=");
        buf.append(this.m_cAccess);
        buf.append(" modCnt=");
        buf.append(this.m_cModification);
        buf.append("]");
        return buf.toString();
    }

    public void readExternal(PofReader pofReader) throws IOException {
        this.m_ldtCreation = pofReader.readLong(0);
        this.m_ldtAccess = pofReader.readLong(1);
        this.m_cAccess = pofReader.readLong(2);
        this.m_ldtModification = pofReader.readLong(3);
        this.m_cModification = pofReader.readLong(4);
        this.m_ldtExpiry = pofReader.readLong(5);
    }

    public void writeExternal(PofWriter pofWriter) throws IOException {
        pofWriter.writeLong(0, this.m_ldtCreation);
        pofWriter.writeLong(1, this.m_ldtAccess);
        pofWriter.writeLong(2, this.m_cAccess);
        pofWriter.writeLong(3, this.m_ldtModification);
        pofWriter.writeLong(4, this.m_cModification);
        pofWriter.writeLong(5, this.m_ldtExpiry);
    }
}

