/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.serialization;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;

public class DurationPofSerializer
implements PofSerializer {
    public void serialize(PofWriter pofWriter, Object o) throws IOException {
        Duration d = (Duration)o;
        pofWriter.writeLong(0, d.getDurationAmount());
        pofWriter.writeObject(1, (Object)d.getTimeUnit());
        pofWriter.writeRemainder(null);
    }

    public Object deserialize(PofReader pofReader) throws IOException {
        Duration result = null;
        try {
            long amount = pofReader.readLong(0);
            TimeUnit unit = (TimeUnit)((Object)pofReader.readObject(1));
            result = amount == 0L ? (unit == null ? Duration.ETERNAL : Duration.ZERO) : new Duration(unit, amount);
        }
        catch (Throwable t) {
            throw new IOException("Malformed Duration", t);
        }
        finally {
            pofReader.readRemainder();
        }
        return result;
    }
}

