/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PutProcessor<K>
extends AbstractEntryProcessor {
    private Binary m_binValue;

    public PutProcessor() {
        this.m_binValue = new Binary();
    }

    public PutProcessor(Binary binValue, JCacheIdentifier id) {
        super(id);
        this.m_binValue = binValue;
    }

    public Object process(InvocableMap.Entry entry) {
        JCacheEntryMetaInf valueMetaInf;
        BinaryEntry binEntry = (BinaryEntry)entry;
        JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
        JCacheStatistics stats = jcacheCtx.getStatistics();
        long ldtStart = stats == null ? 0L : Helper.getCurrentTimeMillis();
        Binary binValue = binEntry.isPresent() ? binEntry.getBinaryValue() : null;
        BackingMapManagerContext ctx = binEntry.getContext();
        boolean fExpired = false;
        if (binEntry.isPresent()) {
            valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry);
            assert (valueMetaInf != null);
            if (BinaryEntryHelper.isExpired(binEntry, valueMetaInf, ldtStart)) {
                Byte jcache_synthetic_kind = (Byte)ctx.getInternalValueDecoration((Object)binValue, 15);
                if (jcache_synthetic_kind != null && !BinaryEntryHelper.JCACHE_SYNTHETIC_EXPIRY.equals(jcache_synthetic_kind)) {
                    fExpired = true;
                }
            } else {
                valueMetaInf.modified(ldtStart, jcacheCtx.getExpiryPolicy());
                ctx.removeInternalValueDecoration((Object)binValue, 14);
                binValue = (Binary)ctx.addInternalValueDecoration((Object)this.m_binValue, 14, (Object)valueMetaInf);
                binEntry.updateBinaryValue(binValue);
                stats.registerPuts(1L, ldtStart);
                return null;
            }
        }
        if (!(valueMetaInf = new JCacheEntryMetaInf(ldtStart, jcacheCtx.getExpiryPolicy())).isExpiredAt(ldtStart)) {
            binValue = (Binary)ctx.addInternalValueDecoration((Object)this.m_binValue, 14, (Object)valueMetaInf);
            if (fExpired) {
                binValue = BinaryEntryHelper.jcacheSyntheticExpiryEventForReusedBinaryEntry(binValue, ctx);
            }
            binEntry.updateBinaryValue(binValue);
            stats.registerPuts(1L, ldtStart);
        }
        return null;
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_binValue.readExternal(dataInput);
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        this.m_binValue.writeExternal(dataOutput);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_binValue = pofReader.readBinary(1);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeBinary(1, this.m_binValue);
    }
}

