/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.SerializingInternalConverter;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ResourceRegistry;
import java.io.Closeable;
import java.io.IOException;

public class PartitionedCacheConfigurationMapListener
extends AbstractMapListener
implements MapListenerSupport.SynchronousListener {
    private ResourceRegistry m_registry;
    private SerializingInternalConverter<String> m_converterKey;

    public void entryDeleted(MapEvent evt) {
        JCacheIdentifier jcacheId = this.getJCacheIdentifierFromKey(evt);
        JCacheContext ctx = JCacheContext.getContext(this.m_registry, jcacheId);
        if (ctx != null) {
            if (ctx.getCacheLoader() instanceof Closeable) {
                try {
                    ((Closeable)ctx.getCacheLoader()).close();
                }
                catch (IOException e) {
                    Logger.fine((String)"Unexpected exception in closable CacheLoader: ", (Throwable)e);
                }
            }
            if (ctx.getCacheWriter() instanceof Closeable) {
                try {
                    ((Closeable)ctx.getCacheWriter()).close();
                }
                catch (IOException e) {
                    Logger.fine((String)"Unexpected exception in closable CacheWriter: ", (Throwable)e);
                }
            }
            if (ctx.getExpiryPolicy() instanceof Closeable) {
                try {
                    ((Closeable)ctx.getExpiryPolicy()).close();
                }
                catch (IOException e) {
                    Logger.fine((String)"Unexpected exception in closable ExpiryPolicy: ", (Throwable)e);
                }
            }
            JCacheContext.unregister(this.m_registry, jcacheId);
        }
        if (Logger.isEnabled((int)7)) {
            String unregisterLogMessage = ctx == null ? " no JCacheContext found in registry " + this.m_registry : " unregister JCacheContext from resource registry " + this.m_registry;
            Logger.finest((String)("PartitionedCacheConfigurationMap: entryDeleted event JCacheId=" + jcacheId + unregisterLogMessage + " configuration=" + evt.getOldValue()));
        }
    }

    @Injectable
    public void setResourceRegistry(ResourceRegistry registry) {
        this.m_registry = registry;
    }

    private JCacheIdentifier getJCacheIdentifierFromKey(MapEvent mapEvent) {
        String sJCacheId = null;
        Object key = mapEvent.getKey();
        if (key instanceof String) {
            sJCacheId = (String)key;
        } else if (key instanceof Binary) {
            if (this.m_converterKey == null) {
                SerializerFactory factorySerializer = (SerializerFactory)this.m_registry.getResource(SerializerFactory.class, "serializer");
                Serializer serializer = factorySerializer == null ? ExternalizableHelper.ensureSerializer(null) : factorySerializer.createSerializer(null);
                this.m_converterKey = new SerializingInternalConverter(serializer);
            }
            sJCacheId = this.m_converterKey.fromInternal(key);
        }
        return new JCacheIdentifier(sJCacheId);
    }
}

