/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.AbstractCoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntry;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryEvent;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryListenerRegistration;
import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.common.CoherenceCacheMXBean;
import com.tangosol.coherence.jcache.common.CoherenceEntryProcessorResult;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.InternalConverter;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.common.MBeanServerRegistrationUtility;
import com.tangosol.coherence.jcache.common.ReferenceInternalConverter;
import com.tangosol.coherence.jcache.common.SerializingInternalConverter;
import com.tangosol.coherence.jcache.localcache.LocalCacheAsynchronousMapListener;
import com.tangosol.coherence.jcache.localcache.LocalCacheConfiguration;
import com.tangosol.coherence.jcache.localcache.LocalCacheSynchronousMapListener;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.coherence.jcache.localcache.processors.ConditionalRemoveProcessor;
import com.tangosol.coherence.jcache.localcache.processors.GetAndReplaceProcessor;
import com.tangosol.coherence.jcache.localcache.processors.InvokeProcessor;
import com.tangosol.coherence.jcache.localcache.processors.ReplaceIfExistsProcessor;
import com.tangosol.coherence.jcache.localcache.processors.ReplaceWithProcessor;
import com.tangosol.coherence.jcache.localcache.processors.SyntheticDeleteProcessor;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.PartitionedService;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.WrapperCollections;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.AlwaysFilter;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.EventType;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class LocalCache<K, V>
extends AbstractCoherenceBasedCache<K, V, LocalCacheConfiguration<K, V>> {
    private final AtomicReference<ExecutorService> m_refExecutorService = new AtomicReference<Object>(null);
    private final CacheMXBean m_mxbean;
    private final InternalConverter<K> m_converterKey;
    private final InternalConverter<V> m_converterValue;
    private MapListener m_listenerAsynchronous;
    private MapListener m_listenerSynchronous;
    private final Filter m_filterCreateUpdateRemove;
    private AtomicBoolean m_fStats = new AtomicBoolean();
    private final JCacheIdentifier m_cacheId;
    private final JCacheContext m_ctx;
    private final CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> m_setListenerRegistrationSynchronous;
    private final CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> m_setListenerRegistrationAsynchronous;

    public LocalCache(CoherenceBasedCacheManager manager, String sJCacheName, LocalCacheConfiguration<K, V> configuration) {
        super(manager, sJCacheName, configuration);
        this.m_cacheId = new JCacheIdentifier(manager.getURI().toString(), sJCacheName);
        this.m_ctx = JCacheContext.getContext(manager.getConfigurableCacheFactory().getResourceRegistry(), this.m_cacheId, (CompleteConfiguration)this.m_configuration);
        this.m_namedCache = manager.getConfigurableCacheFactory().ensureCache("jcache-local-" + this.getInternalCacheName(), manager.getClassLoader());
        if (PartitionedService.class.isAssignableFrom(this.m_namedCache.getCacheService().getClass())) {
            throw new IllegalStateException("Invalid JCache LocalCache configuration: Verify that the uri used by this cache's CacheManager includes the attribute \"xmlns:jcache=class://com.tangosol.coherence.jcache.JCacheNamespace\" on  element cache-config");
        }
        this.m_fStats.set(((LocalCacheConfiguration)this.m_configuration).isStatisticsEnabled());
        this.m_mxbean = new CoherenceCacheMXBean(this);
        if (((LocalCacheConfiguration)this.m_configuration).isStoreByValue()) {
            ClassLoader classLoader = manager.getClassLoader();
            ConfigurableCacheFactory ccf = manager.getConfigurableCacheFactory();
            ResourceRegistry registryResources = ccf.getResourceRegistry();
            SerializerFactory factorySerializer = (SerializerFactory)registryResources.getResource(SerializerFactory.class, "serializer");
            Serializer serializer = factorySerializer == null ? ExternalizableHelper.ensureSerializer((ClassLoader)classLoader) : factorySerializer.createSerializer(classLoader);
            this.m_converterKey = new SerializingInternalConverter<K>(serializer);
            this.m_converterValue = new SerializingInternalConverter<V>(serializer);
        } else {
            this.m_converterKey = new ReferenceInternalConverter<K>();
            this.m_converterValue = new ReferenceInternalConverter<V>();
        }
        if (((LocalCacheConfiguration)this.m_configuration).isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (((LocalCacheConfiguration)this.m_configuration).isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
        LinkedList listSynchDef = new LinkedList();
        LinkedList listAsyncDef = new LinkedList();
        for (CacheEntryListenerConfiguration listenerConfiguration : ((LocalCacheConfiguration)this.m_configuration).getCacheEntryListenerConfigurations()) {
            CoherenceCacheEntryListenerRegistration definition = new CoherenceCacheEntryListenerRegistration(listenerConfiguration);
            if (listenerConfiguration.isSynchronous()) {
                listSynchDef.add(definition);
                continue;
            }
            listAsyncDef.add(definition);
        }
        this.m_setListenerRegistrationSynchronous = new CopyOnWriteArraySet(listSynchDef);
        this.m_setListenerRegistrationAsynchronous = new CopyOnWriteArraySet(listAsyncDef);
        this.m_filterCreateUpdateRemove = new LocalCacheAsynchronousMapListener.NonSyntheticEntryFilter();
        this.synchronizeCacheEntryListeners();
    }

    @Override
    public void onBeforeClosing() {
        ExecutorService exeSvc;
        CacheEntryListener<K, V> listener;
        if (this.m_ctx.getCacheLoader() instanceof Closeable) {
            try {
                ((Closeable)this.m_ctx.getCacheLoader()).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable CacheLoader: ", (Throwable)e);
            }
        }
        if (this.m_ctx.getCacheWriter() instanceof Closeable) {
            try {
                ((Closeable)this.m_ctx.getCacheWriter()).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable CacheWriter: ", (Throwable)e);
            }
        }
        if (this.m_ctx.getExpiryPolicy() instanceof Closeable) {
            try {
                ((Closeable)this.m_ctx.getExpiryPolicy()).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable ExpiryPolicy: ", (Throwable)e);
            }
        }
        for (CoherenceCacheEntryListenerRegistration<K, V> registration : this.m_setListenerRegistrationAsynchronous) {
            listener = registration.getCacheEntryListener();
            if (!(listener instanceof Closeable)) continue;
            try {
                ((Closeable)listener).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable Asynchronous CacheEntryListener: ", (Throwable)e);
            }
        }
        for (CoherenceCacheEntryListenerRegistration<K, V> registration : this.m_setListenerRegistrationSynchronous) {
            listener = registration.getCacheEntryListener();
            if (!(listener instanceof Closeable)) continue;
            try {
                ((Closeable)listener).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable Synchronous CacheEntryListener: ", (Throwable)e);
            }
        }
        if (this.m_listenerSynchronous != null) {
            this.m_namedCache.removeMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove);
        }
        if (this.m_listenerAsynchronous != null) {
            this.m_namedCache.removeMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove);
        }
        if ((exeSvc = this.m_refExecutorService.get()) != null) {
            exeSvc.shutdown();
            this.m_refExecutorService.compareAndSet(exeSvc, null);
        }
        this.setStatisticsEnabled(false);
        this.setManagementEnabled(false);
    }

    @Override
    public JCacheStatistics getStatistics() {
        return ((LocalCacheConfiguration)this.m_configuration).isStatisticsEnabled() ? this.m_ctx.getStatistics() : null;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.m_ctx.getStatistics() != null && this.m_fStats.get();
    }

    @Override
    public void setStatisticsEnabled(boolean fEnabled) {
        ((LocalCacheConfiguration)this.m_configuration).setStatisticsEnabled(fEnabled);
        this.m_fStats.set(fEnabled);
        if (fEnabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        }
    }

    @Override
    public void setManagementEnabled(boolean fEnabled) {
        ((LocalCacheConfiguration)this.m_configuration).setManagementEnabled(fEnabled);
        if (fEnabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
    }

    @Override
    public CacheMXBean getMBean() {
        return this.m_mxbean;
    }

    public CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> getRegisteredSynchronousEventListeners() {
        return this.m_setListenerRegistrationSynchronous;
    }

    public CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> getRegisteredAsynchronousEventListeners() {
        return this.m_setListenerRegistrationAsynchronous;
    }

    public void processExpiries(K key, CoherenceCacheEventEventDispatcher<K, V> dispatcher) {
        Object internalKey = this.m_converterKey.toInternal(key);
        LocalCacheValue cacheValue = (LocalCacheValue)this.m_namedCache.invoke(internalKey, new SyntheticDeleteProcessor(this));
        Object expiredValue = cacheValue == null ? null : (Object)this.m_converterValue.fromInternal(cacheValue.getInternalValue(Helper.getCurrentTimeMillis()));
        dispatcher.addEvent(CacheEntryExpiredListener.class, new CoherenceCacheEntryEvent<K, Object>(this, EventType.EXPIRED, key, null, expiredValue));
    }

    public void processExpiries(K keyExpired, V valueExpired, CoherenceCacheEventEventDispatcher<K, V> dispatcher) {
        Object internalKey = this.m_converterKey.toInternal(keyExpired);
        this.m_namedCache.invoke(internalKey, new SyntheticDeleteProcessor(this));
        dispatcher.addEvent(CacheEntryExpiredListener.class, new CoherenceCacheEntryEvent<K, Object>(this, EventType.EXPIRED, keyExpired, null, valueExpired));
    }

    public JCacheContext getContext() {
        return this.m_ctx;
    }

    public InternalConverter<K> getKeyConverter() {
        return this.m_converterKey;
    }

    public InternalConverter<V> getValueConverter() {
        return this.m_converterValue;
    }

    public void dispatch(final CoherenceCacheEventEventDispatcher<K, V> dispatcher) {
        dispatcher.dispatch(this.getRegisteredSynchronousEventListeners());
        this.submit(new Runnable(){

            @Override
            public void run() {
                dispatcher.dispatch(LocalCache.this.getRegisteredAsynchronousEventListeners());
            }
        });
    }

    public V get(K key) {
        RuntimeException exception = null;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        V value = null;
        CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
        try {
            value = this.getValue(key, dispatcher);
        }
        catch (Exception e) {
            exception = this.handleException(e, CacheLoaderException.class);
        }
        this.dispatch(dispatcher);
        if (exception != null) {
            throw exception;
        }
        return value;
    }

    public Map<K, V> getAll(Set<? extends K> setKey) {
        this.ensureOpen();
        if (setKey == null || setKey.contains(null)) {
            throw new NullPointerException();
        }
        try {
            HashMap map = new HashMap(setKey.size());
            CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
            for (K key : setKey) {
                Object value = this.getValue(key, dispatcher);
                if (value == null) continue;
                map.put(key, value);
            }
            this.dispatch(dispatcher);
            return map;
        }
        catch (Exception e) {
            throw this.handleException(e, CacheException.class);
        }
    }

    public boolean containsKey(K key) {
        boolean fResult = false;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            boolean fIsExpired;
            Object internalKey = this.m_converterKey.toInternal(key);
            LocalCacheValue cacheValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
            boolean bl = fIsExpired = cacheValue != null && cacheValue.isExpiredAt(Helper.getCurrentTimeMillis());
            if (cacheValue == null || fIsExpired) {
                fResult = false;
                if (fIsExpired) {
                    CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
                    this.processExpiries(key, dispatcher);
                    this.dispatch(dispatcher);
                }
            } else {
                fResult = true;
            }
            return fResult;
        }
        catch (Exception e) {
            throw this.handleException(e, CacheException.class);
        }
    }

    public void loadAll(final Set<? extends K> setKeys, final boolean fReplaceExistingValues, final CompletionListener listener) {
        this.ensureOpen();
        if (setKeys == null) {
            throw new NullPointerException("keys");
        }
        if (this.m_ctx.getCacheLoader() == null) {
            if (listener != null) {
                listener.onCompletion();
            }
        } else {
            for (K key : setKeys) {
                if (key != null) continue;
                throw new NullPointerException("keys contains a null");
            }
            this.submit(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            ArrayList listKeysToLoad = new ArrayList();
                            for (Object key : setKeys) {
                                if (!fReplaceExistingValues && LocalCache.this.containsKey(key)) continue;
                                listKeysToLoad.add(key);
                            }
                            Map mapLoaded = LocalCache.this.m_ctx.getCacheLoader().loadAll(listKeysToLoad);
                            for (Object key : listKeysToLoad) {
                                if (mapLoaded.get(key) != null) continue;
                                mapLoaded.remove(key);
                            }
                            boolean USE_WRITE_THROUGH = false;
                            LocalCache.this.putAll(mapLoaded, fReplaceExistingValues, false);
                            if (listener != null) {
                                listener.onCompletion();
                            }
                        }
                        catch (Exception e) {
                            if (listener == null) break block5;
                            listener.onException((Exception)LocalCache.this.handleException(e, CacheLoaderException.class));
                        }
                    }
                }
            });
        }
    }

    public void put(K key, V value) {
        this.put(key, value, true);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, true);
    }

    public V getAndPut(K key, V value) {
        V result;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        if (value == null) {
            throw new NullPointerException("null value specified for value " + value);
        }
        long ldtNow = Helper.getCurrentTimeMillis();
        long start = this.isStatisticsEnabled() ? ldtNow : 0L;
        int putCount = 0;
        try {
            boolean isExpired;
            CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
            Object internalKey = this.m_converterKey.toInternal(key);
            Object internalValue = this.m_converterValue.toInternal(value);
            LocalCacheValue cachedValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
            boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
            if (cachedValue == null || isExpired) {
                result = null;
                CoherenceCacheEntry<K, V> entry = new CoherenceCacheEntry<K, V>(key, value);
                this.writeCacheEntry(entry);
                if (isExpired) {
                    this.processExpiries(key, dispatcher);
                }
                if (!(cachedValue = LocalCacheValue.createLocalCacheValue(internalValue, ldtNow, this.getContext().getExpiryPolicy())).isExpiredAt(ldtNow)) {
                    this.m_namedCache.put(internalKey, (Object)cachedValue);
                    ++putCount;
                }
            } else {
                V oldValue = this.m_converterValue.fromInternal(cachedValue.getInternalValue(ldtNow));
                CoherenceCacheEntry<K, V> entry = new CoherenceCacheEntry<K, V>(key, value, oldValue);
                this.writeCacheEntry(entry);
                this.m_namedCache.put(internalKey, (Object)this.updateLocalCacheValue(this.m_ctx, cachedValue, internalValue, ldtNow));
                ++putCount;
                result = oldValue;
            }
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
        if (this.isStatisticsEnabled()) {
            if (result == null) {
                this.getStatistics().registerMisses(1, start);
            } else {
                this.getStatistics().registerHits(1, start);
            }
            if (putCount > 0) {
                this.getStatistics().registerPuts(putCount, start);
            }
        }
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, true, ((LocalCacheConfiguration)this.m_configuration).isWriteThrough());
    }

    public boolean remove(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
            long ldtNow = Helper.getCurrentTimeMillis();
            long ldtStart = this.isStatisticsEnabled() ? ldtNow : 0L;
            Object internalKey = this.m_converterKey.toInternal(key);
            this.deleteCacheEntry(key);
            LocalCacheValue value = (LocalCacheValue)this.m_namedCache.remove(internalKey);
            boolean fIsExpired = value != null && value.isExpiredAt(ldtNow);
            boolean fResult = false;
            if (value == null || fIsExpired) {
                if (fIsExpired) {
                    this.processExpiries(key, dispatcher);
                    this.dispatch(dispatcher);
                }
                fResult = false;
            } else {
                fResult = true;
            }
            if (fResult && this.isStatisticsEnabled()) {
                this.m_ctx.getStatistics().registerRemoves(1L, ldtStart);
            }
            return fResult;
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean remove(K key, V value) {
        this.ensureOpen();
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try {
            Object internalKey = this.m_converterKey.toInternal(key);
            Object internalExpectedValue = this.m_converterValue.toInternal(value);
            return (Boolean)this.m_namedCache.invoke(internalKey, new ConditionalRemoveProcessor(this, internalExpectedValue));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public V getAndRemove(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            long ldtStart;
            CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
            long ldtNow = ldtStart = this.isStatisticsEnabled() ? Helper.getCurrentTimeMillis() : 0L;
            Object internalKey = this.m_converterKey.toInternal(key);
            LocalCacheValue cacheValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
            boolean fIsExpired = cacheValue == null ? false : cacheValue.isExpiredAt(ldtNow);
            V oResult = cacheValue == null ? null : (V)this.m_converterValue.fromInternal(cacheValue.get());
            this.deleteCacheEntry(key);
            if (cacheValue == null || fIsExpired) {
                if (fIsExpired) {
                    this.processExpiries(key, oResult, dispatcher);
                    this.dispatch(dispatcher);
                }
                oResult = null;
            } else {
                this.m_namedCache.remove(internalKey);
            }
            if (this.isStatisticsEnabled()) {
                if (oResult == null) {
                    this.m_ctx.getStatistics().registerMisses(1, ldtStart);
                } else {
                    this.m_ctx.getStatistics().registerRemoves(1L, ldtStart);
                    this.m_ctx.getStatistics().registerHits(1, ldtStart);
                }
            }
            return oResult;
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean replace(K key, V valueOrig, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (valueOrig == null) {
            throw new NullPointerException("expectedValue can't be null");
        }
        if (value == null) {
            throw new NullPointerException("newValue can't be null");
        }
        boolean fResult = false;
        try {
            Object internalKey = this.m_converterKey.toInternal(key);
            Object internalValueOrig = this.m_converterValue.toInternal(valueOrig);
            Object internalNewValue = this.m_converterValue.toInternal(value);
            fResult = (Boolean)this.m_namedCache.invoke(internalKey, new ReplaceWithProcessor(this, internalValueOrig, internalNewValue));
        }
        catch (Exception e) {
            this.handleException(e, CacheWriterException.class);
        }
        return fResult;
    }

    public boolean replace(K key, V value) {
        this.ensureOpen();
        boolean fResult = false;
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        try {
            Object internalKey = this.m_converterKey.toInternal(key);
            Object internalNewValue = this.m_converterValue.toInternal(value);
            fResult = (Boolean)this.m_namedCache.invoke(internalKey, new ReplaceIfExistsProcessor(this, internalNewValue));
        }
        catch (Exception e) {
            this.handleException(e, CacheWriterException.class);
        }
        return fResult;
    }

    public V getAndReplace(K key, V value) {
        V result = null;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("null key not allowed");
        }
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        try {
            Object internalKey = this.m_converterKey.toInternal(key);
            Object internalNewValue = this.m_converterValue.toInternal(value);
            result = this.m_converterValue.fromInternal(this.m_namedCache.invoke(internalKey, new GetAndReplaceProcessor(this, internalNewValue)));
        }
        catch (Exception e) {
            this.handleException(e, CacheWriterException.class);
        }
        return result;
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        if (keys.contains(null)) {
            throw new NullPointerException("keys set contains a null");
        }
        try {
            for (K key : keys) {
                this.remove(key);
            }
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void removeAll() {
        this.ensureOpen();
        try {
            Set keys = this.m_namedCache.keySet();
            for (Object internalKey : keys) {
                this.remove(this.m_converterKey.fromInternal(internalKey));
            }
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void clear() {
        this.ensureOpen();
        this.m_namedCache.invokeAll((Filter)AlwaysFilter.INSTANCE, new SyntheticDeleteProcessor(this));
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> proc, Object ... arguments) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (proc == null) {
            throw new NullPointerException("parameter entryProcessor");
        }
        Object internalKey = this.m_converterKey.toInternal(key);
        try {
            CoherenceEntryProcessorResult result = (CoherenceEntryProcessorResult)this.m_namedCache.invoke(internalKey, new InvokeProcessor<K, V, T>(this, proc, arguments));
            return result == null ? null : (T)result.get();
        }
        catch (Exception e) {
            throw this.handleException(e, EntryProcessorException.class);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> setKey, EntryProcessor<K, V, T> proc, Object ... arguments) {
        HashMap<K, EntryProcessorResult> result = new HashMap<K, EntryProcessorResult>();
        HashSet<Object> internalKeys = new HashSet<Object>();
        if (proc == null) {
            throw new NullPointerException();
        }
        for (K key : setKey) {
            if (key == null) {
                throw new NullPointerException();
            }
            internalKeys.add(this.getKeyConverter().toInternal(key));
        }
        try {
            Map internalResult = this.m_namedCache.invokeAll(internalKeys, new InvokeProcessor<K, V, T>(this, proc, arguments));
            result = new HashMap(internalResult.size());
            for (Map.Entry internalEntry : internalResult.entrySet()) {
                result.put(this.m_converterKey.fromInternal(internalEntry.getKey()), (EntryProcessorResult)internalEntry.getValue());
            }
        }
        catch (Exception e) {
            throw this.handleException(e, EntryProcessorException.class);
        }
        return result == null ? new HashMap<K, EntryProcessorResult>() : result;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        ((LocalCacheConfiguration)this.m_configuration).addCacheEntryListenerConfiguration(config);
        this.createAndAddListener(config);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        this.removeListener(config);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new EntryIterator(this.m_namedCache.entrySet().iterator(), this);
    }

    private void synchronizeCacheEntryListeners() {
        boolean F_LITE = false;
        if (this.m_setListenerRegistrationSynchronous.isEmpty()) {
            if (this.m_listenerSynchronous != null) {
                this.m_namedCache.removeMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove);
                this.m_listenerSynchronous = null;
            }
        } else if (this.m_listenerSynchronous == null) {
            this.m_listenerSynchronous = new LocalCacheSynchronousMapListener("coherence-jcache-adapter-localcache-synchronous-listener", this);
            this.m_namedCache.addMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove, F_LITE);
        }
        if (this.m_setListenerRegistrationAsynchronous.isEmpty()) {
            if (this.m_listenerAsynchronous != null) {
                this.m_namedCache.removeMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove);
                this.m_listenerAsynchronous = null;
            }
        } else if (this.m_listenerAsynchronous == null) {
            this.m_listenerAsynchronous = new LocalCacheAsynchronousMapListener("coherence-jcache-adapter-localcache-asynchronous-listener", this);
            this.m_namedCache.addMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove, F_LITE);
        }
    }

    private LocalCacheValue updateLocalCacheValue(JCacheContext ctx, LocalCacheValue cachedValue, Object internalValue, long ldtNow) {
        LocalCacheValue updatedCacheValue = new LocalCacheValue(cachedValue);
        return updatedCacheValue.updateInternalValue(internalValue, ldtNow, ctx.getExpiryPolicy());
    }

    private V getValue(K key, CoherenceCacheEventEventDispatcher<K, V> dispatcher) throws Exception {
        boolean isExpired;
        long ldtNow = Helper.getCurrentTimeMillis();
        long ldtStart = this.isStatisticsEnabled() ? ldtNow : 0L;
        Object internalKey = this.m_converterKey.toInternal(key);
        Object value = null;
        LocalCacheValue cachedValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
        boolean bl = isExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
        if (cachedValue == null || isExpired) {
            V expiredValue;
            V v = expiredValue = isExpired ? (V)this.m_converterValue.fromInternal(cachedValue.get()) : null;
            if (isExpired) {
                this.processExpiries(key, expiredValue, dispatcher);
                this.dispatch(dispatcher);
            }
            if (this.isStatisticsEnabled()) {
                this.getStatistics().registerMisses(1, ldtStart);
            }
            if (((LocalCacheConfiguration)this.m_configuration).isReadThrough() && this.m_ctx.getCacheLoader() != null) {
                try {
                    value = this.m_ctx.getCacheLoader().load(key);
                }
                catch (Exception e) {
                    if (!(e instanceof CacheLoaderException)) {
                        throw new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (value == null) {
                return null;
            }
            Object internalValue = this.m_converterValue.toInternal(value);
            cachedValue = LocalCacheValue.createLoadedLocalCacheValue(internalValue, ldtNow, this.m_ctx.getExpiryPolicy());
            if (cachedValue.isExpiredAt(ldtNow)) {
                return null;
            }
            this.m_namedCache.put(internalKey, (Object)cachedValue);
        } else {
            value = this.m_converterValue.fromInternal(cachedValue.getInternalValue(ldtNow));
            cachedValue.accessInternalValue(ldtNow, this.m_ctx.getExpiryPolicy());
            this.m_namedCache.put(internalKey, (Object)cachedValue);
            if (this.isStatisticsEnabled()) {
                this.m_ctx.getStatistics().registerHits(1, ldtStart);
            }
        }
        return (V)value;
    }

    private String getInternalCacheName() {
        return this.m_cacheId.getCanonicalCacheName();
    }

    private void submit(Runnable task) {
        ExecutorService newExeSvc;
        boolean fSetResult;
        if (this.isClosed()) {
            return;
        }
        if (this.m_refExecutorService.get() == null && !(fSetResult = this.m_refExecutorService.compareAndSet(null, newExeSvc = Executors.newFixedThreadPool(20)))) {
            newExeSvc.shutdown();
        }
        this.m_refExecutorService.get().submit(task);
    }

    private void put(K key, V value, boolean fUseWriteThrough) {
        boolean isOldEntryExpired;
        int putCount = 0;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
        long ldtNow = Helper.getCurrentTimeMillis();
        long start = this.isStatisticsEnabled() ? ldtNow : 0L;
        Object internalKey = this.m_converterKey.toInternal(key);
        Object internalValue = this.m_converterValue.toInternal(value);
        LocalCacheValue cachedValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
        boolean bl = isOldEntryExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
        if (isOldEntryExpired) {
            this.processExpiries(key, dispatcher);
        }
        if (cachedValue == null || isOldEntryExpired) {
            if (fUseWriteThrough) {
                this.writeCacheEntry(new CoherenceCacheEntry<K, V>(key, value));
            }
            if (!(cachedValue = LocalCacheValue.createLocalCacheValue(internalValue, ldtNow, this.getContext().getExpiryPolicy())).isExpiredAt(ldtNow)) {
                this.m_namedCache.put(internalKey, (Object)cachedValue);
                ++putCount;
            }
        } else {
            V oldValue = this.m_converterValue.fromInternal(cachedValue.get());
            CoherenceCacheEntry<K, V> entry = new CoherenceCacheEntry<K, V>(key, value, oldValue);
            if (fUseWriteThrough) {
                this.writeCacheEntry(entry);
            }
            this.m_namedCache.put(internalKey, (Object)this.updateLocalCacheValue(this.m_ctx, cachedValue, internalValue, ldtNow));
            ++putCount;
        }
        this.dispatch(dispatcher);
        if (this.isStatisticsEnabled() && putCount > 0) {
            this.m_ctx.getStatistics().registerPuts(putCount, Helper.getCurrentTimeMillis() - start);
        }
    }

    private boolean putIfAbsent(K key, V value, boolean fUseWriteThrough) {
        boolean isOldEntryExpired;
        int putCount = 0;
        int missCount = 0;
        int hitCount = 0;
        boolean result = false;
        this.ensureOpen();
        if (value == null) {
            throw new NullPointerException("null value specified for key " + key);
        }
        if (key == null) {
            throw new NullPointerException("null key provided");
        }
        CoherenceCacheEventEventDispatcher dispatcher = new CoherenceCacheEventEventDispatcher();
        long ldtNow = Helper.getCurrentTimeMillis();
        long start = this.isStatisticsEnabled() ? ldtNow : 0L;
        Object internalKey = this.m_converterKey.toInternal(key);
        Object internalValue = this.m_converterValue.toInternal(value);
        LocalCacheValue cachedValue = (LocalCacheValue)this.m_namedCache.get(internalKey);
        boolean bl = isOldEntryExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
        if (isOldEntryExpired) {
            this.processExpiries(key, dispatcher);
        }
        if (cachedValue == null || isOldEntryExpired) {
            if (fUseWriteThrough) {
                this.writeCacheEntry(new CoherenceCacheEntry<K, V>(key, value));
            }
            if ((cachedValue = LocalCacheValue.createLocalCacheValue(internalValue, ldtNow, this.getContext().getExpiryPolicy())).isExpiredAt(ldtNow)) {
                result = false;
            } else {
                result = true;
                this.m_namedCache.put(internalKey, (Object)cachedValue);
                ++putCount;
                ++missCount;
            }
        } else {
            result = false;
            ++hitCount;
        }
        this.dispatch(dispatcher);
        if (this.isStatisticsEnabled()) {
            if (putCount > 0) {
                this.m_ctx.getStatistics().registerPuts(putCount, start);
                this.m_ctx.getStatistics().registerMisses(missCount, start);
            }
            if (hitCount > 0) {
                this.m_ctx.getStatistics().registerHits(hitCount, start);
            }
        }
        return result;
    }

    private void createAndAddListener(CacheEntryListenerConfiguration<K, V> configuration) {
        CoherenceCacheEntryListenerRegistration<K, V> registration = new CoherenceCacheEntryListenerRegistration<K, V>(configuration);
        if (configuration.isSynchronous()) {
            this.m_setListenerRegistrationSynchronous.add(registration);
        } else {
            this.m_setListenerRegistrationAsynchronous.add(registration);
        }
        this.synchronizeCacheEntryListeners();
    }

    private void removeListener(CacheEntryListenerConfiguration<K, V> configListener) {
        if (configListener == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> setListeners = configListener.isSynchronous() ? this.m_setListenerRegistrationSynchronous : this.m_setListenerRegistrationAsynchronous;
        for (CoherenceCacheEntryListenerRegistration<K, V> listenerRegistration : setListeners) {
            if (!configListener.equals(listenerRegistration.getConfiguration())) continue;
            setListeners.remove(listenerRegistration);
            ((LocalCacheConfiguration)this.m_configuration).getCacheEntryListenerConfigurations().remove(configListener);
        }
        this.synchronizeCacheEntryListeners();
    }

    private Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return ((LocalCacheConfiguration)this.m_configuration).isReadThrough() ? ((LocalCacheConfiguration)this.m_configuration).getCacheLoaderFactory() : null;
    }

    private Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return ((LocalCacheConfiguration)this.m_configuration).isWriteThrough() ? ((LocalCacheConfiguration)this.m_configuration).getCacheWriterFactory() : null;
    }

    private <T> Constructor<T> getClassCtor(Class<T> clz) {
        Class[] argTypes = new Class[]{Throwable.class};
        Constructor<T> result = null;
        try {
            result = clz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private <T extends RuntimeException> RuntimeException handleException(Exception exception, Class<T> clzException) {
        Throwable t = exception;
        if (exception instanceof WrapperException && (t = exception.getCause()) instanceof Error) {
            throw (Error)t;
        }
        if (clzException.isInstance(t)) {
            return (RuntimeException)t;
        }
        Constructor<T> ctor = this.getClassCtor(clzException);
        Object[] args = new Object[]{t};
        RuntimeException eResult = null;
        if (ctor != null) {
            try {
                eResult = (RuntimeException)ctor.newInstance(args);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return eResult;
    }

    private void writeCacheEntry(Cache.Entry<K, V> entry) {
        if (((LocalCacheConfiguration)this.m_configuration).isWriteThrough()) {
            try {
                this.m_ctx.getCacheWriter().write(entry);
            }
            catch (Exception e) {
                throw this.handleException(e, CacheWriterException.class);
            }
        }
    }

    private void deleteCacheEntry(K key) {
        if (((LocalCacheConfiguration)this.m_configuration).isWriteThrough()) {
            try {
                this.m_ctx.getCacheWriter().delete(key);
            }
            catch (Exception e) {
                throw this.handleException(e, CacheWriterException.class);
            }
        }
    }

    private void putAll(Map<? extends K, ? extends V> map, boolean fReplaceExistingValues, boolean fUseWriteThrough) {
        this.ensureOpen();
        if (map == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (fReplaceExistingValues) {
                this.put(entry.getKey(), entry.getValue(), fUseWriteThrough);
                continue;
            }
            this.putIfAbsent(entry.getKey(), entry.getValue(), fUseWriteThrough);
        }
    }

    @Override
    public JCacheIdentifier getIdentifier() {
        return this.m_cacheId;
    }

    @Override
    public void destroy() {
        JCacheContext.unregister(this.m_manager.getConfigurableCacheFactory().getResourceRegistry(), this.m_cacheId);
        this.m_manager.removeCacheToConfigurationMapping(this.m_cacheId);
        this.m_manager.getConfigurableCacheFactory().destroyCache(this.m_namedCache);
    }

    public String toString() {
        return this.m_sJCacheName;
    }

    public static class EntryIterator<K, V>
    extends WrapperCollections.AbstractWrapperIterator {
        private final LocalCache<K, V> m_cache;
        private Map.Entry<K, V> m_entryLast = null;
        private Map.Entry<K, V> m_entryNext = null;
        private CoherenceCacheEventEventDispatcher<K, V> m_dispatcher = new CoherenceCacheEventEventDispatcher();

        public EntryIterator(Iterator<Map.Entry<K, V>> iter, LocalCache<K, V> cache) {
            super(iter);
            this.m_cache = cache;
        }

        public boolean hasNext() {
            if (this.m_entryNext == null) {
                this.fetch();
            }
            return this.m_entryNext != null;
        }

        public Cache.Entry<K, V> next() {
            if (this.hasNext()) {
                this.m_entryLast = this.m_entryNext;
                this.m_entryNext = null;
                return new CoherenceCacheEntry(((LocalCache)this.m_cache).m_converterKey.fromInternal(this.m_entryLast.getKey()), ((LocalCache)this.m_cache).m_converterValue.fromInternal(((LocalCacheValue)this.m_entryLast.getValue()).getInternalValue(Helper.getCurrentTimeMillis())));
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.m_entryLast == null) {
                throw new IllegalStateException("Must progress to the next m_entry to remove");
            }
            this.m_cache.remove(((LocalCache)this.m_cache).m_converterKey.fromInternal(this.m_entryLast.getKey()));
        }

        private void fetch() {
            while (this.m_entryNext == null && super.hasNext()) {
                Map.Entry entry = (Map.Entry)super.next();
                Object key = ((LocalCache)this.m_cache).m_converterKey.fromInternal(entry.getKey());
                Object value = null;
                try {
                    value = ((LocalCache)this.m_cache).getValue(key, this.m_dispatcher);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                this.m_entryNext = entry;
            }
        }
    }
}

