/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.coherence.jcache.AbstractCoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.net.management.MBeanHelper;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class MBeanServerRegistrationUtility {
    private MBeanServerRegistrationUtility() {
    }

    public static void registerCacheObject(AbstractCoherenceBasedCache cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = MBeanHelper.findMBeanServer();
        ObjectName registeredObjectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        try {
            switch (objectNameType) {
                case Configuration: {
                    if (!MBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                        mBeanServer.registerMBean(cache.getMBean(), registeredObjectName);
                    }
                    break;
                }
                case Statistics: {
                    if (!MBeanServerRegistrationUtility.isRegistered(cache, objectNameType)) {
                        mBeanServer.registerMBean(cache.getStatistics(), registeredObjectName);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("registerCacheObject ObjectNameType=" + (Object)((Object)objectNameType));
                }
            }
        }
        catch (Exception e) {
            throw new CacheException("Error registering cache MXBeans for CacheManager " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isRegistered(Cache cache, ObjectNameType objectNameType) {
        ObjectName objectName;
        MBeanServer mBeanServer = MBeanHelper.findMBeanServer();
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType), null);
        return !registeredObjectNames.isEmpty();
    }

    public static void unregisterCacheObject(Cache cache, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = MBeanHelper.findMBeanServer();
        ObjectName objectName = MBeanServerRegistrationUtility.calculateObjectName(cache, objectNameType);
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void unregisterCacheObject(CoherenceBasedCacheManager mgr, JCacheIdentifier id, ObjectNameType objectNameType) {
        MBeanServer mBeanServer = MBeanHelper.findMBeanServer();
        ObjectName objectName = MBeanServerRegistrationUtility.calculateObjectName(mgr, id, objectNameType);
        Set<ObjectName> registeredObjectNames = mBeanServer.queryNames(objectName, null);
        for (ObjectName registeredObjectName : registeredObjectNames) {
            try {
                mBeanServer.unregisterMBean(registeredObjectName);
            }
            catch (Exception e) {
                throw new CacheException("Error unregistering object instance " + registeredObjectName + " . Error was " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static ObjectName calculateObjectName(Cache cache, ObjectNameType objectNameType) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("javax.cache:type=Cache").append((Object)objectNameType).append(",CacheManager=").append(MBeanServerRegistrationUtility.mbeanSafe(cache.getCacheManager().getURI().toString())).append(",Cache=").append(MBeanServerRegistrationUtility.mbeanSafe(cache.getName()));
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static ObjectName calculateObjectName(CoherenceBasedCacheManager mgr, JCacheIdentifier id, ObjectNameType objectNameType) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("javax.cache:type=Cache").append((Object)objectNameType).append(",CacheManager=").append(MBeanServerRegistrationUtility.mbeanSafe(id.getCacheManagerURI())).append(",Cache=").append(MBeanServerRegistrationUtility.mbeanSafe(id.getName()));
            return new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static String mbeanSafe(String string) {
        return string == null ? "" : string.replaceAll(":|=|\n", ".");
    }

    private static String getMBeanServerName(MBeanServer mbs) {
        try {
            return (String)mbs.getAttribute(MBeanServerDelegate.DELEGATE_NAME, "MBeanServerId");
        }
        catch (JMException e) {
            return null;
        }
    }

    public static enum ObjectNameType {
        Statistics,
        Configuration;

    }
}

