/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.SerializingInternalConverter;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ResourceRegistry;
import java.io.Closeable;
import java.io.IOException;

public class PartitionedCacheConfigurationMapListener
extends AbstractMapListener
implements MapListenerSupport.SynchronousListener {
    private ResourceRegistry m_registry;
    private SerializingInternalConverter<String> m_converterKey;

    public void entryDeleted(MapEvent evt) {
        int CLOSE_EXCEPTION_LOG_LEVEL = 5;
        JCacheIdentifier jcacheId = this.getJCacheIdentifierFromKey(evt);
        JCacheContext ctx = JCacheContext.getContext(this.m_registry, jcacheId);
        if (ctx != null) {
            block13: {
                block12: {
                    block11: {
                        if (ctx.getCacheLoader() instanceof Closeable) {
                            try {
                                ((Closeable)ctx.getCacheLoader()).close();
                            }
                            catch (IOException e) {
                                if (!CacheFactory.isLogEnabled((int)5)) break block11;
                                CacheFactory.log((String)("handled unexpected exception in closable CacheLoader : " + Base.printStackTrace((Throwable)e)), (int)5);
                            }
                        }
                    }
                    if (ctx.getCacheWriter() instanceof Closeable) {
                        try {
                            ((Closeable)ctx.getCacheWriter()).close();
                        }
                        catch (IOException e) {
                            if (!CacheFactory.isLogEnabled((int)5)) break block12;
                            CacheFactory.log((String)("handled unexpected exception in closable CacheWriter : " + Base.printStackTrace((Throwable)e)), (int)5);
                        }
                    }
                }
                if (ctx.getExpiryPolicy() instanceof Closeable) {
                    try {
                        ((Closeable)ctx.getExpiryPolicy()).close();
                    }
                    catch (IOException e) {
                        if (!CacheFactory.isLogEnabled((int)5)) break block13;
                        CacheFactory.log((String)("handled unexpected exception in closable ExpiryPolicy : " + Base.printStackTrace((Throwable)e)), (int)5);
                    }
                }
            }
            JCacheContext.unregister(this.m_registry, jcacheId);
        }
        if (CacheFactory.isLogEnabled((int)9)) {
            String unregisterLogMessage = ctx == null ? " no JCacheContext found in registry " + this.m_registry : " unregister JCacheContext from resource registry " + this.m_registry;
            CacheFactory.log((String)("PartitionedCacheConfigurationMap: entryDeleted event JCacheId=" + jcacheId + unregisterLogMessage + " configuration=" + evt.getOldValue()), (int)9);
        }
    }

    @Injectable
    public void setResourceRegistry(ResourceRegistry registry) {
        this.m_registry = registry;
    }

    private JCacheIdentifier getJCacheIdentifierFromKey(MapEvent mapEvent) {
        String sJCacheId = null;
        Object key = mapEvent.getKey();
        if (key instanceof String) {
            sJCacheId = (String)key;
        } else if (key instanceof Binary) {
            if (this.m_converterKey == null) {
                SerializerFactory factorySerializer = (SerializerFactory)this.m_registry.getResource(SerializerFactory.class, "serializer");
                Serializer serializer = factorySerializer == null ? ExternalizableHelper.ensureSerializer(null) : factorySerializer.createSerializer(null);
                this.m_converterKey = new SerializingInternalConverter(serializer);
            }
            sJCacheId = this.m_converterKey.fromInternal(key);
        }
        return new JCacheIdentifier(sJCacheId);
    }
}

