/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntryEventFilteringIterable;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryListenerRegistration;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;

public class CoherenceCacheEventEventDispatcher<K, V> {
    private ConcurrentHashMap<Class<? extends CacheEntryListener>, ArrayList<CacheEntryEvent<K, V>>> m_mapEvt = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Class<? extends CacheEntryListener> listenerClass, CacheEntryEvent<K, V> event) {
        ArrayList<Object> listEvt;
        if (listenerClass == null) {
            throw new NullPointerException("listenerClass can't be null");
        }
        if (event == null) {
            throw new NullPointerException("event can't be null");
        }
        if (!listenerClass.isInterface() || !CacheEntryListener.class.isAssignableFrom(listenerClass)) {
            throw new IllegalArgumentException("listenerClass must be an CacheEntryListener interface");
        }
        CoherenceCacheEventEventDispatcher coherenceCacheEventEventDispatcher = this;
        synchronized (coherenceCacheEventEventDispatcher) {
            ArrayList<Object> previous;
            listEvt = this.m_mapEvt.get(listenerClass);
            if (listEvt == null && (previous = this.m_mapEvt.putIfAbsent(listenerClass, listEvt = new ArrayList())) != null) {
                listEvt = previous;
            }
        }
        listEvt.add(event);
    }

    public void dispatch(Iterable<CoherenceCacheEntryListenerRegistration<K, V>> registrations) {
        CacheEntryListener<K, V> listener;
        Iterable iterable;
        CacheEntryEventFilter<K, V> filter;
        Iterable events = this.m_mapEvt.get(CacheEntryExpiredListener.class);
        if (events != null) {
            for (CoherenceCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable2 = iterable = filter == null ? events : new CoherenceCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryExpiredListener)) continue;
                try {
                    ((CacheEntryExpiredListener)listener).onExpired(iterable);
                }
                catch (Throwable e) {
                    this.logListenerException(listener, e, "CacheEntryExpiredListener");
                }
            }
        }
        if ((events = (Iterable)this.m_mapEvt.get(CacheEntryCreatedListener.class)) != null) {
            for (CoherenceCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable3 = iterable = filter == null ? events : new CoherenceCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryCreatedListener)) continue;
                try {
                    ((CacheEntryCreatedListener)listener).onCreated(iterable);
                }
                catch (Throwable e) {
                    this.logListenerException(listener, e, "CacheEntryCreatedListener");
                }
            }
        }
        if ((events = (Iterable)this.m_mapEvt.get(CacheEntryUpdatedListener.class)) != null) {
            for (CoherenceCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable4 = iterable = filter == null ? events : new CoherenceCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryUpdatedListener)) continue;
                try {
                    ((CacheEntryUpdatedListener)listener).onUpdated(iterable);
                }
                catch (Throwable e) {
                    this.logListenerException(listener, e, "CacheEntryUpdatedListener");
                }
            }
        }
        if ((events = (Iterable)this.m_mapEvt.get(CacheEntryRemovedListener.class)) != null) {
            for (CoherenceCacheEntryListenerRegistration<K, V> registration : registrations) {
                filter = registration.getCacheEntryFilter();
                Iterable iterable5 = iterable = filter == null ? events : new CoherenceCacheEntryEventFilteringIterable<K, V>(events, filter);
                listener = registration.getCacheEntryListener();
                if (!(listener instanceof CacheEntryRemovedListener)) continue;
                try {
                    ((CacheEntryRemovedListener)listener).onRemoved(iterable);
                }
                catch (Throwable e) {
                    this.logListenerException(listener, e, "CacheEntryRemovedListener");
                }
            }
        }
    }

    private void logListenerException(CacheEntryListener listener, Throwable e, String sDescription) {
        if (CacheFactory.isLogEnabled((int)2)) {
            CacheFactory.log((String)("handled unexpected exception in registered " + sDescription + ": " + listener.getClass().getCanonicalName() + "\n" + Base.printStackTrace((Throwable)e)), (int)2);
        }
    }
}

