/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.serialization;

import com.tangosol.coherence.jcache.Constants;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import java.io.IOException;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;

public class ExpiryPolicyPofSerializer
implements PofSerializer {
    public void serialize(PofWriter pofWriter, Object o) throws IOException {
        Duration d = null;
        if (o instanceof AccessedExpiryPolicy) {
            pofWriter.writeString(0, "AccessedExpiryPolicy");
            try {
                d = ((AccessedExpiryPolicy)o).getExpiryForAccess();
            }
            catch (Throwable e) {
                CacheFactory.log((String)("handled unexpected exception in user-provided ExpiryPolicy:\n" + Base.printStackTrace((Throwable)e)), (int)2);
            }
            pofWriter.writeObject(1, (Object)d);
        } else if (o instanceof ModifiedExpiryPolicy) {
            pofWriter.writeString(0, "ModifiedExpiryPolicy");
            try {
                d = ((ModifiedExpiryPolicy)o).getExpiryForUpdate();
            }
            catch (Throwable e) {
                CacheFactory.log((String)("handled unexpected exception in user-provided ExpiryPolicy:\n" + Base.printStackTrace((Throwable)e)), (int)2);
            }
            pofWriter.writeObject(1, (Object)d);
        } else if (o instanceof EternalExpiryPolicy) {
            pofWriter.writeString(0, "EternalExpiryPolicy");
        } else if (o instanceof TouchedExpiryPolicy) {
            pofWriter.writeString(0, "TouchedExpiryPolicy");
            try {
                d = ((TouchedExpiryPolicy)o).getExpiryForAccess();
            }
            catch (Throwable e) {
                CacheFactory.log((String)("handled unexpected exception in user-provided ExpiryPolicy:\n" + Base.printStackTrace((Throwable)e)), (int)2);
            }
            pofWriter.writeObject(1, (Object)d);
        } else if (o instanceof CreatedExpiryPolicy) {
            pofWriter.writeString(0, "CreatedExpiryPolicy");
            try {
                d = ((CreatedExpiryPolicy)o).getExpiryForCreation();
            }
            catch (Throwable e) {
                d = Constants.DEFAULT_EXPIRY_DURATION;
                CacheFactory.log((String)("defaulting to implemention-specifc ExpiryForCreation default due to handling unexpected exception in user-provided ExpiryPolicy:\n" + Base.printStackTrace((Throwable)e)), (int)2);
            }
            pofWriter.writeObject(1, (Object)d);
        } else {
            pofWriter.writeString(0, "CustomExpiryPolicy");
            pofWriter.writeObject(1, o);
        }
        pofWriter.writeRemainder(null);
    }

    public Object deserialize(PofReader pofReader) throws IOException {
        String sExpiryPolicyClassName = pofReader.readString(0);
        if ("AccessedExpiryPolicy".equals(sExpiryPolicyClassName)) {
            Duration d = (Duration)pofReader.readObject(1);
            pofReader.readRemainder();
            return new AccessedExpiryPolicy(d);
        }
        if ("ModifiedExpiryPolicy".equals(sExpiryPolicyClassName)) {
            Duration d = (Duration)pofReader.readObject(1);
            pofReader.readRemainder();
            return new ModifiedExpiryPolicy(d);
        }
        if ("EternalExpiryPolicy".equals(sExpiryPolicyClassName)) {
            pofReader.readRemainder();
            return new EternalExpiryPolicy();
        }
        if ("TouchedExpiryPolicy".equals(sExpiryPolicyClassName)) {
            Duration d = (Duration)pofReader.readObject(1);
            pofReader.readRemainder();
            return new TouchedExpiryPolicy(d);
        }
        if ("CreatedExpiryPolicy".equals(sExpiryPolicyClassName)) {
            Duration d = (Duration)pofReader.readObject(1);
            pofReader.readRemainder();
            return new CreatedExpiryPolicy(d);
        }
        if ("CustomExpiryPolicy".equals(sExpiryPolicyClassName)) {
            Object o = pofReader.readObject(1);
            pofReader.readRemainder();
            return o;
        }
        throw new IOException("Unknown type of expiry policy [" + sExpiryPolicyClassName + "]");
    }
}

