/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.client.BaseGrpcClient;
import com.oracle.coherence.client.DeactivationListener;
import com.oracle.coherence.client.FutureStreamObserver;
import com.oracle.coherence.client.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.client.GrpcRemoteCacheService;
import com.oracle.coherence.client.NamedCacheClient;
import com.oracle.coherence.client.NamedCacheGrpcClient;
import com.oracle.coherence.client.RemoteEntrySet;
import com.oracle.coherence.client.RemoteKeySet;
import com.oracle.coherence.client.RemoteValues;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.ContainsEntryRequest;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.InvokeAllRequest;
import com.oracle.coherence.grpc.MapEventResponse;
import com.oracle.coherence.grpc.MapListenerErrorResponse;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.MapListenerResponse;
import com.oracle.coherence.grpc.MapListenerSubscribedResponse;
import com.oracle.coherence.grpc.MapListenerUnsubscribedResponse;
import com.oracle.coherence.grpc.OptionalValue;
import com.oracle.coherence.grpc.Requests;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import io.grpc.Channel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AsyncNamedCacheClient<K, V>
extends BaseGrpcClient<V>
implements AsyncNamedCache<K, V> {
    protected static final Void VOID = null;
    protected final NamedCacheGrpcClient f_service;
    protected final NamedCacheClient<K, V> f_synchronousCache;
    protected final List<DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>>> f_listDeactivationListeners;
    protected final List<NamedCacheDeactivationListener> f_listCacheDeactivationListeners = new ArrayList<NamedCacheDeactivationListener>();
    protected final Lock f_lockDeactivationListeners = new ReentrantLock();
    protected EventStreamObserver m_evtResponseObserver;
    protected MapListenerSupport m_listenerSupport;
    protected LongArray<Filter<?>> m_aEvtFilter;
    private final AtomicInteger f_cListener = new AtomicInteger(0);
    private GrpcRemoteCacheService m_cacheService;

    public AsyncNamedCacheClient(Dependencies dependencies) {
        super(dependencies);
        this.f_synchronousCache = new NamedCacheClient(this);
        this.f_listDeactivationListeners = new ArrayList<DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>>>();
        this.f_service = dependencies.getClient().orElseGet(() -> new NamedCacheGrpcClient(dependencies));
        this.initEvents();
    }

    public String toString() {
        return "AsyncNamedCacheClient{scope: \"" + this.f_sScopeName + "\"name: \"" + this.f_sName + "\" format: \"" + this.f_sFormat + "\"}";
    }

    public NamedCache<K, V> getNamedCache() {
        return this.getNamedCacheClient();
    }

    public NamedMap<K, V> getNamedMap() {
        return this.getNamedCacheClient();
    }

    public <R> CompletableFuture<R> aggregate(Collection<? extends K> colKeys, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.executeIfActive(() -> {
            try {
                List keys = colKeys.stream().map(this::toByteString).collect(Collectors.toList());
                long nDeadline = 0L;
                if (entryAggregator instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryAggregator).getRequestTimeoutMillis();
                }
                return this.f_service.aggregate(Requests.aggregate((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, keys, (ByteString)this.toByteString(entryAggregator)), nDeadline).thenApplyAsync(this::fromBytesValue).thenApply(r -> r).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<R> aggregate(Filter<?> filter, InvocableMap.EntryAggregator<? super K, ? super V, R> entryAggregator) {
        return this.executeIfActive(() -> {
            try {
                long nDeadline = 0L;
                if (entryAggregator instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryAggregator).getRequestTimeoutMillis();
                }
                return this.f_service.aggregate(Requests.aggregate((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(filter), (ByteString)this.toByteString(entryAggregator)), nDeadline).thenApplyAsync(this::fromBytesValue).thenApply(r -> r).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<R> invoke(K k, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        return this.executeIfActive(() -> {
            try {
                long nDeadline = 0L;
                if (entryProcessor instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)entryProcessor).getRequestTimeoutMillis();
                }
                return this.f_service.invoke(Requests.invoke((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(k), (ByteString)this.toByteString(entryProcessor)), nDeadline).thenApplyAsync(this::valueFromBytesValue).thenApply(r -> r).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Map, Map> function = (e, m) -> {
                    try {
                        m.put(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()));
                        return m;
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                        return null;
                    }
                };
                FutureStreamObserver<Entry, Map> observer = new FutureStreamObserver<Entry, Map>(future, new HashMap(), function);
                Collection serializedKeys = colKeys.stream().map(this::toByteString).collect(Collectors.toList());
                long nDeadline = 0L;
                if (processor instanceof PriorityTask) {
                    nDeadline = ((PriorityTask)processor).getRequestTimeoutMillis();
                }
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (Iterable)serializedKeys, (ByteString)this.toByteString(processor)), observer, nDeadline);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Map, Map> function = (e, m) -> {
                    try {
                        m.put(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()));
                        return m;
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                        return null;
                    }
                };
                FutureStreamObserver<Entry, Map> observer = new FutureStreamObserver<Entry, Map>(future, new HashMap(), function);
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(filter), (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        SimpleMapEntry entry = new SimpleMapEntry(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()));
                        callback.accept((Object)entry);
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return null;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                Collection serializedKeys = colKeys.stream().map(this::toByteString).collect(Collectors.toList());
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (Iterable)serializedKeys, (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        SimpleMapEntry entry = new SimpleMapEntry(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()));
                        callback.accept((Object)entry);
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return null;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(filter), (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Void> clear() {
        return this.executeIfActive(() -> {
            try {
                return this.f_service.clear(Requests.clear((String)this.f_sScopeName, (String)this.f_sName)).thenApply(e -> VOID).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.executeIfActive(() -> this.containsKeyInternal(key));
    }

    public CompletableFuture<Set<Map.Entry<K, V>>> entrySet() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteEntrySet(this)));
    }

    public CompletableFuture<V> get(K key) {
        return this.executeIfActive(() -> this.getInternal(key, null));
    }

    public CompletableFuture<Map<K, V>> getAll(Collection<? extends K> colKeys) {
        return this.executeIfActive(() -> {
            if (colKeys.isEmpty()) {
                return CompletableFuture.completedFuture(new HashMap());
            }
            return CompletableFuture.supplyAsync(() -> this.getAllInternalAsMap(colKeys));
        });
    }

    public CompletableFuture<V> getOrDefault(K key, V defaultValue) {
        return this.executeIfActive(() -> this.getInternal(key, defaultValue));
    }

    public <R> CompletableFuture<Map<K, R>> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                InvokeAllBiFunction function = new InvokeAllBiFunction(future);
                FutureStreamObserver observer = new FutureStreamObserver(future, new HashMap(), function);
                ByteString filter = this.toByteString(AlwaysFilter.INSTANCE());
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, Consumer<? super Map.Entry<? extends K, ? extends R>> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        SimpleMapEntry entry = new SimpleMapEntry(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()));
                        callback.accept((Object)entry);
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return null;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                ByteString filter = this.toByteString(AlwaysFilter.INSTANCE());
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        callback.accept((K)this.fromByteString(e.getKey()), (Object)this.fromByteString(e.getValue()));
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return null;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                ByteString filter = this.toByteString(AlwaysFilter.INSTANCE());
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filter, (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Collection<? extends K> colKeys, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        callback.accept((K)this.fromByteString(e.getKey()), (Object)this.fromByteString(e.getValue()));
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return null;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                Collection keys = colKeys.stream().map(this::toByteString).collect(Collectors.toList());
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (Iterable)keys, (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public <R> CompletableFuture<Void> invokeAll(Filter<?> filter, InvocableMap.EntryProcessor<K, V, R> processor, BiConsumer<? super K, ? super R> callback) {
        return this.executeIfActive(() -> {
            try {
                CompletableFuture future = new CompletableFuture();
                BiFunction<Entry, Void, Void> function = (e, v) -> {
                    try {
                        callback.accept((K)this.fromByteString(e.getKey()), (Object)this.fromByteString(e.getValue()));
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    return VOID;
                };
                FutureStreamObserver<Entry, Void> observer = new FutureStreamObserver<Entry, Void>(future, VOID, function);
                this.invokeAllInternal(Requests.invokeAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(filter), (ByteString)this.toByteString(processor)), observer);
                return future;
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.executeIfActive(() -> this.f_service.isEmpty(Requests.isEmpty((String)this.f_sScopeName, (String)this.f_sName)).thenApply(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteKeySet(this)));
    }

    public CompletableFuture<Void> put(K key, V value) {
        return this.putInternal(key, value, 0L).thenApply(v -> VOID);
    }

    public CompletableFuture<Void> put(K key, V value, long ttl) {
        return this.putInternal(key, value, ttl).thenApply(v -> VOID);
    }

    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.executeIfActive(() -> this.f_service.putIfAbsent(Requests.putIfAbsent((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(value))).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map) {
        return this.putAllInternal(map, 0L).thenApply(v -> VOID);
    }

    public CompletableFuture<Void> putAll(Map<? extends K, ? extends V> map, long cMillis) {
        return this.putAllInternal(map, cMillis).thenApply(v -> VOID);
    }

    public CompletableFuture<V> remove(K key) {
        return this.removeInternal(key);
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.removeInternal(key, value);
    }

    public CompletableFuture<V> replace(K key, V value) {
        return this.executeIfActive(() -> this.f_service.replace(Requests.replace((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(value))).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.executeIfActive(() -> this.f_service.replaceMapping(Requests.replace((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(oldValue), (ByteString)this.toByteString(newValue))).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    public CompletableFuture<Integer> size() {
        return this.executeIfActive(() -> this.f_service.size(Requests.size((String)this.f_sScopeName, (String)this.f_sName)).thenApply(Int32Value::getValue).toCompletableFuture());
    }

    public CompletableFuture<Collection<V>> values() {
        return this.executeIfActive(() -> CompletableFuture.completedFuture(new RemoteValues(this)));
    }

    public CompletableFuture<Collection<V>> values(Filter<?> filter, Comparator<? super V> comparator) {
        return this.executeIfActive(() -> this.valuesInternal(filter, comparator));
    }

    protected Stream<Entry> getAllInternal(Collection<? extends K> colKeys) {
        this.assertActive();
        if (colKeys.isEmpty()) {
            return Stream.empty();
        }
        List keys = colKeys.stream().map(this::toByteString).collect(Collectors.toList());
        return this.f_service.getAll(Requests.getAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, keys));
    }

    protected Map<K, V> getAllInternalAsMap(Collection<? extends K> colKeys) {
        this.assertActive();
        return this.getAllInternal(colKeys).map(e -> new SimpleMapEntry(this.fromByteString(e.getKey()), this.fromByteString(e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected String getScopeName() {
        return this.f_sScopeName;
    }

    protected String getCacheName() {
        return this.f_sName;
    }

    protected CacheService getCacheService() {
        return this.m_cacheService;
    }

    protected void setCacheService(GrpcRemoteCacheService cacheService) {
        this.m_cacheService = cacheService;
    }

    protected CompletableFuture<V> getInternal(Object key, V defaultValue) {
        return this.executeIfActive(() -> this.f_service.get(Requests.get((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key))).thenApplyAsync(optional -> this.valueFromOptionalValue((OptionalValue)optional, defaultValue)).toCompletableFuture());
    }

    public NamedCacheClient<K, V> getNamedCacheClient() {
        return this.f_synchronousCache;
    }

    protected void invokeAllInternal(InvokeAllRequest request, StreamObserver<Entry> observer) {
        this.invokeAllInternal(request, observer, 0L);
    }

    protected void invokeAllInternal(InvokeAllRequest request, StreamObserver<Entry> observer, long nDeadline) {
        this.assertActive();
        this.f_service.invokeAll(request, observer, nDeadline);
    }

    protected CompletableFuture<Boolean> isActive() {
        return CompletableFuture.completedFuture(this.isActiveInternal());
    }

    protected CompletableFuture<Boolean> isReady() {
        if (this.isActiveInternal()) {
            return this.executeIfActive(() -> this.f_service.isReady(Requests.ready((String)this.f_sScopeName, (String)this.f_sName)).thenApply(BoolValue::getValue).toCompletableFuture());
        }
        return CompletableFuture.completedFuture(false);
    }

    protected CompletableFuture<V> putInternal(K key, V value, long cTtl) {
        return this.executeIfActive(() -> this.f_service.put(Requests.put((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(value), (long)cTtl)).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    protected CompletableFuture<Empty> putAllInternal(Map<? extends K, ? extends V> map, long cMillis) {
        return this.executeIfActive(() -> {
            try {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                for (Map.Entry entry : map.entrySet()) {
                    entries.add(Entry.newBuilder().setKey(this.toByteString(entry.getKey())).setValue(this.toByteString(entry.getValue())).build());
                }
                return this.f_service.putAll(Requests.putAll((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, entries, (long)cMillis)).toCompletableFuture();
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        });
    }

    public CompletableFuture<Void> release() {
        return this.executeIfActive(() -> this.releaseInternal(false));
    }

    protected <T, E> CompletableFuture<Void> removeIndex(ValueExtractor<? super T, ? extends E> valueExtractor) {
        return this.f_service.removeIndex(Requests.removeIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(valueExtractor))).thenApply(e -> VOID).toCompletableFuture();
    }

    protected CompletableFuture<V> removeInternal(Object key) {
        return this.executeIfActive(() -> this.f_service.remove(Requests.remove((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key))).thenApplyAsync(this::valueFromBytesValue).toCompletableFuture());
    }

    protected CompletableFuture<Boolean> removeInternal(Object key, Object value) {
        return this.executeIfActive(() -> this.f_service.removeMapping(Requests.remove((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(value))).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    protected CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> mapListener) {
        return this.removeMapListener(mapListener, (Filter)null);
    }

    protected CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> listener, K key) {
        return this.executeIfActive(() -> {
            MapListenerSupport support;
            MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
            synchronized (mapListenerSupport) {
                support.removeListener(listener, key);
                boolean fEmpty = support.isEmpty(key);
                boolean fPriming = MapListenerSupport.isPrimingListener((MapListener)listener);
                if (fEmpty || fPriming) {
                    String uid = "";
                    try {
                        MapListenerRequest request = Requests.removeKeyMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (boolean)fPriming, (ByteString)ByteString.EMPTY);
                        uid = request.getUid();
                        return this.m_evtResponseObserver.send(request);
                    }
                    catch (Throwable t) {
                        this.m_evtResponseObserver.removeAndComplete(uid, t);
                        return CompletableFuture.failedFuture(t);
                    }
                }
                return CompletableFuture.completedFuture(VOID);
            }
        });
    }

    protected CompletableFuture<Void> removeMapListener(MapListener<? super K, ? super V> listener, Filter<?> filter) {
        return this.executeIfActive(() -> {
            MapListenerSupport support;
            if (listener instanceof NamedCacheDeactivationListener && filter == null) {
                this.f_lockDeactivationListeners.lock();
                try {
                    if (this.f_listCacheDeactivationListeners.remove(listener)) {
                        this.f_cListener.decrementAndGet();
                    }
                }
                finally {
                    this.f_lockDeactivationListeners.unlock();
                }
                return CompletableFuture.completedFuture(VOID);
            }
            if (listener instanceof MapTriggerListener) {
                MapTriggerListener triggerListener = (MapTriggerListener)listener;
                return this.removeRemoteFilterListener(ByteString.EMPTY, 0L, this.toByteString(triggerListener.getTrigger()));
            }
            MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
            synchronized (mapListenerSupport) {
                long nId = this.getFilterId(filter);
                support.removeListener(listener, filter);
                if (support.isEmpty(filter)) {
                    return this.removeRemoteFilterListener(this.toByteString(filter), nId, ByteString.EMPTY);
                }
            }
            return CompletableFuture.completedFuture(VOID);
        });
    }

    protected CompletableFuture<Void> removeRemoteFilterListener(ByteString filterBytes, long nFilterId, ByteString triggerBytes) {
        String uid = "";
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            MapListenerRequest request = Requests.removeFilterMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filterBytes, (long)nFilterId, (boolean)false, (boolean)false, (ByteString)triggerBytes);
            uid = request.getUid();
            future = this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            future.completeExceptionally(t);
        }
        return future;
    }

    protected Stream<InvocableMap.Entry<K, V>> stream() {
        this.assertActive();
        return this.stream((Filter<V>)AlwaysFilter.INSTANCE());
    }

    protected Stream<InvocableMap.Entry<K, V>> stream(Filter<V> filter) {
        this.assertActive();
        throw new UnsupportedOperationException("method not implemented");
    }

    protected CompletableFuture<Void> truncate() {
        return this.executeIfActive(() -> this.f_service.truncate(Requests.truncate((String)this.f_sScopeName, (String)this.f_sName)).thenApply(e -> VOID).toCompletableFuture());
    }

    protected CompletableFuture<Collection<V>> valuesInternal(Filter<?> filter, Comparator comparator) {
        return this.values(filter).thenApply(colValues -> {
            ArrayList values = new ArrayList(colValues);
            values.sort(comparator);
            return values;
        });
    }

    protected CompletableFuture<Boolean> containsKeyInternal(Object oKey) {
        return this.executeIfActive(() -> this.f_service.containsKey(Requests.containsKey((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(oKey))).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    protected CompletableFuture<Boolean> containsValue(Object oValue) {
        return this.executeIfActive(() -> this.f_service.containsValue(Requests.containsValue((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(oValue))).thenApplyAsync(BoolValue::getValue).toCompletableFuture());
    }

    protected CompletableFuture<Void> destroy() {
        return this.executeIfActive(() -> this.releaseInternal(true));
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected void initEvents() {
        this.m_evtResponseObserver = new EventStreamObserver();
        this.m_listenerSupport = new MapListenerSupport();
        this.m_aEvtFilter = new SparseArray();
        CompletableFuture<Void> future = this.m_evtResponseObserver.whenSubscribed().toCompletableFuture();
        future.handle((v, err) -> {
            if (err != null) {
                this.m_evtResponseObserver.onCompleted();
            }
            return null;
        });
        long cDeadlineMillis = this.f_dependencies.getDeadline();
        try {
            future.get(cDeadlineMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RequestTimeoutException("Timed out waiting for event subscription after " + cDeadlineMillis + " ms", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    protected String getFormat() {
        return this.f_sFormat;
    }

    protected Stream<BytesValue> getKeysPage(BytesValue cookie) {
        this.assertActive();
        ByteString s = cookie == null ? null : cookie.getValue();
        return this.f_service.nextKeySetPage(Requests.page((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)s));
    }

    protected Stream<EntryResult> getEntriesPage(ByteString cookie) {
        this.assertActive();
        return this.f_service.nextEntrySetPage(Requests.page((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)cookie));
    }

    protected boolean containsEntry(K key, V value) {
        this.assertActive();
        try {
            ContainsEntryRequest request = Requests.containsEntry((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (ByteString)this.toByteString(value));
            CompletionStage<BoolValue> stage = this.f_service.containsEntry(request);
            BoolValue boolValue = stage.toCompletableFuture().get();
            return boolValue != null && boolValue.getValue();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    protected void assertActive() {
        if (this.m_fReleased || this.m_fDestroyed) {
            String reason = this.m_fDestroyed ? "destroyed" : "released";
            throw new IllegalStateException("remote cache '" + this.f_sName + "' has been " + reason);
        }
    }

    protected <T> CompletableFuture<T> executeIfActive(Supplier<CompletableFuture<T>> supplier) {
        if (!this.m_fReleased && !this.m_fDestroyed) {
            try {
                return supplier.get().handle(AsyncNamedCacheClient::handleException);
            }
            catch (Throwable t) {
                return this.failedFuture(t);
            }
        }
        String reason = this.m_fDestroyed ? "destroyed" : "released";
        return this.failedFuture(new IllegalStateException("remote cache '" + this.f_sName + "' has been " + reason));
    }

    protected synchronized CompletableFuture<Void> releaseInternal(boolean destroy) {
        CompletableFuture<Void> future;
        if (this.m_evtResponseObserver != null) {
            this.m_evtResponseObserver.onCompleted();
        }
        this.f_cListener.set(0);
        if (!this.m_fDestroyed && !this.m_fReleased) {
            if (destroy) {
                this.m_fDestroyed = true;
                future = this.f_service.destroy(Requests.destroy((String)this.f_sScopeName, (String)this.f_sName)).thenApply(e -> VOID).toCompletableFuture();
            } else {
                this.m_fReleased = true;
                future = CompletableFuture.completedFuture(VOID);
            }
        } else {
            future = CompletableFuture.completedFuture(VOID);
        }
        return future.handleAsync((v, err) -> {
            for (DeactivationListener<AsyncNamedCacheClient<K, V>> listener : this.f_listDeactivationListeners) {
                try {
                    if (destroy) {
                        listener.destroyed(this);
                        continue;
                    }
                    listener.released(this);
                }
                catch (Throwable t) {
                    Logger.err((Throwable)t);
                }
            }
            this.f_listDeactivationListeners.clear();
            CacheEvent evt = this.createDeactivationEvent(true);
            for (NamedCacheDeactivationListener listener : this.f_listCacheDeactivationListeners) {
                try {
                    listener.entryDeleted(evt);
                }
                catch (Throwable t) {
                    Logger.err((Throwable)t);
                }
            }
            this.f_listCacheDeactivationListeners.clear();
            if (err != null) {
                throw Base.ensureRuntimeException((Throwable)err);
            }
            return VOID;
        });
    }

    protected <Ke, Ve> CacheEvent<Ke, Ve> createDeactivationEvent(boolean destroyed) {
        return new CacheEvent(this.getNamedCache(), destroyed ? 3 : 2, null, null, null, true);
    }

    public void addDeactivationListener(DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> listener) {
        this.assertActive();
        this.f_lockDeactivationListeners.lock();
        try {
            if (listener != null) {
                this.f_listDeactivationListeners.add(listener);
            }
        }
        finally {
            this.f_lockDeactivationListeners.unlock();
        }
    }

    public void addDeactivationListener(NamedCacheDeactivationListener listener) {
        if (listener != null) {
            if (this.m_fReleased || this.m_fDestroyed) {
                listener.entryDeleted(this.createDeactivationEvent(this.m_fDestroyed));
            } else {
                this.f_lockDeactivationListeners.lock();
                try {
                    this.f_listCacheDeactivationListeners.add(listener);
                }
                finally {
                    this.f_lockDeactivationListeners.unlock();
                }
            }
        }
    }

    protected void removeDeactivationListener(DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> listener) {
        if (listener != null) {
            this.f_lockDeactivationListeners.lock();
            try {
                this.f_listDeactivationListeners.remove(listener);
            }
            finally {
                this.f_lockDeactivationListeners.unlock();
            }
        }
    }

    protected <T, E> CompletableFuture<Void> addIndex(ValueExtractor<? super T, ? extends E> extractor, boolean fOrdered, Comparator<? super E> comparator) {
        return this.executeIfActive(() -> {
            ByteString serializedExtractor = this.toByteString(extractor);
            if (comparator == null) {
                return this.f_service.addIndex(Requests.addIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)serializedExtractor, (boolean)fOrdered)).thenApply(e -> VOID).toCompletableFuture();
            }
            return this.f_service.addIndex(Requests.addIndex((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)serializedExtractor, (boolean)fOrdered, (ByteString)this.toByteString(comparator))).thenApply(e -> VOID).toCompletableFuture();
        });
    }

    protected CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener) {
        return this.addMapListener(mapListener, (Filter)null, false);
    }

    protected CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener, K key, boolean fLite) {
        return this.executeIfActive(() -> {
            try {
                return this.addKeyMapListener(mapListener, key, fLite);
            }
            catch (Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        });
    }

    protected CompletableFuture<Void> addMapListener(MapListener<? super K, ? super V> mapListener, Filter<?> filter, boolean fLite) {
        return this.executeIfActive(() -> {
            try {
                return this.addFilterMapListener(mapListener, filter, fLite);
            }
            catch (Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> addKeyMapListener(MapListener<? super K, ? super V> listener, Object key, boolean fLite) {
        MapListenerSupport support = this.getMapListenerSupport();
        boolean first = support.addListenerWithCheck(listener, key, fLite);
        boolean priming = MapListenerSupport.isPrimingListener(listener);
        if (first || priming) {
            String uid = "";
            try {
                MapListenerRequest request = Requests.addKeyMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)this.toByteString(key), (boolean)fLite, (boolean)priming, (ByteString)ByteString.EMPTY);
                uid = request.getUid();
                return this.m_evtResponseObserver.send(request);
            }
            catch (Throwable t) {
                MapListenerSupport mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    support.removeListener(listener, key);
                    this.m_evtResponseObserver.removeAndComplete(uid, t);
                }
                return CompletableFuture.failedFuture(t);
            }
        }
        return CompletableFuture.completedFuture(VOID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> addFilterMapListener(MapListener<? super K, ? super V> listener, Filter<?> filter, boolean fLite) {
        CompletableFuture<Void> future;
        long filterId;
        boolean first;
        boolean wasEmpty;
        MapListenerSupport support;
        if (listener instanceof NamedCacheDeactivationListener) {
            this.f_lockDeactivationListeners.lock();
            try {
                this.f_listCacheDeactivationListeners.add((NamedCacheDeactivationListener)listener);
                this.f_cListener.incrementAndGet();
            }
            finally {
                this.f_lockDeactivationListeners.unlock();
            }
            return CompletableFuture.completedFuture(VOID);
        }
        if (listener instanceof MapTriggerListener) {
            MapTriggerListener triggerListener = (MapTriggerListener)listener;
            return this.addRemoteFilterListener(ByteString.EMPTY, 0L, fLite, this.toByteString(triggerListener.getTrigger()));
        }
        MapListenerSupport mapListenerSupport = support = this.getMapListenerSupport();
        synchronized (mapListenerSupport) {
            wasEmpty = support.isEmpty(filter);
            first = support.addListenerWithCheck(listener, filter, fLite);
            filterId = wasEmpty ? this.registerFilter(filter) : this.getFilterId(filter);
        }
        if (wasEmpty || first) {
            future = this.addRemoteFilterListener(this.toByteString(filter), filterId, fLite, ByteString.EMPTY);
            if (future.isCompletedExceptionally()) {
                mapListenerSupport = support;
                synchronized (mapListenerSupport) {
                    if (wasEmpty) {
                        this.m_aEvtFilter.remove(filterId);
                    }
                    support.removeListener(listener, filter);
                }
            }
        } else {
            future = CompletableFuture.completedFuture(VOID);
        }
        return future;
    }

    protected CompletableFuture<Void> addRemoteFilterListener(ByteString filterBytes, long nFilterId, boolean fLite, ByteString triggerBytes) {
        CompletableFuture<Void> future;
        String uid = "";
        try {
            MapListenerRequest request = Requests.addFilterMapListener((String)this.f_sScopeName, (String)this.f_sName, (String)this.f_sFormat, (ByteString)filterBytes, (long)nFilterId, (boolean)fLite, (boolean)false, (ByteString)triggerBytes);
            uid = request.getUid();
            future = this.m_evtResponseObserver.send(request);
        }
        catch (Throwable t) {
            this.m_evtResponseObserver.removeAndComplete(uid, t);
            future = CompletableFuture.failedFuture(t);
        }
        return future;
    }

    protected long registerFilter(Filter<?> filter) {
        if (this.m_aEvtFilter.isEmpty()) {
            this.m_aEvtFilter.set(1L, filter);
            return 1L;
        }
        return this.m_aEvtFilter.add(filter);
    }

    protected long getFilterId(Filter<?> filter) {
        LongArray.Iterator iter = this.m_aEvtFilter.iterator();
        while (iter.hasNext()) {
            Filter filterThat = (Filter)iter.next();
            if (!Base.equals(filter, (Object)filterThat)) continue;
            return iter.getIndex();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(MapEventResponse response) {
        Listeners listeners;
        List listFilterIds = response.getFilterIdsList();
        int cFilters = listFilterIds == null ? 0 : listFilterIds.size();
        int nEventId = response.getId();
        Object oKey = this.fromByteString(response.getKey());
        Object oValueOld = this.fromByteString(response.getOldValue());
        Object oValueNew = this.fromByteString(response.getNewValue());
        boolean fSynthetic = response.getSynthetic();
        boolean fPriming = response.getPriming();
        MapListenerSupport support = this.getMapListenerSupport();
        CacheEvent.TransformationState transformState = CacheEvent.TransformationState.valueOf((String)response.getTransformationState().toString());
        CacheEvent evt = null;
        Listeners listeners2 = listeners = transformState == CacheEvent.TransformationState.TRANSFORMED ? null : support.getListeners(oKey);
        if (cFilters > 0) {
            LongArray<Filter<?>> laFilters = this.m_aEvtFilter;
            ArrayList<Filter> listFilters = null;
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                for (int i = 0; i < cFilters; ++i) {
                    long lFilterId = (Long)listFilterIds.get(i);
                    if (!laFilters.exists(lFilterId)) continue;
                    Filter filter = (Filter)laFilters.get(lFilterId);
                    if (listFilters == null) {
                        listFilters = new ArrayList<Filter>(cFilters - i);
                        Listeners listenersTemp = new Listeners();
                        listenersTemp.addAll(listeners);
                        listeners = listenersTemp;
                    }
                    listFilters.add(filter);
                    listeners.addAll(support.getListeners(filter));
                }
            }
            if (listFilters != null) {
                Filter[] aFilters = new Filter[listFilters.size()];
                aFilters = listFilters.toArray(aFilters);
                evt = new MapListenerSupport.FilterEvent(this.getNamedMap(), nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming, aFilters);
            }
        }
        if (listeners != null && !listeners.isEmpty()) {
            if (evt == null) {
                evt = new CacheEvent(this.getNamedMap(), nEventId, oKey, oValueOld, oValueNew, fSynthetic, transformState, fPriming);
            }
            for (EventListener listener : listeners.listeners()) {
                EventTask task = new EventTask(evt, (MapListener)listener);
                if (listener instanceof SynchronousListener) {
                    task.run();
                    continue;
                }
                this.f_executor.execute(task);
            }
        }
    }

    public int getListenerCount() {
        return this.f_cListener.get();
    }

    protected GrpcCacheLifecycleEventDispatcher getEventDispatcher() {
        return (GrpcCacheLifecycleEventDispatcher)this.f_dispatcher;
    }

    protected static <T> T handleException(T result, Throwable t) {
        if (t != null) {
            StatusRuntimeException sre;
            Throwable cause = t.getCause();
            if (cause instanceof StatusRuntimeException && (sre = (StatusRuntimeException)cause).getStatus().getCode() == Status.Code.UNIMPLEMENTED.toStatus().getCode()) {
                throw new UnsupportedOperationException("This operation is not supported by the current gRPC proxy. Either upgrade the version of Coherence on the gRPC proxy or connect to a gRPC proxy that supports the operation.", (Throwable)sre);
            }
            throw Exceptions.ensureRuntimeException((Throwable)t);
        }
        return result;
    }

    public static interface Dependencies
    extends BaseGrpcClient.Dependencies {
        public Optional<NamedCacheGrpcClient> getClient();
    }

    protected class EventStreamObserver
    implements StreamObserver<MapListenerResponse> {
        protected final String f_sUid;
        protected final CompletableFuture<Void> f_future;
        protected volatile boolean m_fDone;
        protected final Lock f_lock = new ReentrantLock();
        private final SafeStreamObserver<MapListenerRequest> m_evtRequestObserver;
        protected final Map<String, CompletableFuture<Void>> f_mapFuture = new ConcurrentHashMap<String, CompletableFuture<Void>>();

        protected EventStreamObserver() {
            this.f_sUid = UUID.randomUUID().toString();
            this.f_future = new CompletableFuture();
            StreamObserver<MapListenerRequest> observer = AsyncNamedCacheClient.this.f_service.events(this);
            this.m_evtRequestObserver = (SafeStreamObserver)SafeStreamObserver.ensureSafeObserver(observer);
            this.m_evtRequestObserver.whenDone().thenAccept(v -> this.f_mapFuture.values().forEach(f -> f.complete(null)));
            MapListenerRequest request = MapListenerRequest.newBuilder().setScope(AsyncNamedCacheClient.this.f_sScopeName).setCache(AsyncNamedCacheClient.this.f_sName).setUid(this.f_sUid).setSubscribe(true).setFormat(AsyncNamedCacheClient.this.f_sFormat).setType(MapListenerRequest.RequestType.INIT).build();
            observer.onNext((Object)request);
        }

        public CompletionStage<Void> whenSubscribed() {
            return this.f_future;
        }

        public void onNext(MapListenerResponse response) {
            switch (response.getResponseTypeCase()) {
                case SUBSCRIBED: {
                    this.onSubscribed(response);
                    break;
                }
                case UNSUBSCRIBED: {
                    this.onUnsubscribed(response);
                    break;
                }
                case EVENT: {
                    AsyncNamedCacheClient.this.dispatch(response.getEvent());
                    break;
                }
                case ERROR: {
                    this.onError(response);
                    break;
                }
                case DESTROYED: {
                    this.onDestroyed(response);
                    break;
                }
                case TRUNCATED: {
                    this.onTruncated(response);
                    break;
                }
                case RESPONSETYPE_NOT_SET: {
                    Logger.info((String)"Received unexpected event without a response type!");
                    break;
                }
                default: {
                    Logger.info((String)("Received unexpected event " + String.valueOf(response.getEvent())));
                }
            }
        }

        public void onError(Throwable t) {
            this.f_lock.lock();
            try {
                this.m_fDone = true;
                if (!this.f_future.isDone()) {
                    this.f_future.completeExceptionally(t);
                }
                this.f_mapFuture.values().forEach(f -> f.complete(null));
            }
            finally {
                this.f_lock.unlock();
            }
        }

        public void onCompleted() {
            this.f_lock.lock();
            try {
                this.m_fDone = true;
                if (!this.f_future.isDone()) {
                    this.f_future.completeExceptionally(new IllegalStateException("Event observer completed without subscription"));
                }
                this.f_mapFuture.values().forEach(f -> f.complete(null));
            }
            finally {
                this.f_lock.unlock();
            }
        }

        private void onSubscribed(MapListenerResponse response) {
            MapListenerSubscribedResponse subscribed = response.getSubscribed();
            String responseUid = subscribed.getUid();
            if (this.f_sUid.equals(responseUid)) {
                this.f_future.complete(VOID);
            } else {
                CompletableFuture<Void> future = this.f_mapFuture.remove(responseUid);
                if (future != null) {
                    future.complete(VOID);
                }
                AsyncNamedCacheClient.this.f_cListener.incrementAndGet();
            }
        }

        private void onUnsubscribed(MapListenerResponse response) {
            MapListenerUnsubscribedResponse unsubscribed = response.getUnsubscribed();
            CompletableFuture<Void> future = this.f_mapFuture.remove(unsubscribed.getUid());
            if (future != null) {
                future.complete(VOID);
            }
            AsyncNamedCacheClient.this.f_cListener.decrementAndGet();
        }

        private void onDestroyed(MapListenerResponse response) {
            if (response.getDestroyed().getCache().equals(AsyncNamedCacheClient.this.f_sName)) {
                if (AsyncNamedCacheClient.this.isActiveInternal()) {
                    AsyncNamedCacheClient.this.m_fDestroyed = true;
                    AsyncNamedCacheClient.this.releaseInternal(true);
                }
                AsyncNamedCacheClient.this.f_cListener.set(0);
            }
        }

        private void onTruncated(MapListenerResponse response) {
            if (response.getTruncated().getCache().equals(AsyncNamedCacheClient.this.f_sName)) {
                CacheEvent evt = AsyncNamedCacheClient.this.createDeactivationEvent(false);
                for (NamedCacheDeactivationListener listener : AsyncNamedCacheClient.this.f_listCacheDeactivationListeners) {
                    try {
                        listener.entryUpdated(evt);
                    }
                    catch (Throwable t) {
                        Logger.err((Throwable)t);
                    }
                }
            }
        }

        private void onError(MapListenerResponse response) {
            MapListenerErrorResponse error = response.getError();
            String responseUid = error.getUid();
            if (this.f_sUid.equals(responseUid)) {
                this.f_future.completeExceptionally(new RuntimeException(error.getMessage()));
            } else {
                CompletableFuture<Void> future = this.f_mapFuture.remove(responseUid);
                if (future != null) {
                    future.completeExceptionally(new RuntimeException(error.getMessage()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Void> send(MapListenerRequest request) {
            if (this.m_fDone) {
                return CompletableFuture.completedFuture(null);
            }
            this.f_lock.lock();
            try {
                if (this.m_fDone) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.f_mapFuture.put(request.getUid(), future);
                this.m_evtRequestObserver.onNext((Object)request);
                CompletableFuture<Void> completableFuture = future;
                return completableFuture;
            }
            finally {
                this.f_lock.unlock();
            }
        }

        public void removeAndComplete(String uid, Throwable t) {
            CompletableFuture<Void> future = this.f_mapFuture.remove(uid);
            if (future != null && !future.isDone()) {
                if (t == null) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(t);
                }
            }
        }

        public String toString() {
            return "EventStreamObserver(cacheName='" + AsyncNamedCacheClient.this.f_sName + "', uid='" + this.f_sUid + "')";
        }
    }

    static class EventTask
    implements Runnable {
        private final CacheEvent<?, ?> f_event;
        private final MapListener f_listener;

        EventTask(CacheEvent<?, ?> event, MapListener listener) {
            this.f_event = event;
            this.f_listener = listener;
        }

        @Override
        public void run() {
            NamedCache cache = (NamedCache)this.f_event.getSource();
            if (cache.isActive()) {
                try {
                    this.f_event.dispatch(this.f_listener);
                }
                catch (Throwable thrown) {
                    CacheFactory.err((String)"Caught exception dispatching event to listener");
                    CacheFactory.err((Throwable)thrown);
                }
            }
        }
    }

    protected class InvokeAllBiFunction<Kf, Rf>
    implements BiFunction<Entry, Map<Kf, Rf>, Map<Kf, Rf>> {
        protected final CompletableFuture<Map<Kf, Rf>> f_future;

        protected InvokeAllBiFunction(CompletableFuture<Map<Kf, Rf>> future) {
            this.f_future = future;
        }

        @Override
        public Map<Kf, Rf> apply(Entry e, Map<Kf, Rf> m) {
            try {
                m.put(AsyncNamedCacheClient.this.fromByteString(e.getKey()), AsyncNamedCacheClient.this.fromByteString(e.getValue()));
                return m;
            }
            catch (Throwable ex) {
                this.f_future.completeExceptionally(ex);
                return null;
            }
        }
    }

    public static class DefaultDependencies
    extends BaseGrpcClient.DefaultDependencies
    implements Dependencies {
        private NamedCacheGrpcClient m_client;

        public DefaultDependencies(String sCacheName, Channel channel, GrpcCacheLifecycleEventDispatcher dispatcher) {
            super(sCacheName, channel, (EventDispatcher)dispatcher);
        }

        @Override
        public Optional<NamedCacheGrpcClient> getClient() {
            return Optional.ofNullable(this.m_client);
        }

        public void setClient(NamedCacheGrpcClient client) {
            this.m_client = client;
        }
    }

    protected static class WrapperDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        protected final MapListener<? super K, ? super V> m_listener;

        protected WrapperDeactivationListener(MapListener<? super K, ? super V> listener) {
            this.m_listener = listener;
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            CacheEvent evt = client.createDeactivationEvent(true);
            this.m_listener.entryDeleted(evt);
        }
    }
}

