/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.client.DeactivationListener;
import com.oracle.coherence.client.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.client.GrpcRemoteService;
import com.oracle.coherence.client.NamedCacheClient;
import com.oracle.coherence.client.ScopedGrpcAsyncCacheReferenceStore;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.grpc.RemoteGrpcCacheServiceDependencies;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.MapEvent;
import com.tangosol.util.ResourceRegistry;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.Executor;

public class GrpcRemoteCacheService
extends GrpcRemoteService<RemoteGrpcCacheServiceDependencies>
implements CacheService {
    private final ClientDeactivationListener f_deactivationListener = new ClientDeactivationListener();
    private final TruncateListener f_truncateListener = new TruncateListener();
    private BackingMapManager m_backingMapManager;
    private final ScopedGrpcAsyncCacheReferenceStore m_scopedCacheStore = new ScopedGrpcAsyncCacheReferenceStore();

    public GrpcRemoteCacheService() {
        super("RemoteGrpcCache");
    }

    public BackingMapManager getBackingMapManager() {
        return this.m_backingMapManager;
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.m_backingMapManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache ensureCache(String sName, ClassLoader ignored) {
        ClassLoader loader = this.getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("ContextClassLoader is missing");
        }
        AsyncNamedCacheClient cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
        if (cache == null || !cache.isActiveInternal()) {
            long cWait = ((RemoteGrpcCacheServiceDependencies)this.getDependencies()).getRequestTimeoutMillis();
            if (cWait <= 0L) {
                cWait = -1L;
            }
            if (!this.m_scopedCacheStore.lock(sName, cWait)) {
                throw new RequestTimeoutException("Failed to get a reference to cache '" + sName + "' after " + cWait + "ms");
            }
            try {
                cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
                if (cache == null || !cache.isActiveInternal()) {
                    cache = this.ensureAsyncCache(sName);
                    this.m_scopedCacheStore.put(cache, loader);
                }
            }
            finally {
                this.m_scopedCacheStore.unlock(sName);
            }
        }
        return cache.getNamedCache();
    }

    public Enumeration getCacheNames() {
        return new IteratorEnumerator(Arrays.asList(this.m_scopedCacheStore.getNames().toArray()).iterator());
    }

    public void releaseCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + map);
        }
        map.release();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    public void destroyCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + map);
        }
        map.destroy();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    @Override
    protected void stopInternal() {
        for (AsyncNamedCacheClient cache : this.m_scopedCacheStore.getAll()) {
            cache.removeDeactivationListener(this.f_deactivationListener);
            try {
                cache.release();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected EventDispatcherRegistry getDefaultEventDispatcherRegistry() {
        ResourceRegistry registry = this.getBackingMapManager().getCacheFactory().getResourceRegistry();
        return (EventDispatcherRegistry)registry.getResource(EventDispatcherRegistry.class);
    }

    protected <K, V> AsyncNamedCacheClient<K, V> ensureAsyncCache(String sCacheName) {
        Channel channel = this.m_tracingInterceptor == null ? this.m_channel : ClientInterceptors.intercept((Channel)this.m_channel, (ClientInterceptor[])new ClientInterceptor[]{this.m_tracingInterceptor});
        RemoteGrpcCacheServiceDependencies dependencies = (RemoteGrpcCacheServiceDependencies)this.getDependencies();
        String sScopeName = dependencies.getRemoteScopeName();
        GrpcCacheLifecycleEventDispatcher dispatcher = new GrpcCacheLifecycleEventDispatcher(sCacheName, this);
        if (sScopeName == null) {
            sScopeName = "";
        }
        AsyncNamedCacheClient.DefaultDependencies deps = new AsyncNamedCacheClient.DefaultDependencies(sCacheName, channel, dispatcher);
        deps.setScope(sScopeName);
        deps.setSerializer(this.m_serializer, this.m_serializer.getName());
        deps.setExecutor((Executor)this.m_executor);
        deps.setDeadline(dependencies.getDeadline());
        AsyncNamedCacheClient client = new AsyncNamedCacheClient(deps);
        EventDispatcherRegistry dispatcherReg = this.getEventDispatcherRegistry();
        if (dispatcherReg != null) {
            dispatcherReg.registerEventDispatcher((EventDispatcher)dispatcher);
        }
        client.setCacheService(this);
        client.addDeactivationListener(this.f_truncateListener);
        client.addDeactivationListener(this.f_deactivationListener);
        this.m_executor.execute(() -> dispatcher.dispatchCacheCreated(client.getNamedCache()));
        return client;
    }

    private class ClientDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        private ClientDeactivationListener() {
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService.this.m_scopedCacheStore.remove(client.getCacheName());
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService service = GrpcRemoteCacheService.this;
            boolean removed = service.m_scopedCacheStore.release(client);
            if (removed) {
                GrpcCacheLifecycleEventDispatcher dispatcher = client.getEventDispatcher();
                EventDispatcherRegistry dispatcherReg = service.getEventDispatcherRegistry();
                dispatcher.dispatchCacheDestroyed(client.getNamedCache());
                dispatcherReg.unregisterEventDispatcher((EventDispatcher)client.getEventDispatcher());
            }
        }
    }

    private class TruncateListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        private TruncateListener() {
        }

        public void entryUpdated(MapEvent evt) {
            NamedCache cache = (NamedCache)evt.getMap();
            AsyncNamedCacheClient client = (AsyncNamedCacheClient)GrpcRemoteCacheService.this.m_scopedCacheStore.get(cache.getCacheName(), TruncateListener.getContextClassLoader());
            if (client != null) {
                client.getEventDispatcher().dispatchCacheTruncated((NamedCache)evt.getMap());
            }
        }
    }
}

