/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.oracle.coherence.client.DeactivationListener;
import com.oracle.coherence.client.GrpcCacheLifecycleEventDispatcher;
import com.oracle.coherence.client.GrpcChannelFactory;
import com.oracle.coherence.client.NamedCacheClient;
import com.oracle.coherence.client.ScopedGrpcAsyncCacheReferenceStore;
import com.oracle.coherence.grpc.SimpleDaemonPoolExecutor;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.grpc.RemoteGrpcCacheServiceDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SimpleResourceRegistry;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.TracingClientInterceptor;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class GrpcRemoteCacheService
implements CacheService,
ServiceInfo {
    private static final AtomicInteger f_cPool = new AtomicInteger();
    private final Listeners f_memberListeners = new Listeners();
    private final Listeners f_serviceListeners = new Listeners();
    private final ResourceRegistry f_resourceRegistry = new SimpleResourceRegistry();
    private final ClientDeactivationListener f_deactivationListener = new ClientDeactivationListener();
    private final TruncateListener f_truncateListener = new TruncateListener();
    private Cluster m_cluster;
    private ClassLoader m_classLoader;
    private Object m_oUserContext;
    private String m_sServiceName;
    private BackingMapManager m_backingMapManager;
    private volatile boolean m_fRunning;
    private RemoteGrpcCacheServiceDependencies m_dependencies;
    private String m_sScopeName;
    private Channel m_channel;
    private Serializer m_serializer;
    private ClientInterceptor m_tracingInterceptor;
    private SimpleDaemonPoolExecutor m_executor;
    private EventDispatcherRegistry m_EventDispatcherRegistry;
    private final ScopedGrpcAsyncCacheReferenceStore m_scopedCacheStore = new ScopedGrpcAsyncCacheReferenceStore();

    public void setCluster(Cluster cluster) {
        this.m_cluster = cluster;
    }

    public void setServiceName(String sName) {
        this.m_sServiceName = sName;
    }

    public Channel getChannel() {
        return this.m_channel;
    }

    public void setChannel(Channel channel) {
        this.m_channel = channel;
    }

    public void setTracingInterceptor(ClientInterceptor tracingInterceptor) {
        this.m_tracingInterceptor = tracingInterceptor;
    }

    public SimpleDaemonPoolExecutor getExecutor() {
        return this.m_executor;
    }

    public void setExecutor(SimpleDaemonPoolExecutor executor) {
        this.m_executor = executor;
    }

    public String getScopeName() {
        return this.m_sScopeName;
    }

    public void setScopeName(String sScopeName) {
        this.m_sScopeName = sScopeName;
    }

    public ClassLoader getContextClassLoader() {
        return this.m_classLoader;
    }

    public void setContextClassLoader(ClassLoader loader) {
        if (this.getContextClassLoader() != loader) {
            this.m_classLoader = loader;
            if (this.getSerializer() != null) {
                this.setSerializer(this.instantiateSerializer(loader));
            }
        }
    }

    public BackingMapManager getBackingMapManager() {
        return this.m_backingMapManager;
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.m_backingMapManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache ensureCache(String sName, ClassLoader ignored) {
        ClassLoader loader = this.getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("ContextClassLoader is missing");
        }
        AsyncNamedCacheClient cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
        if (cache == null || !cache.isActiveInternal()) {
            long cWait = this.getDependencies().getRequestTimeoutMillis();
            if (cWait <= 0L) {
                cWait = -1L;
            }
            if (!this.m_scopedCacheStore.lock(sName, cWait)) {
                throw new RequestTimeoutException("Failed to get a reference to cache '" + sName + "' after " + cWait + "ms");
            }
            try {
                cache = (AsyncNamedCacheClient)this.m_scopedCacheStore.get(sName, loader);
                if (cache == null || !cache.isActiveInternal()) {
                    cache = this.ensureAsyncCache(sName);
                    this.m_scopedCacheStore.put(cache, loader);
                }
            }
            finally {
                this.m_scopedCacheStore.unlock(sName);
            }
        }
        return cache.getNamedCache();
    }

    public Enumeration getCacheNames() {
        return new IteratorEnumerator(Arrays.asList(this.m_scopedCacheStore.getNames().toArray()).iterator());
    }

    public void releaseCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + map);
        }
        map.release();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    public void destroyCache(NamedCache map) {
        if (!(map instanceof NamedCacheClient)) {
            throw new IllegalArgumentException("illegal map: " + map);
        }
        map.destroy();
        NamedCacheClient cache = (NamedCacheClient)map;
        this.m_scopedCacheStore.release(cache.getAsyncClient());
    }

    public Cluster getCluster() {
        return this.m_cluster;
    }

    public ServiceInfo getInfo() {
        return this;
    }

    public void addMemberListener(MemberListener listener) {
        this.f_memberListeners.add((EventListener)listener);
    }

    public void removeMemberListener(MemberListener listener) {
        this.f_memberListeners.remove((EventListener)listener);
    }

    public Object getUserContext() {
        return this.m_oUserContext;
    }

    public void setUserContext(Object oCtx) {
        this.m_oUserContext = oCtx;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    protected void setSerializer(Serializer serializer) {
        this.m_serializer = serializer;
    }

    public void setDependencies(ServiceDependencies deps) {
        this.m_dependencies = (RemoteGrpcCacheServiceDependencies)deps;
    }

    public RemoteGrpcCacheServiceDependencies getDependencies() {
        return this.m_dependencies;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_resourceRegistry;
    }

    public boolean isSuspended() {
        return false;
    }

    public void configure(XmlElement xml) {
    }

    public synchronized void start() {
        this.setChannel(this.instantiateChannel());
        this.setSerializer(this.instantiateSerializer(this.m_classLoader));
        this.setTracingInterceptor(this.instantiateTracingInterceptor());
        SimpleDaemonPoolExecutor executor = this.instantiateExecutor();
        this.setExecutor(executor);
        executor.start();
        this.m_fRunning = true;
    }

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public void shutdown() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.m_fRunning) {
            GrpcRemoteCacheService grpcRemoteCacheService = this;
            synchronized (grpcRemoteCacheService) {
                if (this.m_fRunning) {
                    for (AsyncNamedCacheClient cache : this.m_scopedCacheStore.getAll()) {
                        cache.removeDeactivationListener(this.f_deactivationListener);
                        try {
                            cache.release();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    this.m_scopedCacheStore.clear();
                    SimpleDaemonPoolExecutor executor = this.getExecutor();
                    executor.stop();
                    this.m_fRunning = false;
                }
            }
        }
    }

    public void addServiceListener(ServiceListener listener) {
        this.f_serviceListeners.add((EventListener)listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.f_serviceListeners.remove((EventListener)listener);
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public String getServiceType() {
        return "RemoteGrpcCache";
    }

    public Set getServiceMembers() {
        return NullImplementation.getSet();
    }

    public String getServiceVersion(Member member) {
        return "1";
    }

    public Member getOldestMember() {
        return null;
    }

    public Member getServiceMember(int nId) {
        return null;
    }

    protected <K, V> AsyncNamedCacheClient<K, V> ensureAsyncCache(String sCacheName) {
        Channel channel = this.m_tracingInterceptor == null ? this.m_channel : ClientInterceptors.intercept((Channel)this.m_channel, (ClientInterceptor[])new ClientInterceptor[]{this.m_tracingInterceptor});
        RemoteGrpcCacheServiceDependencies dependencies = this.getDependencies();
        String sScopeName = dependencies.getRemoteScopeName();
        GrpcCacheLifecycleEventDispatcher dispatcher = new GrpcCacheLifecycleEventDispatcher(sCacheName, this);
        AsyncNamedCacheClient.DefaultDependencies deps = new AsyncNamedCacheClient.DefaultDependencies(sCacheName, channel, dispatcher);
        deps.setScope(sScopeName);
        deps.setSerializer(this.m_serializer, this.m_serializer.getName());
        deps.setExecutor((Executor)this.m_executor);
        AsyncNamedCacheClient client = new AsyncNamedCacheClient(deps);
        EventDispatcherRegistry dispatcherReg = this.getEventDispatcherRegistry();
        if (dispatcherReg != null) {
            dispatcherReg.registerEventDispatcher((EventDispatcher)dispatcher);
        }
        client.setCacheService(this);
        client.addDeactivationListener(this.f_truncateListener);
        client.addDeactivationListener(this.f_deactivationListener);
        this.m_executor.execute(() -> dispatcher.dispatchCacheCreated(client.getNamedCache()));
        return client;
    }

    protected EventDispatcherRegistry getEventDispatcherRegistry() {
        EventDispatcherRegistry reg = this.m_EventDispatcherRegistry;
        if (reg == null) {
            ResourceRegistry registry = this.getBackingMapManager().getCacheFactory().getResourceRegistry();
            reg = (EventDispatcherRegistry)registry.getResource(EventDispatcherRegistry.class);
            this.setEventDispatcherRegistry(reg);
        }
        return reg;
    }

    protected void setEventDispatcherRegistry(EventDispatcherRegistry registryInterceptor) {
        this.m_EventDispatcherRegistry = registryInterceptor;
    }

    private ClientInterceptor createTracingInterceptor() {
        Tracer tracer = GlobalTracer.get();
        return TracingClientInterceptor.newBuilder().withTracer(tracer).build();
    }

    protected Serializer instantiateSerializer(ClassLoader loader) {
        SerializerFactory factory = this.m_dependencies.getSerializerFactory();
        return factory == null ? ExternalizableHelper.ensureSerializer((ClassLoader)loader) : factory.createSerializer(loader);
    }

    protected Channel instantiateChannel() {
        RemoteGrpcCacheServiceDependencies deps = this.getDependencies();
        GrpcChannelDependencies depsChannel = deps.getChannelDependencies();
        Optional optional = depsChannel.getChannelProvider();
        return optional.flatMap(p -> p.getChannel(this.m_sServiceName)).orElse(GrpcChannelFactory.singleton().getChannel(this));
    }

    protected ClientInterceptor instantiateTracingInterceptor() {
        boolean fTracing = (Boolean)this.m_dependencies.isTracingEnabled().evaluate((ParameterResolver)new SystemPropertyParameterResolver());
        return fTracing ? this.createTracingInterceptor() : null;
    }

    protected SimpleDaemonPoolExecutor instantiateExecutor() {
        String sPoolName = this.getServiceName() + "-pool-" + f_cPool.getAndIncrement();
        DefaultDaemonPoolDependencies dependencies = new DefaultDaemonPoolDependencies(this.m_dependencies.getDaemonPoolDependencies());
        dependencies.setName(sPoolName);
        dependencies.setThreadCount(Math.max(1, dependencies.getThreadCount()));
        return new SimpleDaemonPoolExecutor(dependencies);
    }

    private class TruncateListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        private TruncateListener() {
        }

        public void entryUpdated(MapEvent evt) {
            NamedCache cache = (NamedCache)evt.getMap();
            AsyncNamedCacheClient client = (AsyncNamedCacheClient)GrpcRemoteCacheService.this.m_scopedCacheStore.get(cache.getCacheName(), TruncateListener.getContextClassLoader());
            if (client != null) {
                client.getEventDispatcher().dispatchCacheTruncated((NamedCache)evt.getMap());
            }
        }
    }

    private class ClientDeactivationListener<K, V>
    implements DeactivationListener<AsyncNamedCacheClient<? super K, ? super V>> {
        private ClientDeactivationListener() {
        }

        @Override
        public void released(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService.this.m_scopedCacheStore.remove(client.getCacheName());
        }

        @Override
        public void destroyed(AsyncNamedCacheClient<? super K, ? super V> client) {
            GrpcRemoteCacheService service = GrpcRemoteCacheService.this;
            boolean removed = service.m_scopedCacheStore.release(client);
            if (removed) {
                GrpcCacheLifecycleEventDispatcher dispatcher = client.getEventDispatcher();
                EventDispatcherRegistry dispatcherReg = service.getEventDispatcherRegistry();
                dispatcher.dispatchCacheDestroyed(client.getNamedCache());
                dispatcherReg.unregisterEventDispatcher((EventDispatcher)client.getEventDispatcher());
            }
        }
    }
}

