/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcRemoteSession;
import com.oracle.coherence.client.GrpcSessionConfiguration;
import com.oracle.coherence.client.GrpcSessionProvider;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.Session;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.TracingClientInterceptor;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Deprecated(since="22.06.2")
public class GrpcSessions
implements SessionProvider {
    private static final Serializer DEFAULT_JAVA_SERIALIZER = new DefaultSerializer();
    private static final Serializer DEFAULT_POF_SERIALIZER = new ConfigurablePofContext();
    private final SessionsByName f_sessions = new SessionsByName();
    private List<GrpcSessionProvider> m_listProvider;

    public int getPriority() {
        return 1;
    }

    public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
        SessionProvider.DefaultContext grpcContext = new SessionProvider.DefaultContext(context.getMode(), (SessionProvider)DefaultProvider.INSTANCE, context.getInterceptors());
        for (SessionProvider sessionProvider : this.ensureProviders()) {
            SessionProvider.Context result = sessionProvider.createSession(configuration, (SessionProvider.Context)grpcContext);
            if (!result.isComplete()) continue;
            return result;
        }
        return this.ensureSession(configuration, context);
    }

    @Deprecated
    public Session createSession(Session.Option ... options) {
        throw new UnsupportedOperationException("Cannot create a gRPC session using optiona");
    }

    public synchronized void close() {
        this.f_sessions.shutdown();
    }

    synchronized SessionProvider.Context ensureSession(SessionConfiguration configuration, SessionProvider.Context context) {
        if (configuration instanceof GrpcSessionConfiguration) {
            return this.buildSession((GrpcSessionConfiguration)configuration, context);
        }
        return context;
    }

    private SessionProvider.Context buildSession(GrpcSessionConfiguration grpcConfig, SessionProvider.Context context) {
        if (grpcConfig.isEnabled()) {
            Channel channel = Objects.requireNonNull(grpcConfig.getChannel());
            String sName = grpcConfig.getName();
            String sScope = grpcConfig.getScopeName();
            ClientInterceptor interceptor = grpcConfig.enableTracing() ? this.createTracingInterceptor() : null;
            String sFormat = this.ensureSerializerFormat(grpcConfig.getFormat().orElse(null));
            Serializer serializer = grpcConfig.getSerializer().orElseGet(() -> this.ensureSerializer(sFormat));
            Supplier<GrpcRemoteSession> supplier = () -> new GrpcRemoteSession(channel, sName, sScope, serializer, sFormat, interceptor, context.getInterceptors());
            GrpcRemoteSession session = this.f_sessions.get(sName).get(channel).get(sScope).get(sFormat).get(serializer, supplier);
            if (session != null) {
                session.activate();
                return context.complete((Session)session);
            }
        }
        return context;
    }

    private String ensureSerializerFormat(String sFormat) {
        if (sFormat != null && !sFormat.isEmpty()) {
            return sFormat;
        }
        return Config.getBoolean((String)"coherence.pof.enabled") ? "pof" : "java";
    }

    private Serializer ensureSerializer(String sFormat) {
        String sSerializerName = this.ensureSerializerFormat(sFormat);
        if (sSerializerName.equals("pof")) {
            return DEFAULT_POF_SERIALIZER;
        }
        if (sSerializerName.equals("java")) {
            return DEFAULT_JAVA_SERIALIZER;
        }
        throw new IllegalArgumentException("Unknown serializer format " + sSerializerName + " and no Serializer has been specified");
    }

    private ClientInterceptor createTracingInterceptor() {
        Tracer tracer = GlobalTracer.get();
        return TracingClientInterceptor.newBuilder().withTracer(tracer).build();
    }

    private synchronized List<GrpcSessionProvider> ensureProviders() {
        if (this.m_listProvider == null) {
            ArrayList<GrpcSessionProvider> list = new ArrayList<GrpcSessionProvider>();
            ServiceLoader<GrpcSessionProvider> loader = ServiceLoader.load(GrpcSessionProvider.class);
            for (GrpcSessionProvider provider : loader) {
                list.add(provider);
            }
            list.sort(Comparator.reverseOrder());
            this.m_listProvider = list;
        }
        return this.m_listProvider;
    }

    private static class DefaultProvider
    extends GrpcSessions {
        static DefaultProvider INSTANCE = new DefaultProvider();

        private DefaultProvider() {
        }

        @Override
        public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
            if (configuration instanceof GrpcSessionConfiguration) {
                return this.ensureSession(configuration, context);
            }
            return context;
        }
    }

    private static class SessionsBySerializer {
        private final ConcurrentHashMap<Serializer, GrpcRemoteSession> f_map = new ConcurrentHashMap();

        private SessionsBySerializer() {
        }

        GrpcRemoteSession get(Serializer serializer, Supplier<GrpcRemoteSession> builder) {
            return this.f_map.compute(serializer, (key, current) -> {
                if (current != null && !current.isClosed()) {
                    return current;
                }
                return (GrpcRemoteSession)builder.get();
            });
        }

        void shutdown() {
            this.f_map.values().forEach(session -> {
                try {
                    session.close();
                }
                catch (Throwable t) {
                    Logger.err((Throwable)t);
                }
            });
            this.f_map.clear();
        }
    }

    private static class SessionsBySerializerFormat {
        private final ConcurrentHashMap<String, SessionsBySerializer> f_map = new ConcurrentHashMap();

        private SessionsBySerializerFormat() {
        }

        SessionsBySerializer get(String sFormat) {
            return this.f_map.computeIfAbsent(sFormat, k -> new SessionsBySerializer());
        }

        void shutdown() {
            this.f_map.values().forEach(SessionsBySerializer::shutdown);
        }
    }

    private static class SessionsByScope {
        private final ConcurrentHashMap<String, SessionsBySerializerFormat> f_map = new ConcurrentHashMap();

        private SessionsByScope() {
        }

        SessionsBySerializerFormat get(String sScope) {
            return this.f_map.computeIfAbsent(sScope, k -> new SessionsBySerializerFormat());
        }

        void shutdown() {
            this.f_map.values().forEach(SessionsBySerializerFormat::shutdown);
        }
    }

    private static class SessionsByChannel {
        private final ConcurrentHashMap<Channel, SessionsByScope> f_map = new ConcurrentHashMap();

        private SessionsByChannel() {
        }

        SessionsByScope get(Channel channel) {
            return this.f_map.computeIfAbsent(channel, k -> new SessionsByScope());
        }

        void shutdown() {
            this.f_map.values().forEach(SessionsByScope::shutdown);
        }
    }

    private static class SessionsByName {
        private final ConcurrentHashMap<String, SessionsByChannel> f_map = new ConcurrentHashMap();

        private SessionsByName() {
        }

        SessionsByChannel get(String sName) {
            return this.f_map.computeIfAbsent(sName, k -> new SessionsByChannel());
        }

        void shutdown() {
            this.f_map.values().forEach(SessionsByChannel::shutdown);
        }
    }
}

