/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcChannelFactory;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.SimpleDaemonPoolExecutor;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.internal.net.grpc.RemoteGrpcServiceDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Listeners;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SimpleResourceRegistry;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.TracingClientInterceptor;
import io.opentracing.util.GlobalTracer;
import java.util.EventListener;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GrpcRemoteService<D extends RemoteGrpcServiceDependencies>
implements Service,
ServiceInfo {
    private static final AtomicInteger f_cPool = new AtomicInteger();
    private final String f_sServiceType;
    private final Listeners f_memberListeners = new Listeners();
    private final Listeners f_serviceListeners = new Listeners();
    private final ResourceRegistry f_resourceRegistry = new SimpleResourceRegistry();
    private Cluster m_cluster;
    private ClassLoader m_classLoader;
    private Object m_oUserContext;
    private String m_sServiceName;
    private volatile boolean m_fRunning;
    protected D m_dependencies;
    protected String m_sScopeName;
    protected Channel m_channel;
    protected Serializer m_serializer;
    protected ClientInterceptor m_tracingInterceptor;
    protected SimpleDaemonPoolExecutor m_executor;
    protected EventDispatcherRegistry m_EventDispatcherRegistry;
    protected final Lock f_lock = new ReentrantLock();

    public GrpcRemoteService(String sServiceType) {
        this.f_sServiceType = sServiceType;
    }

    public void setCluster(Cluster cluster) {
        this.m_cluster = cluster;
    }

    public void setServiceName(String sName) {
        this.m_sServiceName = sName;
    }

    public Channel getChannel() {
        return this.m_channel;
    }

    public void setChannel(Channel channel) {
        this.m_channel = channel;
    }

    public void setTracingInterceptor(ClientInterceptor tracingInterceptor) {
        this.m_tracingInterceptor = tracingInterceptor;
    }

    public SimpleDaemonPoolExecutor getExecutor() {
        return this.m_executor;
    }

    public void setExecutor(SimpleDaemonPoolExecutor executor) {
        this.m_executor = executor;
    }

    public String getScopeName() {
        return this.m_sScopeName;
    }

    public void setScopeName(String sScopeName) {
        this.m_sScopeName = sScopeName;
    }

    public ClassLoader getContextClassLoader() {
        return this.m_classLoader;
    }

    public void setContextClassLoader(ClassLoader loader) {
        if (this.getContextClassLoader() != loader) {
            this.m_classLoader = loader;
            if (this.getSerializer() != null) {
                this.setSerializer(this.instantiateSerializer(loader));
            }
        }
    }

    public Cluster getCluster() {
        return this.m_cluster;
    }

    public ServiceInfo getInfo() {
        return this;
    }

    public void addMemberListener(MemberListener listener) {
        this.f_memberListeners.add((EventListener)listener);
    }

    public void removeMemberListener(MemberListener listener) {
        this.f_memberListeners.remove((EventListener)listener);
    }

    public Object getUserContext() {
        return this.m_oUserContext;
    }

    public void setUserContext(Object oCtx) {
        this.m_oUserContext = oCtx;
    }

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    protected void setSerializer(Serializer serializer) {
        this.m_serializer = serializer;
    }

    public void setDependencies(ServiceDependencies deps) {
        this.m_dependencies = (RemoteGrpcServiceDependencies)deps;
    }

    public D getDependencies() {
        return this.m_dependencies;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.f_resourceRegistry;
    }

    public boolean isSuspended() {
        return false;
    }

    public void configure(XmlElement xml) {
    }

    public void start() {
        this.f_lock.lock();
        try {
            this.setChannel(this.instantiateChannel());
            this.setSerializer(this.instantiateSerializer(this.m_classLoader));
            this.setTracingInterceptor(this.instantiateTracingInterceptor());
            SimpleDaemonPoolExecutor executor = this.instantiateExecutor();
            this.setExecutor(executor);
            executor.start();
            this.m_fRunning = true;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public void shutdown() {
        this.stop();
    }

    public void stop() {
        block7: {
            if (this.m_fRunning) {
                this.f_lock.lock();
                try {
                    if (!this.m_fRunning) break block7;
                    this.stopInternal();
                    if (this.m_channel instanceof ManagedChannel) {
                        try {
                            ManagedChannel managedChannel = (ManagedChannel)this.m_channel;
                            managedChannel.shutdownNow();
                            managedChannel.awaitTermination(1L, TimeUnit.MINUTES);
                        }
                        catch (InterruptedException e) {
                            Logger.err((Throwable)e);
                        }
                    }
                    SimpleDaemonPoolExecutor executor = this.getExecutor();
                    executor.stop();
                    this.m_fRunning = false;
                }
                finally {
                    this.f_lock.unlock();
                }
            }
        }
    }

    public void addServiceListener(ServiceListener listener) {
        this.f_serviceListeners.add((EventListener)listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.f_serviceListeners.remove((EventListener)listener);
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public String getServiceType() {
        return this.f_sServiceType;
    }

    public Set getServiceMembers() {
        return NullImplementation.getSet();
    }

    public String getServiceVersion(Member member) {
        return "1";
    }

    public Member getOldestMember() {
        return null;
    }

    public Member getServiceMember(int nId) {
        return null;
    }

    protected abstract void stopInternal();

    protected EventDispatcherRegistry getEventDispatcherRegistry() {
        EventDispatcherRegistry reg = this.m_EventDispatcherRegistry;
        if (reg == null) {
            reg = this.getDefaultEventDispatcherRegistry();
            this.setEventDispatcherRegistry(reg);
        }
        return reg;
    }

    protected void setEventDispatcherRegistry(EventDispatcherRegistry registryInterceptor) {
        this.m_EventDispatcherRegistry = registryInterceptor;
    }

    protected abstract EventDispatcherRegistry getDefaultEventDispatcherRegistry();

    private ClientInterceptor createTracingInterceptor() {
        Tracer tracer = GlobalTracer.get();
        return TracingClientInterceptor.newBuilder().withTracer(tracer).build();
    }

    protected Serializer instantiateSerializer(ClassLoader loader) {
        SerializerFactory factory = this.m_dependencies.getSerializerFactory();
        return factory == null ? ExternalizableHelper.ensureSerializer((ClassLoader)loader) : factory.createSerializer(loader);
    }

    protected Channel instantiateChannel() {
        D deps = this.getDependencies();
        GrpcChannelDependencies depsChannel = deps.getChannelDependencies();
        Optional optional = depsChannel.getChannelProvider();
        return optional.flatMap(p -> p.getChannel(this.m_sServiceName)).orElse(GrpcChannelFactory.singleton().getChannel(this));
    }

    protected ClientInterceptor instantiateTracingInterceptor() {
        boolean fTracing = (Boolean)this.m_dependencies.isTracingEnabled().evaluate((ParameterResolver)new SystemPropertyParameterResolver());
        return fTracing ? this.createTracingInterceptor() : null;
    }

    protected SimpleDaemonPoolExecutor instantiateExecutor() {
        String sPoolName = this.getServiceName() + "-pool-" + f_cPool.getAndIncrement();
        DefaultDaemonPoolDependencies dependencies = new DefaultDaemonPoolDependencies(this.m_dependencies.getDaemonPoolDependencies());
        dependencies.setName(sPoolName);
        dependencies.setThreadCount(Math.max(1, dependencies.getThreadCount()));
        return new SimpleDaemonPoolExecutor(dependencies);
    }
}

