/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.GrpcRemoteSession;
import com.tangosol.net.NamedCache;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.CacheLifecycleEventDispatcher;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GrpcCacheLifecycleEventDispatcher
extends AbstractEventDispatcher
implements CacheLifecycleEventDispatcher {
    protected static final Set<Enum> EVENT_TYPES = new HashSet<Enum>();
    private final String f_sCacheName;
    private GrpcRemoteSession f_session;

    public GrpcCacheLifecycleEventDispatcher(String sCacheName, GrpcRemoteSession session) {
        super(EVENT_TYPES);
        this.f_sCacheName = sCacheName;
        this.f_session = session;
    }

    public GrpcRemoteSession getSession() {
        return this.f_session;
    }

    public String getCacheName() {
        return this.f_sCacheName;
    }

    public String getServiceName() {
        return "";
    }

    public String getScopeName() {
        return this.f_session.getScopeName();
    }

    public void dispatchCacheCreated(NamedCache cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.CREATED, cache);
    }

    public void dispatchCacheDestroyed(NamedCache cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.DESTROYED, cache);
    }

    public void dispatchCacheTruncated(NamedCache cache) {
        this.dispatchCacheEvent(CacheLifecycleEvent.Type.TRUNCATED, cache);
    }

    protected void dispatchCacheEvent(CacheLifecycleEvent.Type eventType, NamedCache cache) {
        List list = (List)this.getInterceptorMap().get(eventType);
        if (list != null) {
            new GrpcCacheLifecycleEvent(this, eventType, cache).dispatch(list);
        }
    }

    static {
        EVENT_TYPES.addAll(Arrays.asList(CacheLifecycleEvent.Type.values()));
    }

    protected static class GrpcCacheLifecycleEvent
    extends AbstractEvent<CacheLifecycleEvent.Type>
    implements CacheLifecycleEvent {
        private final NamedCache<?, ?> f_cache;

        protected GrpcCacheLifecycleEvent(GrpcCacheLifecycleEventDispatcher dispatcher, CacheLifecycleEvent.Type eventType, NamedCache cache) {
            super(dispatcher, eventType);
            this.f_cache = cache;
        }

        protected boolean isMutableEvent() {
            return false;
        }

        protected String getDescription() {
            return super.getDescription() + ", Session=" + this.getSessionName() + ", Scope=" + this.getScopeName() + ", Cache=" + this.getCacheName();
        }

        public String getCacheName() {
            return this.f_cache.getCacheName();
        }

        public String getServiceName() {
            return null;
        }

        public String getScopeName() {
            return this.getEventDispatcher().getScopeName();
        }

        public String getSessionName() {
            return ((GrpcCacheLifecycleEventDispatcher)this.getEventDispatcher()).getSession().getName();
        }

        public CacheLifecycleEventDispatcher getEventDispatcher() {
            return (CacheLifecycleEventDispatcher)this.m_dispatcher;
        }

        public PartitionedCacheDispatcher getDispatcher() {
            return null;
        }

        protected void dispatch(Collection<? extends EventInterceptor<?>> colIter) {
            super.dispatch(colIter);
        }
    }

    protected static abstract class AbstractEvent<T extends Enum<T>>
    extends com.tangosol.net.events.internal.AbstractEvent<T> {
        public AbstractEvent(GrpcCacheLifecycleEventDispatcher dispatcher, T eventType) {
            super((EventDispatcher)dispatcher, eventType);
        }
    }
}

