/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.AsyncNamedCacheClient;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestIncompleteException;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class NamedCacheClient<K, V>
implements NamedCache<K, V> {
    protected final AsyncNamedCacheClient<K, V> f_asyncClient;

    protected NamedCacheClient(AsyncNamedCacheClient<K, V> asyncClient) {
        this.f_asyncClient = asyncClient;
    }

    protected AsyncNamedCacheClient<K, V> getAsyncClient() {
        return this.f_asyncClient;
    }

    public String toString() {
        return "NamedCacheClient{scope: \"" + this.f_asyncClient.getScopeName() + '\"' + "name: \"" + this.f_asyncClient.getCacheName() + '\"' + " format: \"" + this.f_asyncClient.getFormat() + '\"' + '}';
    }

    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> valueExtractor, boolean sorted, Comparator<? super E> comparator) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.addIndex(valueExtractor, sorted, comparator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.addMapListener(mapListener).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener, K key, boolean lite) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.addMapListener(mapListener, (K)key, lite).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void addMapListener(MapListener<? super K, ? super V> mapListener, Filter filter, boolean lite) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.addMapListener(mapListener, filter, lite).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <R> R aggregate(Collection<? extends K> keys, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.aggregate(keys, aggregator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.aggregate(filter, aggregator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void clear() {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.clear().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean containsKey(Object key) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.containsKeyInternal(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean containsValue(Object value) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.containsValue(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void destroy() {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.destroy().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        this.f_asyncClient.assertActive();
        try {
            return (Set)this.f_asyncClient.entrySet(filter).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        this.f_asyncClient.assertActive();
        try {
            return (Set)this.f_asyncClient.entrySet(filter, comparator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.entrySet().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public V get(Object key) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.getInternal(key, null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        this.f_asyncClient.assertActive();
        return this.f_asyncClient.getAllInternalAsMap(keys);
    }

    public String getCacheName() {
        return this.f_asyncClient.getCacheName();
    }

    public CacheService getCacheService() {
        return this.f_asyncClient.getCacheService();
    }

    public <R> R invoke(K k, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.invoke(k, entryProcessor).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <R> Map<K, R> invokeAll(Collection<? extends K> keys, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.invokeAll(keys, entryProcessor).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> entryProcessor) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.invokeAll(filter, entryProcessor).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean isActive() {
        try {
            return this.f_asyncClient.isActive().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean isEmpty() {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.isEmpty().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Set<K> keySet(Filter filter) {
        this.f_asyncClient.assertActive();
        try {
            return (Set)this.f_asyncClient.keySet(filter).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Set<K> keySet() {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.keySet().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean lock(Object o, long l) {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean lock(Object o) {
        throw new UnsupportedOperationException("not supported");
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L);
    }

    public V put(K key, V value, long ttl) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.putInternal(key, value, ttl).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.putAll(m).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void release() {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.release().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public V remove(Object key) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.removeInternal(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> valueExtractor) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.removeIndex(valueExtractor).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.removeMapListener(mapListener).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener, K key) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.removeMapListener(mapListener, (K)key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void removeMapListener(MapListener<? super K, ? super V> mapListener, Filter filter) {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.removeMapListener(mapListener, filter).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public int size() {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.size().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean unlock(Object o) {
        throw new UnsupportedOperationException("Not supported");
    }

    public Collection<V> values() {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.values().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public <R> R aggregate(InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        this.f_asyncClient.assertActive();
        try {
            return (R)this.f_asyncClient.aggregate(aggregator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public AsyncNamedCache<K, V> async() {
        return this.f_asyncClient;
    }

    public AsyncNamedCache<K, V> async(AsyncNamedMap.Option ... options) {
        return this.f_asyncClient;
    }

    public V getOrDefault(Object key, V defaultValue) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.getInternal(key, defaultValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean isDestroyed() {
        return this.f_asyncClient.isDestroyed();
    }

    public boolean isReleased() {
        return this.f_asyncClient.isReleased();
    }

    public V putIfAbsent(K key, V value) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.putIfAbsent(key, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean remove(Object key, Object value) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.removeInternal(key, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.replace(key, oldValue, newValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public void truncate() {
        this.f_asyncClient.assertActive();
        try {
            this.f_asyncClient.truncate().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Collection<V> values(Filter filter) {
        this.f_asyncClient.assertActive();
        try {
            return (Collection)this.f_asyncClient.values(filter).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }

    public Collection<V> values(Filter filter, Comparator comparator) {
        this.f_asyncClient.assertActive();
        try {
            return this.f_asyncClient.valuesInternal(filter, comparator).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestIncompleteException((Throwable)e);
        }
    }
}

