/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

class FutureStreamObserver<T, R>
implements StreamObserver<T> {
    protected final CompletableFuture<R> f_future;
    protected final BiFunction<T, R, R> f_function;
    protected R m_result;

    FutureStreamObserver(CompletableFuture<R> future, R initialResult, BiFunction<T, R, R> function) {
        this.f_future = future;
        this.m_result = initialResult;
        this.f_function = function;
    }

    public void onNext(T t) {
        if (!this.f_future.isDone()) {
            this.m_result = this.f_function.apply(t, this.m_result);
        }
    }

    public void onError(Throwable throwable) {
        if (!this.f_future.isDone()) {
            this.f_future.completeExceptionally(throwable);
        }
    }

    public void onCompleted() {
        if (!this.f_future.isDone()) {
            this.f_future.complete(this.m_result);
        }
    }
}

