/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.cdi.SerializerFormat;
import com.oracle.coherence.grpc.client.AsyncNamedCacheClient;
import com.oracle.coherence.grpc.client.GrpcRemoteSession;
import com.oracle.coherence.grpc.client.NamedCacheClient;
import com.oracle.coherence.grpc.client.RemoteSessions;
import com.tangosol.net.NamedMap;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
public class NamedCacheProducer {
    private final RemoteSessions f_sessionProducer;

    @Inject
    NamedCacheProducer(RemoteSessions sessionProducer) {
        this.f_sessionProducer = sessionProducer;
    }

    @Produces
    @Remote
    @Name(value="")
    @Scope
    @SerializerFormat(value="")
    public <K, V> NamedCacheClient<K, V> getNamedCache(InjectionPoint injectionPoint) {
        AsyncNamedCacheClient<K, V> async = this.getAsyncNamedCacheClient(injectionPoint);
        return async.getNamedCacheClient();
    }

    @Produces
    @Remote
    @Name(value="")
    @Scope
    @SerializerFormat(value="")
    public <K, V> AsyncNamedCacheClient<K, V> getRemoteAsyncNamedCache(InjectionPoint injectionPoint) {
        return this.getAsyncNamedCacheClient(injectionPoint);
    }

    protected <K, V> AsyncNamedCacheClient<K, V> getAsyncNamedCacheClient(InjectionPoint injectionPoint) {
        Set qualifiers = injectionPoint.getQualifiers();
        String sName = qualifiers.stream().filter(q -> Name.class.isAssignableFrom(q.getClass())).map(q -> ((Name)q).value()).findFirst().orElse(null);
        if (sName == null || sName.isEmpty()) {
            sName = injectionPoint.getMember().getName();
        }
        String sSessionName = qualifiers.stream().filter(q -> Remote.class.isAssignableFrom(q.getClass())).map(q -> ((Remote)q).value()).findFirst().orElse("default");
        String sScope = qualifiers.stream().filter(q -> Scope.class.isAssignableFrom(q.getClass())).map(q -> ((Scope)q).value()).findFirst().orElse("");
        GrpcRemoteSession session = this.f_sessionProducer.ensureSession(sSessionName, sScope);
        return session.getAsyncCache(sName, new NamedMap.Option[0]);
    }
}

