/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import io.grpc.ManagedChannel;
import io.helidon.config.Config;
import io.helidon.grpc.client.GrpcChannelDescriptor;
import io.helidon.grpc.client.GrpcChannelsProvider;
import io.helidon.grpc.core.GrpcTlsDescriptor;
import java.util.List;

public class GrpcChannelBuilder {
    private final GrpcChannelsProvider m_provider;

    private GrpcChannelBuilder(GrpcChannelsProvider provider) {
        this.m_provider = provider;
    }

    public static GrpcChannelBuilder create() {
        return GrpcChannelBuilder.builder().build();
    }

    public static GrpcChannelBuilder create(Config config) {
        return GrpcChannelBuilder.builder(config).build();
    }

    public static Builder builder() {
        return GrpcChannelBuilder.builder(Config.empty());
    }

    public static Builder builder(Config config) {
        return new Builder(config);
    }

    public ManagedChannel channel(String sName) {
        return this.m_provider.channel(sName);
    }

    GrpcChannelsProvider getProvider() {
        return this.m_provider;
    }

    public static class Builder {
        private final Config m_config;

        Builder(Config config) {
            this.m_config = config;
        }

        public GrpcChannelBuilder build() {
            GrpcChannelsProvider.Builder builder = GrpcChannelsProvider.builder().channel("default", GrpcChannelDescriptor.builder().build());
            Config cfgGrpc = this.m_config.get("grpc");
            Config cfgChannels = cfgGrpc.get("channels");
            if (cfgChannels.exists()) {
                for (Config cfg : (List)cfgChannels.asNodeList().get()) {
                    Config tlsConfig;
                    Config cfgName = cfg.get("name");
                    String key = cfgName.exists() ? (String)cfgName.asString().get() : cfg.key().name();
                    GrpcChannelDescriptor.Builder descriptorBuilder = GrpcChannelDescriptor.builder().host((String)cfg.get("host").asString().orElse((Object)"localhost")).port(((Integer)cfg.get("port").asInt().orElse((Object)1408)).intValue());
                    cfg.get("target").asString().ifPresent(arg_0 -> ((GrpcChannelDescriptor.Builder)descriptorBuilder).target(arg_0));
                    cfg.get("loadBalancerPolicy").asString().ifPresent(arg_0 -> ((GrpcChannelDescriptor.Builder)descriptorBuilder).loadBalancerPolicy(arg_0));
                    if (((Boolean)cfg.get("inProcess").asBoolean().orElse((Object)false)).booleanValue()) {
                        descriptorBuilder.inProcess();
                    }
                    if ((tlsConfig = cfg.get("tls")).exists()) {
                        descriptorBuilder.sslDescriptor(GrpcTlsDescriptor.builder((Config)tlsConfig).build());
                    }
                    builder.channel(key, descriptorBuilder.build());
                }
            }
            return new GrpcChannelBuilder(builder.build());
        }
    }
}

