/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http.netty;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.http.AbstractHttpServer;
import com.tangosol.coherence.http.netty.NettyInputStream;
import com.tangosol.util.Base;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.net.ssl.SSLEngine;
import javax.security.auth.Subject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;

public class NettyHttpServer
extends AbstractHttpServer {
    private final Type ChannelHandlerContextTYPE = new TypeLiteral<Ref<ChannelHandlerContext>>(){}.getType();
    private final Type ChannelTYPE = new TypeLiteral<Ref<Channel>>(){}.getType();
    protected ChannelFuture m_cf;
    protected String m_sListenAddress;
    protected int m_nListenPort;
    private static final String SSL_HANDLER_NAME = "ssl";
    private static final ByteBuffer POISON = ByteBuffer.allocate(0);

    protected void startInternal() throws IOException {
        this.createAndStartNettyServer(this.initUri(this.getLocalAddress(), this.getLocalPort()), this.initApplicationContainer());
        this.resetStats();
    }

    protected void stopInternal() throws IOException {
        try {
            this.m_cf.channel().close().sync();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getListenAddress() {
        if (this.m_sListenAddress == null) {
            this.m_sListenAddress = ((InetSocketAddress)this.m_cf.channel().localAddress()).getHostString();
        }
        return this.m_sListenAddress;
    }

    public int getListenPort() {
        if (this.m_nListenPort == 0) {
            this.m_nListenPort = ((InetSocketAddress)this.m_cf.channel().localAddress()).getPort();
        }
        return this.m_nListenPort;
    }

    protected Object instantiateContainer(ResourceConfig config, ServiceLocator locator) {
        return new NettyHttpContainer(config.getApplication(), locator);
    }

    protected URI initUri(String sHost, int nPort) {
        if (sHost == null || sHost.isEmpty()) {
            throw new IllegalArgumentException("Invalid host name: \"" + sHost + "\"");
        }
        if (nPort < 0) {
            throw new IllegalArgumentException("Invalid port: \"" + nPort + "\"");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"/").host(sHost).port(nPort);
        uriBuilder.scheme(this.isSecure() ? "https" : "http");
        return uriBuilder.build(new Object[0]);
    }

    protected String normalizeResourceContextPath(String sPath) {
        int cPathLen;
        int cIdx;
        String sPathLocal = sPath.trim();
        if (sPathLocal.length() == 1) {
            if (sPathLocal.charAt(0) == SLASH_CHAR) {
                return sPathLocal;
            }
            throw new IllegalArgumentException(String.format("Illegal resource 'context-path': '%s'.  REST Resource configuration 'context-path' must minimally be '/', found '%s'.", sPathLocal, sPath));
        }
        if (sPathLocal.charAt(0) != SLASH_CHAR) {
            throw new IllegalArgumentException(String.format("Illegal resource context 'context-path': %s.  REST resource configuration 'context-path' must begin with '/'.", sPathLocal));
        }
        while (sPathLocal.charAt(cIdx = (cPathLen = sPathLocal.length()) - 1) == SLASH_CHAR) {
            sPathLocal = sPathLocal.substring(0, cIdx).trim();
        }
        return sPathLocal;
    }

    protected ApplicationContainer initApplicationContainer() {
        ApplicationContainer app = new ApplicationContainer();
        Map mapResourceConfig = this.getResourceConfig();
        if (!mapResourceConfig.isEmpty()) {
            for (Map.Entry entry : mapResourceConfig.entrySet()) {
                NettyHttpContainer container = (NettyHttpContainer)this.createContainer((ResourceConfig)entry.getValue());
                app.registerContainer(this.normalizeResourceContextPath((String)entry.getKey()), container);
            }
        }
        return app;
    }

    protected void createAndStartNettyServer(URI baseUri, ApplicationContainer container) throws ProcessingException {
        EventLoopGroup bossGroup = this.createBossGroup();
        EventLoopGroup workerGroup = this.createWorkerGroup();
        try {
            ServerBootstrap bootStrap = new ServerBootstrap();
            bootStrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            bootStrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)bootStrap.group(bossGroup, workerGroup).channel(this.getServerChannelClass())).childHandler((ChannelHandler)new JerseyServerInitializer(container));
            int port = NettyHttpServer.getPort(baseUri);
            Channel ch = bootStrap.bind(port).sync().channel();
            this.m_cf = ch.closeFuture().addListener(future -> {
                container.shutdown();
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
            });
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected EventLoopGroup createBossGroup() {
        return new NioEventLoopGroup(1);
    }

    protected EventLoopGroup createWorkerGroup() {
        return new NioEventLoopGroup();
    }

    protected Class<? extends ServerChannel> getServerChannelClass() {
        return NioServerSocketChannel.class;
    }

    protected static int getPort(URI uri) {
        int nPort = uri.getPort();
        if (nPort == -1) {
            switch (uri.getScheme()) {
                case "http": {
                    return 80;
                }
                case "https": {
                    return 443;
                }
            }
            throw new IllegalArgumentException("URI scheme must be 'http' or 'https'.");
        }
        return nPort;
    }

    public static class NettyChannelReferencingFactory
    extends ReferencingFactory<Channel> {
        @Inject
        public NettyChannelReferencingFactory(Provider<Ref<Channel>> referenceFactory) {
            super(referenceFactory);
        }
    }

    public static class NettyChannelHandlerContextReferencingFactory
    extends ReferencingFactory<ChannelHandlerContext> {
        @Inject
        public NettyChannelHandlerContextReferencingFactory(Provider<Ref<ChannelHandlerContext>> referenceFactory) {
            super(referenceFactory);
        }
    }

    public class NettyBinder
    extends AbstractBinder {
        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(NettyChannelHandlerContextReferencingFactory.class).to(ChannelHandlerContext.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to(NettyHttpServer.this.ChannelHandlerContextTYPE)).in(RequestScoped.class);
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(NettyChannelReferencingFactory.class).to(Channel.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to(NettyHttpServer.this.ChannelTYPE)).in(RequestScoped.class);
        }
    }

    protected class NettyResponseWriter
    implements ContainerResponseWriter {
        private final ChannelHandlerContext m_ctx;
        private final HttpRequest m_request;
        private final NettyHttpContainer m_container;
        private volatile ScheduledFuture<?> m_suspendTimeoutFuture;
        private volatile Runnable m_suspendTimeoutHandler;
        private boolean m_fResponseCommitted = false;

        NettyResponseWriter(ChannelHandlerContext ctx, HttpRequest req, NettyHttpContainer container) {
            this.m_ctx = ctx;
            this.m_request = req;
            this.m_container = container;
        }

        public synchronized OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
            if (this.m_fResponseCommitted) {
                Logger.fine((String)"NettyHttpServer.writeResponseStatusAndHeaders(): response already written.");
                return null;
            }
            this.m_fResponseCommitted = true;
            String reasonPhrase = responseContext.getStatusInfo().getReasonPhrase();
            int statusCode = responseContext.getStatus();
            NettyHttpServer.this.logStatusCount(statusCode);
            HttpResponseStatus status = reasonPhrase == null ? HttpResponseStatus.valueOf((int)statusCode) : new HttpResponseStatus(statusCode, reasonPhrase);
            Object response = contentLength == 0L ? new DefaultFullHttpResponse(this.m_request.protocolVersion(), status) : new DefaultHttpResponse(this.m_request.protocolVersion(), status);
            for (Map.Entry e : responseContext.getStringHeaders().entrySet()) {
                response.headers().add((String)e.getKey(), (Iterable)e.getValue());
            }
            if (contentLength == -1L) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)contentLength);
            }
            if (HttpUtil.isKeepAlive((HttpMessage)this.m_request)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            this.m_ctx.writeAndFlush(response);
            if (this.m_request.method() != HttpMethod.HEAD && (contentLength > 0L || contentLength == -1L)) {
                JerseyNettyIOPipe bridge = new JerseyNettyIOPipe();
                this.m_ctx.writeAndFlush((Object)new HttpChunkedInput(bridge.getSink()));
                return bridge.getSource();
            }
            this.m_ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            return null;
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            this.m_suspendTimeoutHandler = () -> timeoutHandler.onTimeout((ContainerResponseWriter)this);
            if (timeOut <= 0L) {
                return true;
            }
            this.m_suspendTimeoutFuture = this.m_container.getScheduledExecutorService().schedule(this.m_suspendTimeoutHandler, timeOut, timeUnit);
            return true;
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            if (this.m_suspendTimeoutFuture != null) {
                this.m_suspendTimeoutFuture.cancel(true);
            }
            if (timeOut <= 0L) {
                return;
            }
            this.m_suspendTimeoutFuture = this.m_container.getScheduledExecutorService().schedule(this.m_suspendTimeoutHandler, timeOut, timeUnit);
        }

        public void commit() {
            this.m_ctx.flush();
        }

        public void failure(Throwable error) {
            this.m_ctx.writeAndFlush((Object)new DefaultFullHttpResponse(this.m_request.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        protected class JerseyNettyIOPipe
        implements ChannelFutureListener {
            protected final ChannelHandlerContext f_channelCtx;
            protected final Channel f_channel;
            protected final ChannelFuture f_channelFuture;
            protected final Sink f_sink;
            protected final Source f_source;
            protected volatile boolean m_fSinkClosed;
            protected volatile boolean m_fSourceClosed;
            protected final LinkedBlockingQueue<ByteBuffer> f_queue;
            protected static final int QUEUE_CAPACITY = 32;
            protected static final int MAX_BUFFER_LEN = 1300;

            protected JerseyNettyIOPipe() {
                this.f_channelCtx = NettyResponseWriter.this.m_ctx;
                this.f_channel = this.f_channelCtx.channel();
                this.f_channelFuture = this.f_channel.closeFuture();
                this.f_queue = new LinkedBlockingQueue(32);
                this.f_sink = new Sink();
                this.f_source = new Source();
                this.f_channelFuture.addListeners(new GenericFutureListener[]{this});
            }

            public void operationComplete(ChannelFuture future) throws Exception {
                this.closeSink();
            }

            public String toString() {
                return "JerseyNettyIOPipe(channel=" + this.f_channel + ", channel-open=" + this.f_channel.isOpen() + ", sink-closed=" + this.m_fSinkClosed + ", source-closed=" + this.m_fSourceClosed + ", queue-size=" + this.f_queue.size() + ")";
            }

            protected ChunkedInput<ByteBuf> getSink() {
                return this.f_sink;
            }

            protected OutputStream getSource() {
                return this.f_source;
            }

            protected void closeSink() throws IOException {
                if (this.m_fSinkClosed) {
                    return;
                }
                this.m_fSourceClosed = true;
                this.m_fSinkClosed = true;
                this.f_channelFuture.removeListener((GenericFutureListener)this);
                this.f_queue.clear();
            }

            protected boolean isSinkClosed() {
                return this.m_fSinkClosed;
            }

            protected void closeSource() throws IOException {
                if (this.m_fSourceClosed) {
                    return;
                }
                this.m_fSourceClosed = true;
                this.poison();
            }

            protected boolean isSourceClosed() {
                return this.m_fSourceClosed;
            }

            protected void poison() throws IOException {
                try {
                    boolean accepted = this.f_queue.offer(POISON, 10L, TimeUnit.SECONDS);
                    if (!accepted) {
                        throw new IOException();
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }

            protected class Source
            extends OutputStream {
                protected Source() {
                }

                @Override
                public void write(int b) throws IOException {
                    this.checkClosed();
                    ByteBuffer buf = ByteBuffer.allocate(1);
                    buf.put((byte)b).flip();
                    this.writeInternal(buf);
                }

                @Override
                public void write(byte[] abSrc) throws IOException {
                    this.checkClosed();
                    this.write(abSrc, 0, abSrc.length);
                }

                @Override
                public void write(byte[] abSrc, int cbOff, int cbLen) throws IOException {
                    this.checkClosed();
                    if (abSrc == null) {
                        throw new NullPointerException();
                    }
                    if (cbOff > abSrc.length || cbOff < 0 || cbOff + cbOff > abSrc.length || cbOff + cbOff < 0) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (cbLen == 0) {
                        return;
                    }
                    this.writeInternal(ByteBuffer.wrap(this.copy(abSrc, cbOff, cbLen)));
                }

                @Override
                public void flush() throws IOException {
                    JerseyNettyIOPipe.this.f_channelCtx.flush();
                }

                @Override
                public void close() throws IOException {
                    JerseyNettyIOPipe.this.closeSource();
                }

                protected void writeInternal(ByteBuffer buffer) throws IOException {
                    try {
                        JerseyNettyIOPipe.this.f_queue.put(buffer);
                        this.checkClosed();
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(ie);
                    }
                }

                protected void checkClosed() throws IOException {
                    if (JerseyNettyIOPipe.this.isSourceClosed()) {
                        throw new IOException("Stream already closed.");
                    }
                }

                protected byte[] copy(byte[] abSrc, int cbOff, int cbLen) {
                    byte[] abCopy = new byte[cbLen];
                    System.arraycopy(abSrc, cbOff, abCopy, 0, cbLen);
                    return abCopy;
                }
            }

            protected class Sink
            implements ChunkedInput<ByteBuf> {
                protected final AtomicLong f_atmLngProgress = new AtomicLong();

                protected Sink() {
                }

                public boolean isEndOfInput() throws Exception {
                    if (JerseyNettyIOPipe.this.isSinkClosed()) {
                        return true;
                    }
                    ByteBuffer peek = JerseyNettyIOPipe.this.f_queue.peek();
                    return peek == POISON;
                }

                public void close() throws Exception {
                    JerseyNettyIOPipe.this.closeSink();
                }

                public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                    return this.readChunk(ctx.alloc());
                }

                public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                    int topRemaining;
                    if (JerseyNettyIOPipe.this.isSinkClosed()) {
                        return null;
                    }
                    CompositeByteBuf buffer = null;
                    boolean poisoned = false;
                    for (int cbWritten = 0; !JerseyNettyIOPipe.this.f_queue.isEmpty() && cbWritten < 1300; cbWritten += topRemaining) {
                        if (JerseyNettyIOPipe.this.f_queue.peek() == POISON) {
                            poisoned = true;
                            break;
                        }
                        ByteBuffer top = JerseyNettyIOPipe.this.f_queue.take();
                        topRemaining = top.remaining();
                        ByteBuf toAdd = allocator.buffer(topRemaining);
                        toAdd.setBytes(0, top);
                        toAdd.setIndex(0, topRemaining);
                        if (buffer == null) {
                            buffer = allocator.compositeBuffer();
                        }
                        buffer.addComponent(true, toAdd);
                        this.f_atmLngProgress.addAndGet(topRemaining);
                    }
                    return buffer != null && buffer.nioBufferCount() > 0 ? buffer : (poisoned ? null : Unpooled.EMPTY_BUFFER);
                }

                public long length() {
                    return -1L;
                }

                public long progress() {
                    return this.f_atmLngProgress.get();
                }
            }
        }
    }

    protected static class NettySecurityContext
    implements SecurityContext {
        private String m_sAuthScheme;
        private Principal m_principal;
        private boolean m_fSecure;

        protected NettySecurityContext(String sAuthScheme, Principal principal, boolean fSecure) {
            this.m_sAuthScheme = sAuthScheme;
            this.m_principal = principal;
            this.m_fSecure = fSecure;
        }

        public String getAuthenticationScheme() {
            return this.m_sAuthScheme;
        }

        public Principal getUserPrincipal() {
            return this.m_principal;
        }

        public boolean isSecure() {
            return this.m_fSecure;
        }

        public boolean isUserInRole(String sRole) {
            return false;
        }
    }

    protected class NettyServerHandler
    extends ChannelInboundHandlerAdapter {
        private final URI m_uriBase;
        private final LinkedBlockingDeque<InputStream> m_listInputStreams = new LinkedBlockingDeque();
        private final ApplicationContainer m_container;

        public NettyServerHandler(URI baseUri, ApplicationContainer container) {
            this.m_uriBase = baseUri;
            this.m_container = container;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof HttpRequest) {
                NettyHttpServer.this.incrementRequestCount();
                long ldtStart = Base.getLastSafeTimeMillis();
                this.clearInputStreamList();
                HttpRequest req = (HttpRequest)msg;
                if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
                    ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                SecurityInfo securityInfo = this.getSecurityInfo(ctx, req);
                String sAuth = securityInfo.getAuth();
                Principal principal = securityInfo.getPrincipal();
                Subject subject = securityInfo.getSubject();
                String uri = req.uri();
                int begin = uri.indexOf(SLASH_CHAR);
                int end = uri.indexOf(SLASH_CHAR, begin + 1);
                String sContext = begin >= 0 && end > 0 ? uri.substring(begin, uri.indexOf(SLASH_CHAR, begin + 1)) : uri;
                NettyHttpContainer container = this.m_container.m_mapContainers.get(sContext);
                if (container == null) {
                    sContext = null;
                    container = this.m_container.m_mapContainers.get("/");
                }
                if (container == null) {
                    this.send404(ctx, req);
                    return;
                }
                ContainerRequest requestContext = this.createContainerRequest(ctx, req, sContext, new NettySecurityContext(sAuth, principal, NettyHttpServer.this.isSecure()));
                requestContext.setWriter((ContainerResponseWriter)new NettyResponseWriter(ctx, req, container));
                requestContext.setRequestScopedInitializer(injectionManager -> {
                    ((Ref)injectionManager.getInstance(NettyHttpServer.this.ChannelHandlerContextTYPE)).set((Object)ctx);
                    ((Ref)injectionManager.getInstance(NettyHttpServer.this.ChannelTYPE)).set((Object)ctx.channel());
                });
                Subject finalSubject = subject;
                NettyHttpContainer finalContainer = container;
                container.getExecutorService().execute(() -> {
                    try {
                        NettyHttpServer.this.handleRequest(finalContainer.getApplicationHandler(), requestContext, finalSubject);
                        NettyHttpServer.this.logRequestTime(ldtStart);
                    }
                    catch (Exception e) {
                        Logger.err((String)("NettyServerHandler.channelRead()->handleRequest(), Caught an exception: " + e.getMessage()));
                    }
                });
            }
            if (msg instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)msg;
                ByteBuf content = httpContent.content();
                if (content.isReadable()) {
                    this.m_listInputStreams.add((InputStream)new ByteBufInputStream(content, true));
                }
                if (msg instanceof LastHttpContent) {
                    this.m_listInputStreams.add(NettyInputStream.END_OF_INPUT);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            NettyHttpServer.this.incrementErrors();
            if (cause != null) {
                Logger.err((String)String.format("Unexpected exception processing request: %s", cause.toString()), (Throwable)cause);
            }
            ctx.close();
        }

        protected SecurityInfo getSecurityInfo(ChannelHandlerContext ctx, HttpRequest req) {
            return new SecurityInfo(ctx, req).invoke();
        }

        protected void clearInputStreamList() {
            this.m_listInputStreams.forEach(in -> {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.m_listInputStreams.clear();
        }

        protected ContainerRequest createContainerRequest(ChannelHandlerContext ctx, HttpRequest req, String sContext, SecurityContext securityContext) {
            URI uriBase = this.m_uriBase;
            String sReqUri = req.uri();
            if (sReqUri.charAt(0) == SLASH_CHAR) {
                sReqUri = sReqUri.substring(1);
            }
            if (sContext != null) {
                String sContextNoSlash = sContext.substring(1);
                sReqUri = sContextNoSlash.equals(sReqUri) ? "" : sReqUri.substring(sReqUri.indexOf(sContextNoSlash) + sContext.length());
            }
            URI requestUri = URI.create(uriBase + ContainerUtils.encodeUnsafeCharacters((String)sReqUri));
            ContainerRequest requestContext = new ContainerRequest(uriBase, requestUri, req.method().name(), securityContext, new PropertiesDelegate(){
                private final Map<String, Object> properties = new HashMap<String, Object>();

                public Object getProperty(String name) {
                    return this.properties.get(name);
                }

                public Collection<String> getPropertyNames() {
                    return this.properties.keySet();
                }

                public void setProperty(String name, Object object) {
                    this.properties.put(name, object);
                }

                public void removeProperty(String name) {
                    this.properties.remove(name);
                }
            });
            if (req.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && HttpUtil.getContentLength((HttpMessage)req) > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)req)) {
                ctx.channel().closeFuture().addListener(future -> this.m_listInputStreams.add(NettyInputStream.END_OF_INPUT_ERROR));
                requestContext.setEntityStream((InputStream)new NettyInputStream(this.m_listInputStreams));
            } else {
                requestContext.setEntityStream(new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return -1;
                    }
                });
            }
            for (String name : req.headers().names()) {
                requestContext.headers(name, (Iterable)req.headers().getAll(name));
            }
            return requestContext;
        }

        protected void send404(ChannelHandlerContext ctx, HttpRequest req) {
            String sPath = req.uri();
            int nQuery = sPath.indexOf(63);
            sPath = nQuery == -1 ? sPath : sPath.substring(0, nQuery);
            String sMessage = String.format("Resource identified by path '%s' not found.", sPath);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpHeaders headers = response.headers();
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)String.format("text/plain; charset=%s", CharsetUtil.UTF_8.displayName()));
            headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)sMessage.length());
            response.content().writeBytes(sMessage.getBytes(CharsetUtil.UTF_8));
            ctx.writeAndFlush((Object)response);
        }

        protected class SecurityInfo {
            protected ChannelHandlerContext m_ctx;
            protected HttpRequest m_req;
            protected String m_sAuth;
            protected Subject m_subject;
            protected Principal m_principal;

            public SecurityInfo(ChannelHandlerContext ctx, HttpRequest req) {
                this.m_ctx = ctx;
                this.m_req = req;
            }

            public String getAuth() {
                return this.m_sAuth;
            }

            public Principal getPrincipal() {
                return this.m_principal;
            }

            public Subject getSubject() {
                return this.m_subject;
            }

            public SecurityInfo invoke() {
                if (NettyHttpServer.this.isAuthMethodBasic()) {
                    this.m_sAuth = "BASIC";
                    this.m_subject = NettyHttpServer.this.authenticate(this.m_req.headers().get("Authorization"));
                    if (this.m_subject == null) {
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                        response.headers().add("WWW-Authenticate", (Object)"Basic realm=\"Coherence REST\"");
                        this.m_ctx.writeAndFlush((Object)response);
                        return this;
                    }
                } else if (NettyHttpServer.this.isSecure() && NettyHttpServer.this.isAuthMethodCert()) {
                    SSLEngine engine = ((SslHandler)this.m_ctx.channel().pipeline().get(NettyHttpServer.SSL_HANDLER_NAME)).engine();
                    try {
                        this.m_sAuth = "CLIENT_CERT";
                        this.m_subject = NettyHttpServer.this.getSubjectFromSession(engine.getSession());
                    }
                    catch (Exception e) {
                        Logger.err((String)("Caught an exception obtaining request security details: " + e.getMessage()));
                    }
                }
                this.m_principal = this.m_subject == null ? EMPTY_PRINCIPAL : this.m_subject.getPrincipals().iterator().next();
                return this;
            }
        }
    }

    protected class NettyHttpContainer
    implements Container {
        private volatile ApplicationHandler m_hApplication;

        public NettyHttpContainer(Application application, ServiceLocator parentLocator) {
            this.m_hApplication = new ApplicationHandler(application, (Binder)new NettyBinder(), (Object)parentLocator);
            this.m_hApplication.onStartup((Container)this);
        }

        public ResourceConfig getConfiguration() {
            return this.m_hApplication.getConfiguration();
        }

        public ApplicationHandler getApplicationHandler() {
            return this.m_hApplication;
        }

        public void reload() {
            this.reload(this.m_hApplication.getConfiguration());
        }

        public void reload(ResourceConfig configuration) {
            this.m_hApplication.onShutdown((Container)this);
            this.m_hApplication = new ApplicationHandler((Application)configuration);
            this.m_hApplication.onReload((Container)this);
            this.m_hApplication.onStartup((Container)this);
        }

        ExecutorService getExecutorService() {
            return ((ExecutorServiceProvider)this.m_hApplication.getInjectionManager().getInstance(ExecutorServiceProvider.class)).getExecutorService();
        }

        ScheduledExecutorService getScheduledExecutorService() {
            return ((ScheduledExecutorServiceProvider)this.m_hApplication.getInjectionManager().getInstance(ScheduledExecutorServiceProvider.class)).getExecutorService();
        }
    }

    protected final class ApplicationContainer {
        private final Map<String, NettyHttpContainer> m_mapContainers = new HashMap<String, NettyHttpContainer>();

        protected ApplicationContainer() {
        }

        public void registerContainer(String sContext, NettyHttpContainer container) {
            this.m_mapContainers.put(sContext, container);
        }

        public void shutdown() {
            Map mapResources = NettyHttpServer.this.getResourceConfig();
            if (mapResources.isEmpty()) {
                return;
            }
            for (Map.Entry entry : mapResources.entrySet()) {
                NettyHttpContainer container = this.m_mapContainers.get(NettyHttpServer.this.normalizeResourceContextPath((String)entry.getKey()));
                if (container == null) continue;
                container.getApplicationHandler().onShutdown((Container)container);
            }
        }
    }

    protected class JerseyServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final ApplicationContainer f_container;

        protected JerseyServerInitializer(ApplicationContainer container) {
            this.f_container = container;
        }

        public void initChannel(SocketChannel ch) {
            InetSocketAddress channelAddress = ch.localAddress();
            URI uriBase = NettyHttpServer.this.initUri(channelAddress.getHostString(), channelAddress.getPort());
            ChannelPipeline p = ch.pipeline();
            if (NettyHttpServer.this.isSecure()) {
                p.addLast(NettyHttpServer.SSL_HANDLER_NAME, (ChannelHandler)new JdkSslContext(NettyHttpServer.this.getSSLContext(), false, NettyHttpServer.this.isAuthMethodCert() ? ClientAuth.REQUIRE : ClientAuth.NONE).newHandler(ch.alloc()));
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec()});
            p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            p.addLast(new ChannelHandler[]{new NettyServerHandler(uriBase, this.f_container)});
        }
    }
}

