/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.http.netty;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingDeque;

public class NettyInputStream
extends InputStream {
    private volatile boolean m_fEnd = false;
    public static final InputStream END_OF_INPUT = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }

        public String toString() {
            return "END_OF_INPUT " + super.toString();
        }
    };
    public static final InputStream END_OF_INPUT_ERROR = new InputStream(){

        @Override
        public int read() throws IOException {
            return 0;
        }

        public String toString() {
            return "END_OF_INPUT_ERROR " + super.toString();
        }
    };
    private final LinkedBlockingDeque<InputStream> isList;

    public NettyInputStream(LinkedBlockingDeque<InputStream> isList) {
        this.isList = isList;
    }

    private int readInternal(ISReader isReader) throws IOException {
        if (this.m_fEnd) {
            return -1;
        }
        try {
            InputStream take = this.isList.take();
            if (this.checkEndOfInput(take)) {
                return -1;
            }
            int read = isReader.readFrom(take);
            if (take.available() > 0) {
                this.isList.addFirst(take);
            } else {
                take.close();
            }
            return read;
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted.", e);
        }
    }

    @Override
    public int read(byte[] abDest, int cbOff, int cbLen) throws IOException {
        return this.readInternal(take -> take.read(abDest, cbOff, cbLen));
    }

    @Override
    public int read() throws IOException {
        return this.readInternal(InputStream::read);
    }

    @Override
    public int available() throws IOException {
        InputStream peek = this.isList.peek();
        if (peek != null) {
            return peek.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.isList.forEach(is -> {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private boolean checkEndOfInput(InputStream inToCheck) throws IOException {
        if (inToCheck == END_OF_INPUT) {
            this.m_fEnd = true;
            return true;
        }
        if (inToCheck == END_OF_INPUT_ERROR) {
            this.m_fEnd = true;
            throw new IOException("Connection was closed prematurely.");
        }
        return false;
    }

    private static interface ISReader {
        public int readFrom(InputStream var1) throws IOException;
    }
}

