/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.ai.hnsw;

import com.oracle.coherence.ai.Vector;
import com.oracle.coherence.ai.VectorIndex;
import com.oracle.coherence.ai.VectorIndexExtractor;
import com.oracle.coherence.ai.search.BinaryQueryResult;
import com.oracle.coherence.hnswlib.Hnswlib;
import com.oracle.coherence.hnswlib.Index;
import com.oracle.coherence.hnswlib.QueryTuple;
import com.oracle.coherence.hnswlib.SpaceName;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HnswIndex<K, V>
extends AbstractEvolvable
implements VectorIndexExtractor<V, float[]>,
ExternalizableLite,
EvolvablePortableObject {
    public static final int IMPL_VERSION = 0;
    private static final BinaryQueryResult[] EMPTY_RESULT = new BinaryQueryResult[0];
    public static final String DEFAULT_SPACE_NAME = "COSINE";
    @JsonbProperty(value="extractor")
    private ValueExtractor<V, Vector<float[]>> m_extractor;
    @JsonbProperty(value="dimension")
    private int m_nDimension;
    @JsonbProperty(value="spaceName")
    private String m_sSpaceName = "COSINE";
    @JsonbProperty(value="maxElements")
    private int m_cMaxElements = 4096;
    @JsonbProperty(value="m")
    private int m_nM = 16;
    @JsonbProperty(value="efConstruction")
    private int m_nEfConstr = 200;
    @JsonbProperty(value="efSearch")
    private int m_nEfSearch = 50;
    @JsonbProperty(value="randomSeed")
    private int m_nRandomSeed = 100;

    public HnswIndex() {
    }

    public HnswIndex(ValueExtractor<V, Vector<float[]>> extractor, int nDimension) {
        this.m_extractor = ValueExtractor.of(Objects.requireNonNull(extractor));
        this.m_nDimension = nDimension;
    }

    public HnswIndex(ValueExtractor<V, Vector<float[]>> extractor, String sSpaceName, int nDimension) {
        this(extractor, nDimension);
        this.m_sSpaceName = sSpaceName == null || sSpaceName.isBlank() ? "" : sSpaceName;
    }

    public String getSpaceName() {
        return this.m_sSpaceName;
    }

    public HnswIndex<K, V> setSpaceName(String sSpaceName) {
        this.m_sSpaceName = sSpaceName;
        return this;
    }

    public ValueExtractor<V, Vector<float[]>> getExtractor() {
        return this.m_extractor;
    }

    public int getDimension() {
        return this.m_nDimension;
    }

    public int getMaxElements() {
        return this.m_cMaxElements;
    }

    public HnswIndex<K, V> setMaxElements(int cMaxElements) {
        this.m_cMaxElements = cMaxElements;
        return this;
    }

    public int getM() {
        return this.m_nM;
    }

    public HnswIndex<K, V> setM(int nM) {
        this.m_nM = nM;
        return this;
    }

    public int getEfConstr() {
        return this.m_nEfConstr;
    }

    public HnswIndex<K, V> setEfConstruction(int nEfConstr) {
        this.m_nEfConstr = nEfConstr;
        return this;
    }

    public int getEfSearch() {
        return this.m_nEfSearch;
    }

    public HnswIndex<K, V> setEfSearch(int nEfSearch) {
        this.m_nEfSearch = nEfSearch;
        return this;
    }

    public int getRandomSeed() {
        return this.m_nRandomSeed;
    }

    public HnswIndex<K, V> setRandomSeed(int nRandomSeed) {
        this.m_nRandomSeed = nRandomSeed;
        return this;
    }

    public MapIndex<K, V, Vector<float[]>> createIndex(boolean fSorted, Comparator comparator, Map<ValueExtractor<V, Vector<float[]>>, MapIndex> map, BackingMapContext backingMapContext) {
        HnswMapIndex hnswMapIndex = new HnswMapIndex(backingMapContext);
        map.put(this.m_extractor, (MapIndex)hnswMapIndex);
        return hnswMapIndex;
    }

    public MapIndex<K, V, Vector<float[]>> destroyIndex(Map<ValueExtractor<V, Vector<float[]>>, MapIndex> map) {
        HnswMapIndex index = (HnswMapIndex)map.remove(this.m_extractor);
        index.clear();
        return index;
    }

    public Vector<float[]> extract(V v) {
        return (Vector)this.m_extractor.extract(v);
    }

    public int getImplVersion() {
        return 0;
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_extractor = (ValueExtractor)in.readObject(0);
        this.m_nDimension = in.readInt(1);
        this.m_sSpaceName = in.readString(2);
        this.m_cMaxElements = in.readInt(3);
        this.m_nM = in.readInt(4);
        this.m_nEfConstr = in.readInt(5);
        this.m_nEfSearch = in.readInt(6);
        this.m_nRandomSeed = in.readInt(7);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_extractor);
        out.writeInt(1, this.m_nDimension);
        out.writeString(2, this.m_sSpaceName);
        out.writeInt(3, this.m_cMaxElements);
        out.writeInt(4, this.m_nM);
        out.writeInt(5, this.m_nEfConstr);
        out.writeInt(6, this.m_nEfSearch);
        out.writeInt(7, this.m_nRandomSeed);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject((DataInput)in);
        this.m_nDimension = ExternalizableHelper.readInt((DataInput)in);
        this.m_sSpaceName = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.m_cMaxElements = ExternalizableHelper.readInt((DataInput)in);
        this.m_nM = ExternalizableHelper.readInt((DataInput)in);
        this.m_nEfConstr = ExternalizableHelper.readInt((DataInput)in);
        this.m_nEfSearch = ExternalizableHelper.readInt((DataInput)in);
        this.m_nRandomSeed = ExternalizableHelper.readInt((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_extractor);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nDimension);
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sSpaceName);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_cMaxElements);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nM);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nEfConstr);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nEfSearch);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.m_nRandomSeed);
    }

    public class HnswMapIndex
    implements VectorIndex<K, V, Vector<float[]>>,
    Closeable {
        private final BackingMapContext f_backingMapContext;
        private final Index f_index;
        private final AtomicInteger f_idGenerator = new AtomicInteger();
        private final Int2ObjectMap<Binary> f_mapLabelsToKeys;
        private final Object2IntMap<Binary> f_mapKeysToLabels;
        private final ReadWriteLock f_lock = new ReentrantReadWriteLock();

        public HnswMapIndex(BackingMapContext backingMapContext) {
            this.f_backingMapContext = backingMapContext;
            this.f_mapLabelsToKeys = new Int2ObjectOpenHashMap(HnswIndex.this.m_cMaxElements);
            this.f_mapKeysToLabels = new Object2IntOpenHashMap(HnswIndex.this.m_cMaxElements);
            Index index = new Index(SpaceName.valueOf(HnswIndex.this.m_sSpaceName.toUpperCase()), HnswIndex.this.m_nDimension);
            index.initialize(HnswIndex.this.m_cMaxElements, HnswIndex.this.m_nM, HnswIndex.this.m_nEfConstr, HnswIndex.this.m_nRandomSeed, true);
            index.setEf(HnswIndex.this.m_nEfSearch);
            this.f_index = index;
        }

        public int getDimensions() {
            return HnswIndex.this.m_nDimension;
        }

        public ValueExtractor<V, Vector<float[]>> getValueExtractor() {
            return HnswIndex.this.m_extractor;
        }

        public boolean isOrdered() {
            return false;
        }

        public boolean isPartial() {
            return false;
        }

        public Map<Vector<float[]>, Set<K>> getIndexContents() {
            return null;
        }

        public Object get(K k) {
            return null;
        }

        public Comparator<Vector<float[]>> getComparator() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insert(Map.Entry<? extends K, ? extends V> entry) {
            Vector v = (Vector)InvocableMapHelper.extractFromEntry(HnswIndex.this.m_extractor, entry);
            if (v != null) {
                Binary binKey = ((BinaryEntry)entry).getBinaryKey();
                int nId = this.f_idGenerator.incrementAndGet();
                this.f_lock.writeLock().lock();
                try {
                    this.f_mapLabelsToKeys.put(nId, (Object)binKey);
                    this.f_mapKeysToLabels.put((Object)binKey, nId);
                    this.f_index.addItem((float[])v.get(), nId, true);
                }
                finally {
                    this.f_lock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Map.Entry<? extends K, ? extends V> entry) {
            Vector v = (Vector)InvocableMapHelper.extractFromEntry(HnswIndex.this.m_extractor, entry);
            Binary binKey = ((BinaryEntry)entry).getBinaryKey();
            int nId = this.f_mapKeysToLabels.getInt((Object)binKey);
            if (v != null) {
                if (nId > 0 && this.f_index.hasId(nId)) {
                    this.f_lock.writeLock().lock();
                    try {
                        this.f_index.addItem((float[])v.get(), nId, true);
                    }
                    finally {
                        this.f_lock.writeLock().unlock();
                    }
                } else {
                    this.insert(entry);
                }
            } else if (nId > 0) {
                this.f_lock.writeLock().lock();
                try {
                    this.f_mapLabelsToKeys.remove(nId);
                    this.f_mapKeysToLabels.removeInt((Object)binKey);
                }
                finally {
                    this.f_lock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(Map.Entry<? extends K, ? extends V> entry) {
            Binary binKey = ((BinaryEntry)entry).getBinaryKey();
            int nId = this.f_mapKeysToLabels.getInt((Object)binKey);
            if (nId > 0 && this.f_index.hasId(nId)) {
                this.f_lock.writeLock().lock();
                try {
                    this.f_index.markDeleted(nId);
                    this.f_mapLabelsToKeys.remove(nId);
                    this.f_mapKeysToLabels.removeInt((Object)binKey);
                }
                finally {
                    this.f_lock.writeLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BinaryQueryResult[] query(Vector<float[]> vector, int k, Filter<?> filter) {
            this.f_lock.readLock().lock();
            try {
                BinaryQueryResult[] queryFilter;
                QueryTuple tuple;
                if (filter == null || filter instanceof AlwaysFilter) {
                    tuple = this.f_index.knnQuery((float[])vector.get(), k);
                } else {
                    queryFilter = id -> {
                        Binary binKey = (Binary)this.f_mapLabelsToKeys.get(id);
                        InvocableMap.Entry entry = this.f_backingMapContext.getReadOnlyEntry((Object)binKey);
                        return InvocableMapHelper.evaluateEntry((Filter)filter, (Map.Entry)entry);
                    };
                    tuple = this.f_index.knnQuery((float[])vector.get(), k, (Hnswlib.QueryFilter)queryFilter);
                }
                if (tuple.empty()) {
                    queryFilter = EMPTY_RESULT;
                    return queryFilter;
                }
                int[] aIds = tuple.getIds();
                float[] aCoefficients = tuple.getCoefficients();
                int nResult = tuple.count();
                BinaryQueryResult[] aResults = new BinaryQueryResult[nResult];
                for (int i = 0; i < nResult; ++i) {
                    Binary binKey = (Binary)this.f_mapLabelsToKeys.get(aIds[i]);
                    Binary binValue = this.f_backingMapContext.getReadOnlyEntry((Object)binKey).asBinaryEntry().getBinaryValue();
                    float nDistance = Math.abs(aCoefficients[i]);
                    aResults[i] = new BinaryQueryResult((double)nDistance, binKey, binValue);
                }
                BinaryQueryResult[] binaryQueryResultArray = aResults;
                return binaryQueryResultArray;
            }
            finally {
                this.f_lock.readLock().unlock();
            }
        }

        @Override
        public void close() {
            this.clear();
        }

        void clear() {
            this.f_lock.writeLock().lock();
            try {
                this.f_index.clear();
            }
            finally {
                this.f_lock.writeLock().unlock();
            }
        }
    }
}

