/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.internal.extend.messageFactory;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.MessageHelper;
import com.oracle.coherence.grpc.TopicHelper;
import com.oracle.coherence.grpc.internal.extend.message.response.BoolValueResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.CollectionOfInt32Response;
import com.oracle.coherence.grpc.internal.extend.message.response.EmptyResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.Int32ValueResponse;
import com.oracle.coherence.grpc.internal.extend.message.response.MapOfChannelAndPositionResponse;
import com.oracle.coherence.grpc.messages.common.v1.CollectionOfInt32;
import com.oracle.coherence.grpc.messages.topic.v1.ChannelAndPosition;
import com.oracle.coherence.grpc.messages.topic.v1.CommitResponse;
import com.oracle.coherence.grpc.messages.topic.v1.CommitResponseStatus;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureSubscriberGroupRequest;
import com.oracle.coherence.grpc.messages.topic.v1.EnsureSubscriptionRequest;
import com.oracle.coherence.grpc.messages.topic.v1.GetRemainingMessagesRequest;
import com.oracle.coherence.grpc.messages.topic.v1.InitializeSubscriptionRequest;
import com.oracle.coherence.grpc.messages.topic.v1.InitializeSubscriptionResponse;
import com.oracle.coherence.grpc.messages.topic.v1.NamedTopicEvent;
import com.oracle.coherence.grpc.messages.topic.v1.PublishRequest;
import com.oracle.coherence.grpc.messages.topic.v1.ReceiveRequest;
import com.oracle.coherence.grpc.messages.topic.v1.ReceiveResponse;
import com.oracle.coherence.grpc.messages.topic.v1.ReceiveStatus;
import com.oracle.coherence.grpc.messages.topic.v1.ResponseType;
import com.oracle.coherence.grpc.messages.topic.v1.SeekRequest;
import com.oracle.coherence.grpc.messages.topic.v1.SeekResponse;
import com.oracle.coherence.grpc.messages.topic.v1.SeekedPositions;
import com.oracle.coherence.grpc.messages.topic.v1.TopicEventType;
import com.oracle.coherence.grpc.messages.topic.v1.TopicPosition;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequest;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceRequestType;
import com.oracle.coherence.grpc.messages.topic.v1.TopicServiceResponse;
import com.tangosol.coherence.component.net.extend.message.GrpcMessageWrapper;
import com.tangosol.coherence.component.net.extend.message.response.GrpcResponse;
import com.tangosol.coherence.component.net.extend.messageFactory.BaseTopicMessageFactory;
import com.tangosol.coherence.component.net.extend.messageFactory.GrpcMessageFactory;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedTopicFactory;
import com.tangosol.internal.net.topic.PublishResult;
import com.tangosol.internal.net.topic.ReceiveResult;
import com.tangosol.internal.net.topic.SeekResult;
import com.tangosol.internal.net.topic.SimpleReceiveResult;
import com.tangosol.io.Serializer;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Response;
import com.tangosol.net.topic.Position;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Binary;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.ValueExtractor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GrpcNamedTopicFactory
extends NamedTopicFactory
implements GrpcMessageFactory<TopicServiceRequest, TopicServiceResponse> {
    private static ListMap<String, Class<?>> __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put((Object)"GetRemainingMessagesRequest", GrpcGetRemainingMessagesRequest.class);
        __mapChildren.put((Object)"EnsureSubscriberGroupRequest", GrpcEnsureSubscriberGroupRequest.class);
        __mapChildren.put((Object)"DestroySubscriberGroupRequest", GrpcDestroySubscriberGroupRequest.class);
        __mapChildren.put((Object)"PublishRequest", GrpcPublishRequest.class);
        __mapChildren.put((Object)"InitializeSubscriptionRequest", GrpcInitializeSubscriptionRequest.class);
        __mapChildren.put((Object)"EnsureSubscriptionRequest", GrpcEnsureSubscriptionRequest.class);
        __mapChildren.put((Object)"GetOwnedChannelsRequest", GrpcGetOwnedChannelsRequest.class);
        __mapChildren.put((Object)"ReceiveRequest", GrpcReceiveRequest.class);
        __mapChildren.put((Object)"PeekRequest", GrpcPeekRequest.class);
        __mapChildren.put((Object)"CommitRequest", GrpcCommitRequest.class);
        __mapChildren.put((Object)"IsCommitedRequest", GrpcIsCommitedRequest.class);
        __mapChildren.put((Object)"GetLastCommitedRequest", GrpcGetLastCommitedRequest.class);
        __mapChildren.put((Object)"GetHeadsRequest", GrpcGetHeadsRequest.class);
        __mapChildren.put((Object)"GetTailsRequest", GrpcGetTailsRequest.class);
        __mapChildren.put((Object)"SeekRequest", GrpcSeekRequest.class);
        __mapChildren.put((Object)"HeartbeatRequest", GrpcHeartbeatRequest.class);
        __mapChildren.put((Object)"Response", BaseTopicMessageFactory.TopicsResponse.class);
        __mapChildren.put((Object)"PublisherEvent", NamedTopicFactory.PublisherEvent.class);
        __mapChildren.put((Object)"GetSubscription", NamedTopicFactory.GetSubscriptionRequest.class);
        __mapChildren.put((Object)"SubscriberEvent", NamedTopicFactory.SubscriberChannelEvent.class);
        __mapChildren.put((Object)"DestroyEvent", NamedTopicFactory.DestroyEvent.class);
    }

    protected Map<String, Class<?>> get_ChildClasses() {
        return __mapChildren;
    }

    public <M extends GrpcMessageWrapper> M createRequestMessage(TopicServiceRequest request, Serializer serializer) {
        GrpcMessageWrapper message = (GrpcMessageWrapper)(switch (request.getType()) {
            case TopicServiceRequestType.EnsureSubscriberGroup -> this.createMessage(2);
            case TopicServiceRequestType.DestroySubscriberGroup -> this.createMessage(3);
            case TopicServiceRequestType.GetRemainingMessages -> this.createMessage(1);
            case TopicServiceRequestType.GetTails -> this.createMessage(22);
            case TopicServiceRequestType.Publish -> this.createMessage(7);
            case TopicServiceRequestType.InitializeSubscription -> this.createMessage(10);
            case TopicServiceRequestType.EnsureSubscription -> this.createMessage(11);
            case TopicServiceRequestType.GetSubscriberHeads -> this.createMessage(21);
            case TopicServiceRequestType.GetLastCommited -> this.createMessage(20);
            case TopicServiceRequestType.GetOwnedChannels -> this.createMessage(13);
            case TopicServiceRequestType.SubscriberHeartbeat -> this.createMessage(24);
            case TopicServiceRequestType.IsPositionCommitted -> this.createMessage(19);
            case TopicServiceRequestType.PeekAtPosition -> this.createMessage(16);
            case TopicServiceRequestType.Receive -> this.createMessage(14);
            case TopicServiceRequestType.SeekSubscriber -> this.createMessage(23);
            case TopicServiceRequestType.CommitPosition -> this.createMessage(17);
            default -> throw new IllegalArgumentException("Unsupported request type: " + String.valueOf((Object)request.getType()));
        });
        if (request.hasMessage()) {
            message.setProtoMessage(request.getMessage(), serializer);
        }
        return (M)message;
    }

    public TopicServiceResponse createResponse(GrpcResponse response) {
        com.google.protobuf.Message protoResponse = response.getProtoResponse();
        TopicServiceResponse.Builder builder = TopicServiceResponse.newBuilder().setProxyId(response.getProxyId()).setMessage(Any.pack((com.google.protobuf.Message)protoResponse));
        return builder.build();
    }

    public TopicServiceResponse toProtoMessage(Message message, int nProxyId) {
        int nTypeId = message.getTypeId();
        if (nTypeId == 6 || nTypeId == 25 || nTypeId == 4) {
            ResponseType responseType = ResponseType.Event;
            TopicServiceResponse.Builder builder = TopicServiceResponse.newBuilder().setProxyId(nProxyId).setType(responseType);
            GeneratedMessageV3 payload = switch (nTypeId) {
                case 6 -> TopicHelper.toProtobufPublisherEvent((NamedTopicFactory.PublisherEvent)message);
                case 4 -> NamedTopicEvent.newBuilder().setType(TopicEventType.TopicDestroyed).build();
                case 25 -> TopicHelper.toProtobufSubscriberEvent((NamedTopicFactory.SubscriberChannelEvent)message);
                default -> throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message));
            };
            builder.setMessage(Any.pack((com.google.protobuf.Message)payload));
            return builder.build();
        }
        return null;
    }

    protected <T extends com.google.protobuf.Message> T unpack(TopicServiceRequest request, Class<T> type) {
        try {
            Any any = request.getMessage();
            return (T)any.unpack(type);
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)("Could not unpack message field of type " + type.getName()));
        }
    }

    static {
        GrpcNamedTopicFactory.__initStatic();
    }

    public static class GrpcGetRemainingMessagesRequest
    extends NamedTopicFactory.GetRemainingMessagesRequest
    implements GrpcMessageWrapper {
        public GrpcGetRemainingMessagesRequest() {
            this.setResponse((Response)new Int32ValueResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            GetRemainingMessagesRequest request = MessageHelper.unpack(any, GetRemainingMessagesRequest.class);
            this.setSubscriberGroup(request.getSubscriberGroup());
            List<Integer> list = request.getChannelsList();
            this.setChannels(list.stream().mapToInt(i -> i).toArray());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureSubscriberGroupRequest
    extends NamedTopicFactory.EnsureSubscriberGroupRequest
    implements GrpcMessageWrapper {
        public GrpcEnsureSubscriberGroupRequest() {
            this.setResponse((Response)new EmptyResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            EnsureSubscriberGroupRequest request = MessageHelper.unpack(any, EnsureSubscriberGroupRequest.class);
            this.setSubscriberGroup(request.getSubscriberGroup());
            if (request.hasFilter()) {
                Filter filter = (Filter)BinaryHelper.fromByteString(request.getFilter(), serializer);
                this.setFilter(filter);
            }
            if (request.hasExtractor()) {
                ValueExtractor extractor = (ValueExtractor)BinaryHelper.fromByteString(request.getExtractor(), serializer);
                this.setExtractor(extractor);
            }
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcDestroySubscriberGroupRequest
    extends NamedTopicFactory.DestroySubscriberGroupRequest
    implements GrpcMessageWrapper {
        public GrpcDestroySubscriberGroupRequest() {
            this.setResponse((Response)new EmptyResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            StringValue sGroup = MessageHelper.unpack(any, StringValue.class);
            this.setSubscriberGroup(sGroup.getValue());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcPublishRequest
    extends NamedTopicFactory.PublishRequest
    implements GrpcMessageWrapper {
        public GrpcPublishRequest() {
            this.setResponse((Response)new GrpcPublishResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            PublishRequest request = MessageHelper.unpack(any, PublishRequest.class);
            this.setChannel(request.getChannel());
            this.setBinaries(BinaryHelper.toListOfBinary(request.getValuesList()));
            if (request.hasNotificationIdentifier()) {
                this.setNotify(request.getNotificationIdentifier());
            }
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcInitializeSubscriptionRequest
    extends NamedTopicFactory.InitializeSubscriptionRequest
    implements GrpcMessageWrapper {
        public GrpcInitializeSubscriptionRequest() {
            this.setResponse((Response)new GrpcInitializeSubscriptionResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            InitializeSubscriptionRequest request = MessageHelper.unpack(any, InitializeSubscriptionRequest.class);
            this.setDisconnected(request.getDisconnected());
            this.setReconnect(request.getReconnect());
            this.setForceReconnect(request.getForceReconnect());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcEnsureSubscriptionRequest
    extends NamedTopicFactory.EnsureSubscriptionRequest
    implements GrpcMessageWrapper {
        public GrpcEnsureSubscriptionRequest() {
            this.setResponse((Response)new BoolValueResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            EnsureSubscriptionRequest request = MessageHelper.unpack(any, EnsureSubscriptionRequest.class);
            this.setSubscriptionId(request.getSubscriptionId());
            this.setForceReconnect(request.getForceReconnect());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcGetOwnedChannelsRequest
    extends NamedTopicFactory.GetOwnedChannelsRequest
    implements GrpcMessageWrapper {
        public GrpcGetOwnedChannelsRequest() {
            this.setResponse((Response)new CollectionOfInt32Response());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcReceiveRequest
    extends NamedTopicFactory.ReceiveRequest
    implements GrpcMessageWrapper {
        public GrpcReceiveRequest() {
            this.setResponse((Response)new GrpcReceiveResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            ReceiveRequest request = MessageHelper.unpack(any, ReceiveRequest.class);
            this.setChannel(request.getChannel());
            this.setMaxElements(request.getMaxMessages());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcPeekRequest
    extends NamedTopicFactory.PeekRequest
    implements GrpcMessageWrapper {
        public GrpcPeekRequest() {
            this.setResponse((Response)new GrpcPeekResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            ChannelAndPosition cp = MessageHelper.unpack(any, ChannelAndPosition.class);
            this.setChannel(cp.getChannel());
            this.setPosition(TopicHelper.fromProtobufPosition(cp.getPosition()));
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcCommitRequest
    extends NamedTopicFactory.CommitRequest
    implements GrpcMessageWrapper {
        public GrpcCommitRequest() {
            this.setResponse((Response)new GrpcCommitResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            ChannelAndPosition cp = MessageHelper.unpack(any, ChannelAndPosition.class);
            this.setChannel(cp.getChannel());
            this.setPosition(TopicHelper.fromProtobufPosition(cp.getPosition()));
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcIsCommitedRequest
    extends NamedTopicFactory.IsCommitedRequest
    implements GrpcMessageWrapper {
        public GrpcIsCommitedRequest() {
            this.setResponse((Response)new BoolValueResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            ChannelAndPosition cp = MessageHelper.unpack(any, ChannelAndPosition.class);
            this.setChannel(cp.getChannel());
            this.setPosition(TopicHelper.fromProtobufPosition(cp.getPosition()));
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcGetLastCommitedRequest
    extends NamedTopicFactory.GetLastCommitedRequest
    implements GrpcMessageWrapper {
        public GrpcGetLastCommitedRequest() {
            this.setResponse((Response)new MapOfChannelAndPositionResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcGetHeadsRequest
    extends NamedTopicFactory.GetHeadsRequest
    implements GrpcMessageWrapper {
        public GrpcGetHeadsRequest() {
            this.setResponse((Response)new MapOfChannelAndPositionResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            CollectionOfInt32 col = MessageHelper.unpack(any, CollectionOfInt32.class);
            this.setChannels(MessageHelper.toIntArray(col));
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcGetTailsRequest
    extends NamedTopicFactory.GetTailsRequest
    implements GrpcMessageWrapper {
        public GrpcGetTailsRequest() {
            this.setResponse((Response)new MapOfChannelAndPositionResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcSeekRequest
    extends NamedTopicFactory.SeekRequest
    implements GrpcMessageWrapper {
        public GrpcSeekRequest() {
            this.setResponse((Response)new SeekResponse());
        }

        public void setProtoMessage(Any any, Serializer serializer) {
            SeekRequest request = MessageHelper.unpack(any, SeekRequest.class);
            if (request.hasByPosition()) {
                this.setPositions(TopicHelper.fromProtobufChannelAndPosition(request.getByPosition()));
            } else {
                this.setTimestamps(TopicHelper.fromProtobufChannelAndTimestamp(request.getByTimestamp()));
            }
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcHeartbeatRequest
    extends NamedTopicFactory.HeartbeatRequest
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
            boolean fAsync = false;
            if (any != null) {
                BoolValue b = MessageHelper.unpack(any, BoolValue.class);
                fAsync = b != null && b.getValue();
            }
            this.setAsync(fAsync);
            this.setResponse((Response)new EmptyResponse());
        }

        public GrpcResponse getResponse() {
            return (GrpcResponse)super.getResponse();
        }
    }

    public static class GrpcPublisherEvent
    extends NamedTopicFactory.PublisherEvent
    implements GrpcMessageWrapper {
        public void setProtoMessage(Any any, Serializer serializer) {
        }

        public GrpcResponse getResponse() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SeekResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            SeekResponse.Builder builder = com.oracle.coherence.grpc.messages.topic.v1.SeekResponse.newBuilder();
            Map map = (Map)this.getResult();
            for (Map.Entry entry : map.entrySet()) {
                SeekResult result = (SeekResult)entry.getValue();
                SeekedPositions.Builder positionBuilder = SeekedPositions.newBuilder();
                TopicPosition head = TopicHelper.toProtobufPosition(result.getHead());
                TopicPosition seeked = TopicHelper.toProtobufPosition(result.getSeekPosition());
                if (head != null) {
                    positionBuilder.setHead(head);
                }
                if (seeked != null) {
                    positionBuilder.setSeekedTo(seeked);
                }
                builder.putPositions((Integer)entry.getKey(), positionBuilder.build());
            }
            return builder.build();
        }
    }

    public static class GrpcCommitResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            Object[] aoResult = (Object[])this.getResult();
            TopicPosition head = TopicHelper.toProtobufPosition((Position)aoResult[1]);
            Subscriber.CommitResult result = (Subscriber.CommitResult)aoResult[0];
            CommitResponseStatus status = switch (result.getStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case Subscriber.CommitResultStatus.Committed -> CommitResponseStatus.Committed;
                case Subscriber.CommitResultStatus.AlreadyCommitted -> CommitResponseStatus.AlreadyCommitted;
                case Subscriber.CommitResultStatus.Rejected -> CommitResponseStatus.Rejected;
                case Subscriber.CommitResultStatus.Unowned -> CommitResponseStatus.Unowned;
                case Subscriber.CommitResultStatus.NothingToCommit -> CommitResponseStatus.NothingToCommit;
            };
            CommitResponse.Builder builder = CommitResponse.newBuilder().setHead(head).setStatus(status);
            result.getChannel().ifPresent(builder::setChannel);
            result.getError().ifPresent(err -> builder.setError(ErrorsHelper.createErrorMessage(err, this.m_serializer)));
            result.getPosition().ifPresent(pos -> builder.setPosition(TopicHelper.toProtobufPosition(pos)));
            return builder.build();
        }
    }

    public static class GrpcPeekResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            Subscriber.Element element = (Subscriber.Element)this.getResult();
            return TopicHelper.toProtobufTopicElement(element);
        }
    }

    public static class GrpcReceiveResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            Object oResult = this.getResult();
            if (oResult instanceof Throwable) {
                return ErrorsHelper.createErrorMessage((Throwable)oResult, this.m_serializer);
            }
            SimpleReceiveResult result = (SimpleReceiveResult)oResult;
            ReceiveStatus status = switch (result.getStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case ReceiveResult.Status.Success -> ReceiveStatus.ReceiveSuccess;
                case ReceiveResult.Status.Exhausted -> ReceiveStatus.ChannelExhausted;
                case ReceiveResult.Status.NotAllocatedChannel -> ReceiveStatus.ChannelNotAllocatedChannel;
                case ReceiveResult.Status.UnknownSubscriber -> ReceiveStatus.UnknownSubscriber;
            };
            ReceiveResponse.Builder builder = ReceiveResponse.newBuilder().setHeadPosition(TopicHelper.toProtobufPosition(result.getHead())).setRemainingValues(result.getRemainingElementCount()).setStatus(status);
            for (Binary binary : result.getElements()) {
                builder.addValues(BinaryHelper.toByteString(binary));
            }
            return builder.build();
        }
    }

    public static class GrpcInitializeSubscriptionResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            Object[] aoResult = (Object[])this.getResult();
            Timestamp timestamp = Timestamps.fromMillis((long)((Long)aoResult[1]));
            Object[] aoPosition = (Object[])aoResult[2];
            List<TopicPosition> heads = Arrays.stream(aoPosition).map(o -> TopicHelper.toProtobufPosition((Position)o)).toList();
            return InitializeSubscriptionResponse.newBuilder().setSubscriptionId((Long)aoResult[0]).setTimestamp(timestamp).addAllHeads(heads).build();
        }
    }

    public static class GrpcPublishResponse
    extends GrpcResponse {
        public com.google.protobuf.Message getProtoResponse() {
            PublishResult result = (PublishResult)this.getResult();
            return TopicHelper.toProtobufPublishResult(result, this.m_serializer);
        }
    }
}

