/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.v0;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.messages.cache.v0.Entry;
import com.oracle.coherence.grpc.messages.cache.v0.EntryResult;
import com.oracle.coherence.grpc.messages.cache.v0.OptionalValue;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.Service;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public abstract class RequestHolder<Req, Res> {
    protected final Req f_request;
    protected final String f_sFormat;
    protected final Executor f_executor;
    protected final Service f_service;
    protected Converter<Binary, Binary> m_converterDown;
    protected Converter<Binary, Binary> m_converterUp;
    protected final Serializer f_serializer;
    protected Object m_result;

    public RequestHolder(Req request, String sFormat, Serializer serializer, Service service, Executor executor) {
        this.f_request = request;
        this.f_sFormat = sFormat;
        this.f_serializer = serializer;
        this.f_service = service;
        this.f_executor = executor;
    }

    public Req getRequest() {
        return this.f_request;
    }

    public Res getResult() {
        return (Res)this.m_result;
    }

    public Serializer getServiceSerializer() {
        return this.f_service.getSerializer();
    }

    public <T> T getDeserializedResult() {
        return (T)ExternalizableHelper.fromBinary((Binary)((Binary)this.m_result), (Serializer)this.getServiceSerializer());
    }

    public <T> T fromBinary(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getServiceSerializer());
    }

    public <T> T deserialize(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getServiceSerializer());
    }

    public <T> T deserializeRequest(ByteString bytes) {
        return (T)ExternalizableHelper.fromBinary((Binary)BinaryHelper.toBinary(bytes), (Serializer)this.f_serializer);
    }

    public <T> RequestHolder<Req, T> setResult(T t) {
        this.m_result = t;
        return this;
    }

    public Serializer getSerializer() {
        return this.f_serializer;
    }

    public Binary convertUp(Binary binary) {
        if (binary == null) {
            return null;
        }
        return (Binary)this.ensureConverterUp().convert((Object)binary);
    }

    public Binary convertDown(Supplier<ByteString> supplier) {
        return this.convertDown(supplier.get());
    }

    public Binary convertDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinary(bytes);
        return this.convertDown(binary);
    }

    public Binary convertDown(Binary binary) {
        return (Binary)this.ensureConverterDown().convert((Object)binary);
    }

    public BytesValue deserializeToBytesValue(Binary binary) {
        return this.toBytesValue((Binary)this.deserialize(binary));
    }

    public BytesValue toBytesValue(Binary binary) {
        return BytesValue.of((ByteString)this.toByteString(binary));
    }

    public ByteString toByteString(Binary binary) {
        return BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binary));
    }

    public Entry toEntry(Binary binKey, Binary binValue) {
        return Entry.newBuilder().setKey(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binKey))).setValue(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binValue))).build();
    }

    public EntryResult toEntryResult(Map.Entry<Binary, Binary> entry) {
        return EntryResult.newBuilder().setKey(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)entry.getKey()))).setValue(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)entry.getValue()))).build();
    }

    public OptionalValue toOptionalValue(Binary binary) {
        if (binary != null) {
            Binary converted = this.convertUp(binary);
            return OptionalValue.newBuilder().setValue(BinaryHelper.toByteString(converted)).setPresent(true).build();
        }
        return OptionalValue.newBuilder().setPresent(false).build();
    }

    public Converter<Binary, Binary> ensureConverterDown() {
        if (this.m_converterDown == null) {
            Converter converter;
            String sFormat = RequestHolder.getCacheFormat(this.f_service);
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(sFormat)) {
                converter = b -> b;
            } else {
                Converter<Object, Binary> converterValue = this.createConverterDown();
                converter = new DownConverter(this.f_serializer, converterValue);
            }
            this.m_converterDown = new ErrorHandlingConverter<Binary, Binary>(converter);
        }
        return this.m_converterDown;
    }

    protected abstract Converter<Object, Binary> createConverterDown();

    public static String getCacheFormat(Service service) {
        Serializer serializer = service.getSerializer();
        String cacheFormat = serializer.getName();
        if ((cacheFormat == null || cacheFormat.isEmpty()) && serializer instanceof DefaultSerializer) {
            cacheFormat = "java";
        } else if ((cacheFormat == null || cacheFormat.isEmpty()) && serializer instanceof ConfigurablePofContext) {
            cacheFormat = "pof";
        }
        return cacheFormat;
    }

    public Converter<Binary, Binary> ensureConverterUp() {
        if (this.m_converterUp == null) {
            Serializer serializer = this.f_service.getSerializer();
            String cacheFormat = serializer.getName();
            Object converter = this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat) ? b -> b : new UpConverter(serializer, this.f_serializer);
            this.m_converterUp = new ErrorHandlingConverter<Binary, Binary>((Converter<Binary, Binary>)converter);
        }
        return this.m_converterUp;
    }

    protected static class DownConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializer;
        protected final Converter<Object, Binary> f_converter;

        protected DownConverter(Serializer serializer, Converter<Object, Binary> converter) {
            this.f_serializer = serializer;
            this.f_converter = converter;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializer);
            return (Binary)this.f_converter.convert(o);
        }
    }

    protected static class ErrorHandlingConverter<F, T>
    implements Converter<F, T> {
        private final Converter<F, T> f_converter;

        protected ErrorHandlingConverter(Converter<F, T> converter) {
            this.f_converter = converter;
        }

        public T convert(F value) {
            try {
                return (T)this.f_converter.convert(value);
            }
            catch (Throwable t) {
                throw Status.UNKNOWN.withDescription("Caught an exception while serializing or deserializing: " + t.getMessage()).withCause(t).asRuntimeException();
            }
        }
    }

    protected static class UpConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializerFrom;
        protected final Serializer f_serializerTo;

        protected UpConverter(Serializer serializerFrom, Serializer serializerTo) {
            this.f_serializerFrom = serializerFrom;
            this.f_serializerTo = serializerTo;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializerFrom);
            return ExternalizableHelper.toBinary((Object)o, (Serializer)this.f_serializerTo);
        }
    }
}

