/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.internal;

import com.oracle.coherence.grpc.internal.GrpcTracingImplementation;
import com.oracle.coherence.grpc.internal.GrpcTracingImplementationLoader;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.util.Base;
import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import java.util.ServiceLoader;

public final class GrpcTracingInterceptors {
    private static final GrpcTracingImplementation LOADED = GrpcTracingInterceptors.load();

    private GrpcTracingInterceptors() {
    }

    public static ClientInterceptor getClientInterceptor() {
        return LOADED == null || !TracingHelper.isEnabled() ? null : LOADED.createClientInterceptor();
    }

    public static ServerInterceptor getServerInterceptor() {
        return LOADED == null || !TracingHelper.isEnabled() ? null : LOADED.createServerInterceptor();
    }

    private static GrpcTracingImplementation load() {
        ServiceLoader<GrpcTracingImplementationLoader> loader = ServiceLoader.load(GrpcTracingImplementationLoader.class, Base.getContextClassLoader());
        for (GrpcTracingImplementationLoader l : loader) {
            GrpcTracingImplementation impl = l.getGrpcTracingImplementation();
            if (impl == null) continue;
            return impl;
        }
        return null;
    }
}

