/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.grpc.RefreshableSslContext;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Resources;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.ServerCredentials;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettySslContextChannelCredentials;
import io.grpc.netty.NettySslContextServerCredentials;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.SSLException;

public class CredentialsHelper {
    public static final String PROP_TLS_KEY = "coherence.grpc.channels.%s.tls.key";
    public static final String PROP_TLS_KEYPASS = "coherence.grpc.channels.%s.tls.password";
    public static final String PROP_TLS_KEYPASS_URI = "coherence.grpc.channels.%s.tls.password";
    public static final String PROP_TLS_CERT = "coherence.grpc.channels.%s.tls.cert";
    public static final String PROP_TLS_CA = "coherence.grpc.channels.%s.tls.ca";
    public static final String PROP_CREDENTIALS = "coherence.grpc.channels.%s.credentials";

    private CredentialsHelper() {
    }

    @Deprecated(since="22.06.2")
    public static ServerCredentials createServerCredentials() {
        ServerCredentials credentials;
        String sCredentials = Config.getProperty((String)"coherence.grpc.server.credentials", (String)"insecure");
        if ("insecure".equalsIgnoreCase(sCredentials)) {
            Logger.info((String)"Creating gRPC server using insecure credentials");
            credentials = InsecureServerCredentials.create();
        } else if ("tls".equalsIgnoreCase(sCredentials)) {
            try {
                ClientAuth clientAuth;
                String sTlsCert = Config.getProperty((String)"coherence.grpc.server.tls.cert");
                String sTlsKey = Config.getProperty((String)"coherence.grpc.server.tls.key");
                String sTlsCA = Config.getProperty((String)"coherence.grpc.server.tls.ca");
                String sClientAuth = Config.getProperty((String)"coherence.grpc.server.tls.client", (String)ClientAuth.NONE.name()).toUpperCase();
                String sTlsPass = CredentialsHelper.resolveServerPassword();
                if (sTlsKey == null || sTlsCert == null) {
                    String sReason = "Invalid gRPC configuration, " + (sTlsKey == null ? "no key file specified" : "no cert file specfied");
                    throw new ConfigurationException(sReason, "When configuring gRPC TLS both the key and cert files must be configured key=\"" + sTlsKey + "\" cert=\"" + sTlsCert + "\"");
                }
                URL urlCert = Resources.findFileOrResource((String)sTlsCert, null);
                if (urlCert == null) {
                    throw new ConfigurationException("Cannot find configured TLS cert: " + sTlsCert, "Ensure the TLS cert exists");
                }
                URL urlKey = Resources.findFileOrResource((String)sTlsKey, null);
                if (urlKey == null) {
                    throw new ConfigurationException("Cannot find configured TLS key: " + sTlsCert, "Ensure the TLS key exists");
                }
                if (sTlsCA == null || ClientAuth.NONE.name().equals(sClientAuth)) {
                    credentials = TlsServerCredentials.newBuilder().keyManager(urlCert.openStream(), urlKey.openStream(), sTlsPass).build();
                }
                URL urlCA = Resources.findFileOrResource((String)sTlsCA, null);
                if (urlCA == null) {
                    throw new ConfigurationException("Cannot find configured TLS CA: " + sTlsCA, "Ensure the TLS CA exists");
                }
                try {
                    clientAuth = ClientAuth.valueOf((String)sClientAuth);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Cannot find configured TLS client auth value: " + sClientAuth, "Valid values are one of " + Arrays.toString(ClientAuth.values()));
                }
                SslContextBuilder builder = SslContextBuilder.forServer((InputStream)urlCert.openStream(), (InputStream)urlKey.openStream(), (String)sTlsPass).trustManager(urlCA.openStream()).clientAuth(clientAuth);
                Logger.info((String)("Creating gRPC server using TLS credentials. key=" + urlKey + " cert=" + urlCert + " ca=" + urlCA + " clientAuth=" + sClientAuth));
                credentials = NettySslContextServerCredentials.create((SslContext)GrpcSslContexts.configure((SslContextBuilder)builder).build());
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        } else {
            throw new ConfigurationException("Invalid gRPC credentials type \"" + sCredentials + "\"", "Valid values are \"insecure\" or \"tls\"");
        }
        return credentials;
    }

    public static ServerCredentials createServerCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            if (depsFactory == null) {
                return CredentialsHelper.createServerCredentials();
            }
            String sSocketId = socketBuilder.getId();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId);
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureServerCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, true);
                return NettySslContextServerCredentials.create((SslContext)sslContext);
            }
        }
        return CredentialsHelper.createServerCredentials();
    }

    @Deprecated(since="22.06.2")
    public static ChannelCredentials createChannelCredentials(String sChannelName) {
        ChannelCredentials credentials;
        String sType = CredentialsHelper.getProperty(PROP_CREDENTIALS, sChannelName, "plaintext");
        if ("plaintext".equals(sType)) {
            credentials = InsecureChannelCredentials.create();
        } else if ("insecure".equals(sType)) {
            try {
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                credentials = NettySslContextChannelCredentials.create((SslContext)sslContext);
            }
            catch (SSLException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        } else if ("tls".equals(sType)) {
            try {
                SslContextBuilder builder = SslContextBuilder.forClient();
                String sTlsCert = CredentialsHelper.getProperty(PROP_TLS_CERT, sChannelName);
                String sTlsKey = CredentialsHelper.getProperty(PROP_TLS_KEY, sChannelName);
                String sTlsCA = CredentialsHelper.getProperty(PROP_TLS_CA, sChannelName);
                String sTlsPass = CredentialsHelper.resolveChannelPassword(sChannelName);
                URL urlCert = null;
                URL urlKey = null;
                URL urlCA = null;
                if (sTlsKey != null && sTlsCert == null || sTlsKey == null && sTlsCert != null) {
                    String sReason = "Invalid gRPC configuration for channel \"" + sChannelName + "\", " + (sTlsKey == null ? "no key file specified" : "no cert file specified");
                    throw new ConfigurationException(sReason, "When configuring gRPC TLS both the key and cert files must be configured key=\"" + sTlsKey + "\" cert=\"" + sTlsCert + "\"");
                }
                if (sTlsKey != null && sTlsCert != null) {
                    urlCert = Resources.findFileOrResource((String)sTlsCert, null);
                    if (urlCert == null) {
                        throw new ConfigurationException("Cannot find configured TLS cert for channel \"" + sChannelName + "\": " + sTlsCert, "Ensure the TLS cert exists");
                    }
                    urlKey = Resources.findFileOrResource((String)sTlsKey, null);
                    if (urlKey == null) {
                        throw new ConfigurationException("Cannot find configured TLS key for channel \"" + sChannelName + "\": " + sTlsCert, "Ensure the TLS key exists");
                    }
                    builder.keyManager(urlCert.openStream(), urlKey.openStream(), sTlsPass);
                }
                if (sTlsCA != null) {
                    urlCA = Resources.findFileOrResource((String)sTlsCA, null);
                    if (urlCA == null) {
                        throw new ConfigurationException("Cannot find configured TLS CA: for channel \"" + sChannelName + "\": " + sTlsCA, "Ensure the TLS CA exists");
                    }
                    builder.trustManager(urlCA.openStream());
                }
                builder = GrpcSslContexts.configure((SslContextBuilder)builder);
                Logger.info((String)("Creating gRPC Channel \"" + sChannelName + "\" using TLS credentials. key=" + urlKey + " cert=" + urlCert + " ca=" + urlCA));
                credentials = NettySslContextChannelCredentials.create((SslContext)builder.build());
            }
            catch (IOException e) {
                throw Exceptions.ensureRuntimeException((Throwable)e);
            }
        } else {
            throw new ConfigurationException("Invalid credentials type for channel " + sChannelName, "Valid values are insecure tls plaintext");
        }
        return credentials;
    }

    public static ChannelCredentials createChannelCredentials(String sChannelName, SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            String sSocketId;
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId = socketBuilder.getId());
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureChannelCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, false);
                return NettySslContextChannelCredentials.create((SslContext)sslContext);
            }
        }
        return CredentialsHelper.createChannelCredentials(sChannelName);
    }

    private static String resolveChannelPassword(String sChannel) throws IOException {
        String sPasswordProperty = String.format("coherence.grpc.channels.%s.tls.password", sChannel);
        String sURIProperty = String.format("coherence.grpc.channels.%s.tls.password", sChannel);
        return CredentialsHelper.resolvePassword(sPasswordProperty, sURIProperty);
    }

    private static String resolveServerPassword() throws IOException {
        return CredentialsHelper.resolvePassword("coherence.grpc.server.tls.password", "coherence.grpc.server.tls.password.uri");
    }

    private static String resolvePassword(String sPasswordProperty, String sURIProperty) throws IOException {
        String sTlsPass = Config.getProperty((String)sPasswordProperty);
        if (sTlsPass != null) {
            return sTlsPass;
        }
        String sURI = Config.getProperty((String)"coherence.grpc.server.tls.password.uri");
        if (sURI != null) {
            URL url = Resources.findFileOrResource((String)sURI, null);
            if (url == null) {
                throw new FileNotFoundException("Cannot locate password file: " + sURI);
            }
            try (InputStream in = url.openStream();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String string = reader.readLine();
                return string;
            }
        }
        return null;
    }

    private static String getProperty(String sProperty, String sChannelName) {
        return Config.getProperty((String)String.format(sProperty, sChannelName));
    }

    private static String getProperty(String sProperty, String sChannelName, String sDefault) {
        return Config.getProperty((String)String.format(sProperty, sChannelName), (String)sDefault);
    }
}

