/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;

public final class ErrorsHelper {
    public static final Metadata.Key<String> KEY_ERROR = Metadata.Key.of((String)"coherence-error-stack", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Base64.Encoder s_encoder = Base64.getEncoder();
    private static final Base64.Decoder s_decoder = Base64.getDecoder();
    private static final int MAX_STACK_LENGTH = 1000;

    private ErrorsHelper() {
    }

    public static StatusRuntimeException ensureStatusRuntimeException(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            return ErrorsHelper.enrich((StatusRuntimeException)t);
        }
        if (t instanceof StatusException) {
            return ((StatusException)t).getStatus().asRuntimeException(ErrorsHelper.getErrorMetadata(t));
        }
        return Status.INTERNAL.withCause(t).withDescription(t.getMessage()).asRuntimeException(ErrorsHelper.getErrorMetadata(t));
    }

    public static StatusRuntimeException ensureStatusRuntimeException(Throwable t, String description) {
        Status status = t instanceof StatusRuntimeException ? ((StatusRuntimeException)t).getStatus().getCode().toStatus() : (t instanceof StatusException ? ((StatusException)t).getStatus().getCode().toStatus() : Status.INTERNAL);
        return status.withCause(t).withDescription(description).asRuntimeException(ErrorsHelper.getErrorMetadata(t));
    }

    public static Optional<String> getRemoteStack(StatusRuntimeException e) {
        Metadata trailers = e.getTrailers();
        String s = trailers == null ? null : (String)trailers.get(KEY_ERROR);
        return s == null ? Optional.empty() : Optional.of(new String(s_decoder.decode(s)));
    }

    public static Optional<String> getRemoteStack(StatusException e) {
        Metadata trailers = e.getTrailers();
        String s = trailers == null ? null : (String)trailers.get(KEY_ERROR);
        return s == null ? Optional.empty() : Optional.of(new String(s_decoder.decode(s)));
    }

    private static StatusRuntimeException enrich(StatusRuntimeException e) {
        Metadata metadata = e.getTrailers();
        if (metadata == null) {
            metadata = new Metadata();
            e = e.getStatus().asRuntimeException(metadata);
        }
        metadata.put(KEY_ERROR, (Object)ErrorsHelper.getStackTrace((Throwable)e));
        return e;
    }

    private static Metadata getErrorMetadata(Throwable t) {
        Metadata metadata = new Metadata();
        metadata.put(KEY_ERROR, (Object)ErrorsHelper.getStackTrace(t));
        return metadata;
    }

    private static String getStackTrace(Throwable t) {
        byte[] abEncoded;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8));
        byte[] abStack = out.toByteArray();
        if (abStack.length > 1000) {
            byte[] abTruncated = new byte[1000];
            System.arraycopy(abStack, 0, abTruncated, 0, 1000);
            abEncoded = s_encoder.encode(abTruncated);
        } else {
            abEncoded = s_encoder.encode(abStack);
        }
        return new String(abEncoded);
    }
}

