/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.OptionalValue;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class CacheRequestHolder<Req, Res> {
    protected final Req f_request;
    protected final AsyncNamedCache<Binary, Binary> f_asyncNamedCache;
    protected final String f_sFormat;
    protected final Executor f_executor;
    protected final Supplier<NamedCache<?, ?>> f_cacheSupplier;
    protected Converter<Binary, Binary> m_converterDown;
    protected Converter<Binary, Binary> m_converterKeyDown;
    protected Converter<Binary, Binary> m_converterUp;
    protected final Serializer f_serializer;
    protected Object m_result;

    public CacheRequestHolder(Req request, AsyncNamedCache<Binary, Binary> cache, Supplier<NamedCache<?, ?>> cacheSupplier, String sFormat, Serializer serializer, Executor executor) {
        this.f_request = request;
        this.f_asyncNamedCache = cache;
        this.f_cacheSupplier = cacheSupplier;
        this.f_sFormat = sFormat;
        this.f_serializer = serializer;
        this.f_executor = executor;
    }

    public Req getRequest() {
        return this.f_request;
    }

    public Res getResult() {
        return (Res)this.m_result;
    }

    public <T> T getDeserializedResult() {
        return (T)ExternalizableHelper.fromBinary((Binary)((Binary)this.m_result), (Serializer)this.getCacheSerializer());
    }

    public <T> T fromCacheBinary(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getCacheSerializer());
    }

    public <T> T deserialize(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getCacheSerializer());
    }

    public <T> T deserializeRequest(ByteString bytes) {
        return (T)ExternalizableHelper.fromBinary((Binary)BinaryHelper.toBinary(bytes), (Serializer)this.f_serializer);
    }

    public <T> CacheRequestHolder<Req, T> setResult(T t) {
        this.m_result = t;
        return this;
    }

    public <T> CompletionStage<CacheRequestHolder<Req, T>> runAsync(CompletionStage<T> stage) {
        return stage.handleAsync((r, err) -> {
            if (err == null) {
                return this.setResult(r);
            }
            throw Status.INTERNAL.withCause(err).withDescription(err.getMessage()).asRuntimeException();
        }, this.f_executor);
    }

    public String getCacheName() {
        return this.f_asyncNamedCache.getNamedCache().getCacheName();
    }

    public AsyncNamedCache<Binary, Binary> getAsyncCache() {
        return this.f_asyncNamedCache;
    }

    public NamedCache<Binary, Binary> getCache() {
        return this.f_asyncNamedCache.getNamedCache();
    }

    public <K, V> NamedCache<K, V> getNonPassThruCache() {
        return this.f_cacheSupplier.get();
    }

    public Serializer getSerializer() {
        return this.f_serializer;
    }

    public Serializer getCacheSerializer() {
        return this.f_asyncNamedCache.getNamedCache().getCacheService().getSerializer();
    }

    public Binary convertUp(Binary binary) {
        if (binary == null) {
            return null;
        }
        return (Binary)this.ensureConverterUp().convert((Object)binary);
    }

    public Binary convertKeyDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinaryKey(bytes);
        return this.convertKeyDown(binary);
    }

    public Binary convertKeyDown(Binary binary) {
        return (Binary)this.ensureConverterKeyDown().convert((Object)binary);
    }

    public Binary convertDown(Supplier<ByteString> supplier) {
        return this.convertDown(supplier.get());
    }

    public Binary convertDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinary(bytes);
        return this.convertDown(binary);
    }

    public Binary convertDown(Binary binary) {
        return (Binary)this.ensureConverterDown().convert((Object)binary);
    }

    public BytesValue deserializeToBytesValue(Binary binary) {
        return this.toBytesValue((Binary)this.deserialize(binary));
    }

    public BytesValue toBytesValue(Binary binary) {
        return BytesValue.of((ByteString)this.toByteString(binary));
    }

    public ByteString toByteString(Binary binary) {
        return BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binary));
    }

    public Entry toEntry(Binary binKey, Binary binValue) {
        return Entry.newBuilder().setKey(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binKey))).setValue(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)binValue))).build();
    }

    public EntryResult toEntryResult(Map.Entry<Binary, Binary> entry) {
        return EntryResult.newBuilder().setKey(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)entry.getKey()))).setValue(BinaryHelper.toByteString((Binary)this.ensureConverterUp().apply((Object)entry.getValue()))).build();
    }

    public OptionalValue toOptionalValue(Binary binary) {
        if (binary != null) {
            Binary converted = this.convertUp(binary);
            return OptionalValue.newBuilder().setValue(BinaryHelper.toByteString(converted)).setPresent(true).build();
        }
        return OptionalValue.newBuilder().setPresent(false).build();
    }

    public Converter<Binary, Binary> ensureConverterKeyDown() {
        if (this.m_converterKeyDown == null) {
            Converter converter;
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            String cacheFormat = CacheRequestHolder.getCacheFormat(cacheService);
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat)) {
                converter = BinaryHelper::toBinaryKey;
            } else {
                BackingMapManagerContext context = cacheService.getBackingMapManager().getContext();
                Converter converterKey = context.getKeyToInternalConverter();
                converter = new DownConverter(this.f_serializer, (Converter<Object, Binary>)converterKey);
            }
            this.m_converterKeyDown = new ErrorHandlingConverter<Binary, Binary>(converter);
        }
        return this.m_converterKeyDown;
    }

    public Converter<Binary, Binary> ensureConverterDown() {
        if (this.m_converterDown == null) {
            Converter converter;
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            String cacheFormat = CacheRequestHolder.getCacheFormat(cacheService);
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat)) {
                converter = b -> b;
            } else {
                BackingMapManagerContext context = cacheService.getBackingMapManager().getContext();
                Converter converterValue = context.getValueToInternalConverter();
                converter = new DownConverter(this.f_serializer, (Converter<Object, Binary>)converterValue);
            }
            this.m_converterDown = new ErrorHandlingConverter<Binary, Binary>(converter);
        }
        return this.m_converterDown;
    }

    public static String getCacheFormat(CacheService cacheService) {
        Serializer serializerCache = cacheService.getSerializer();
        String cacheFormat = serializerCache.getName();
        if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof DefaultSerializer) {
            cacheFormat = "java";
        } else if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof ConfigurablePofContext) {
            cacheFormat = "pof";
        }
        return cacheFormat;
    }

    public Converter<Binary, Binary> ensureConverterUp() {
        if (this.m_converterUp == null) {
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            Serializer serializerCache = cacheService.getSerializer();
            String cacheFormat = serializerCache.getName();
            Object converter = this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat) ? b -> b : new UpConverter(serializerCache, this.f_serializer);
            this.m_converterUp = new ErrorHandlingConverter<Binary, Binary>((Converter<Binary, Binary>)converter);
        }
        return this.m_converterUp;
    }

    private static class ErrorHandlingConverter<F, T>
    implements Converter<F, T> {
        private final Converter<F, T> f_converter;

        private ErrorHandlingConverter(Converter<F, T> converter) {
            this.f_converter = converter;
        }

        public T convert(F value) {
            try {
                return (T)this.f_converter.convert(value);
            }
            catch (Throwable t) {
                throw Status.UNKNOWN.withDescription("Caught an exception while serializing or deserializing").withCause(t).asRuntimeException();
            }
        }
    }

    protected static class DownConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializer;
        protected final Converter<Object, Binary> f_converter;

        protected DownConverter(Serializer serializer, Converter<Object, Binary> converter) {
            this.f_serializer = serializer;
            this.f_converter = converter;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializer);
            return (Binary)this.f_converter.convert(o);
        }
    }

    protected static class UpConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializerFrom;
        protected final Serializer f_serializerTo;

        protected UpConverter(Serializer serializerFrom, Serializer serializerTo) {
            this.f_serializerFrom = serializerFrom;
            this.f_serializerTo = serializerTo;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializerFrom);
            return ExternalizableHelper.toBinary((Object)o, (Serializer)this.f_serializerTo);
        }
    }
}

