/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Controllable;
import java.util.concurrent.Executor;

public class SimpleDaemonPoolExecutor
implements Executor,
Controllable {
    protected final DaemonPool f_pool;

    public SimpleDaemonPoolExecutor(String sName) {
        this(sName, -1, -1, -1);
    }

    public SimpleDaemonPoolExecutor(String sName, int cThreads, int cThreadsMin, int cThreadsMax) {
        DefaultDaemonPoolDependencies dependencies = new DefaultDaemonPoolDependencies();
        dependencies.setThreadCount(1);
        if (sName != null && !sName.isEmpty()) {
            dependencies.setName(sName);
        }
        if (cThreads >= 0) {
            dependencies.setThreadCount(cThreads);
        }
        if (cThreadsMin >= 0) {
            dependencies.setThreadCountMin(cThreadsMin);
        }
        if (cThreadsMax >= 0) {
            dependencies.setThreadCountMax(cThreadsMax);
        }
        this.f_pool = Daemons.newDaemonPool((DaemonPoolDependencies)dependencies);
    }

    public SimpleDaemonPoolExecutor(DaemonPool pool) {
        this.f_pool = pool;
    }

    @Override
    public void execute(Runnable command) {
        this.f_pool.add(command);
    }

    public void configure(XmlElement xmlElement) {
        this.f_pool.configure(xmlElement);
    }

    public void start() {
        this.f_pool.start();
    }

    public boolean isRunning() {
        return this.f_pool.isRunning();
    }

    public boolean isStuck() {
        return this.f_pool.isStuck();
    }

    public void shutdown() {
        this.f_pool.shutdown();
    }

    public void stop() {
        this.f_pool.stop();
    }

    public ClassLoader getContextClassLoader() {
        return this.f_pool.getContextClassLoader();
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.f_pool.setContextClassLoader(loader);
    }

    public DaemonPool getPool() {
        return this.f_pool;
    }
}

