/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.UnsafeByteOperations;
import com.oracle.coherence.grpc.Entry;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ByteSequence;
import com.tangosol.util.ExternalizableHelper;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class BinaryHelper {
    public static final Empty EMPTY = Empty.getDefaultInstance();
    public static final ByteString EMPTY_BYTE_STRING = ByteString.EMPTY;

    private BinaryHelper() {
    }

    public static Binary toBinaryKey(BytesValue bytes) {
        return BinaryHelper.toBinaryKey(bytes.getValue());
    }

    public static Binary toBinaryKey(ByteString bytes) {
        Binary bin = BinaryHelper.toBinary(bytes);
        return BinaryHelper.toBinaryKey(bin);
    }

    public static Binary toBinaryKey(Binary binary) {
        if (!ExternalizableHelper.isIntDecorated((ByteSequence)binary)) {
            return ExternalizableHelper.decorateBinary((ReadBuffer)binary, (int)binary.hashCode()).toBinary();
        }
        return binary;
    }

    public static Binary toBinary(BytesValue bytes) {
        return BinaryHelper.toBinary(bytes.getValue());
    }

    public static Binary toBinary(ByteString bytes) {
        return BinaryHelper.toReadBuffer(bytes).toBinary();
    }

    public static ReadBuffer toReadBuffer(ByteString bytes) {
        ReadBuffer[] readBuffers = (ReadBuffer[])bytes.asReadOnlyByteBufferList().stream().map(ByteBufferReadBuffer::new).toArray(ReadBuffer[]::new);
        return new MultiBufferReadBuffer(readBuffers);
    }

    public static <T> T fromBinary(Binary binary, Serializer serializer) {
        if (binary == null) {
            return null;
        }
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)serializer);
    }

    public static BytesValue toBytesValue(Binary binary) {
        BytesValue.Builder builder = BytesValue.newBuilder();
        if (binary != null) {
            builder.setValue(BinaryHelper.toByteString(binary));
        }
        return builder.build();
    }

    public static ByteString toByteString(Binary binary) {
        if (binary != null) {
            Binary undecorated = ExternalizableHelper.getUndecorated((ReadBuffer)binary).toBinary();
            return UnsafeByteOperations.unsafeWrap((ByteBuffer)undecorated.toByteBuffer());
        }
        return ByteString.EMPTY;
    }

    public static <T> T fromBytesValue(BytesValue bytes, Serializer serializer) {
        if (bytes == null) {
            return null;
        }
        return BinaryHelper.fromByteString(bytes.getValue(), serializer);
    }

    public static <T> T fromByteString(ByteString bytes, Serializer serializer) {
        if (bytes != null && !bytes.isEmpty()) {
            return (T)ExternalizableHelper.fromBinary((Binary)BinaryHelper.toBinary(bytes), (Serializer)serializer);
        }
        return null;
    }

    public static BytesValue toBytesValue(Object value, Serializer serializer) {
        return BytesValue.of((ByteString)BinaryHelper.toByteString(value, serializer));
    }

    public static ByteString toByteString(Object value, Serializer serializer) {
        Binary binary = ExternalizableHelper.toBinary((Object)value, (Serializer)serializer);
        return BinaryHelper.toByteString(binary);
    }

    public static List<Entry> toEntryList(Map<?, ?> map, Serializer serializer) {
        return map.entrySet().stream().map(e -> BinaryHelper.toEntry(e, serializer)).collect(Collectors.toList());
    }

    public static Entry toEntry(Map.Entry<?, ?> entry, Serializer serializer) {
        Binary binary = ExternalizableHelper.toBinary(entry.getKey(), (Serializer)serializer);
        Binary key = BinaryHelper.toBinaryKey(binary);
        return BinaryHelper.toEntry(BinaryHelper.toByteString(key), BinaryHelper.toByteString(entry.getValue(), serializer));
    }

    public static Entry toEntry(ByteString key, ByteString value) {
        return Entry.newBuilder().setKey(key).setValue(value).build();
    }
}

