/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.google.protobuf.ByteString;
import com.oracle.coherence.grpc.AddIndexRequest;
import com.oracle.coherence.grpc.AggregateRequest;
import com.oracle.coherence.grpc.ClearRequest;
import com.oracle.coherence.grpc.ContainsEntryRequest;
import com.oracle.coherence.grpc.ContainsKeyRequest;
import com.oracle.coherence.grpc.ContainsValueRequest;
import com.oracle.coherence.grpc.DestroyRequest;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntrySetRequest;
import com.oracle.coherence.grpc.GetAllRequest;
import com.oracle.coherence.grpc.GetRequest;
import com.oracle.coherence.grpc.InvokeAllRequest;
import com.oracle.coherence.grpc.InvokeRequest;
import com.oracle.coherence.grpc.IsEmptyRequest;
import com.oracle.coherence.grpc.KeySetRequest;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.PageRequest;
import com.oracle.coherence.grpc.PutAllRequest;
import com.oracle.coherence.grpc.PutIfAbsentRequest;
import com.oracle.coherence.grpc.PutRequest;
import com.oracle.coherence.grpc.RemoveIndexRequest;
import com.oracle.coherence.grpc.RemoveMappingRequest;
import com.oracle.coherence.grpc.RemoveRequest;
import com.oracle.coherence.grpc.ReplaceMappingRequest;
import com.oracle.coherence.grpc.ReplaceRequest;
import com.oracle.coherence.grpc.SizeRequest;
import com.oracle.coherence.grpc.TruncateRequest;
import com.oracle.coherence.grpc.ValuesRequest;
import java.util.UUID;

public final class Requests {
    public static final String DEFAULT_SCOPE = "";
    public static final String DEFAULT_CHANNEL_NAME = "default";
    public static final String DEFAULT_SESSION_NAME = "default";
    public static final String PROP_PORT = "coherence.grpc.server.port";
    public static final String PROP_IN_PROCESS_NAME = "coherence.grpc.inprocess.name";
    public static final int DEFAULT_PORT = 1408;

    private Requests() {
    }

    public static AddIndexRequest addIndex(String scope, String cacheName, String format, ByteString extractor) {
        return Requests.addIndex(scope, cacheName, format, extractor, false, null);
    }

    public static AddIndexRequest addIndex(String scope, String cacheName, String format, ByteString extractor, boolean sorted) {
        return Requests.addIndex(scope, cacheName, format, extractor, sorted, null);
    }

    public static AddIndexRequest addIndex(String scope, String cacheName, String format, ByteString extractor, boolean sorted, ByteString comparator) {
        Requests.validateRequest(cacheName, format);
        if (extractor == null || extractor.isEmpty()) {
            throw new IllegalArgumentException("the serialized extractor cannot be null or empty");
        }
        return AddIndexRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setExtractor(extractor).setSorted(sorted).setComparator(Requests.ensureNotNull(comparator)).build();
    }

    public static MapListenerRequest initListenerChannel(String scope, String cacheName, String format) {
        Requests.validateRequest(cacheName);
        return MapListenerRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setUid(UUID.randomUUID().toString()).setSubscribe(true).setFormat(format).setType(MapListenerRequest.RequestType.INIT).build();
    }

    public static MapListenerRequest addKeyMapListener(String scope, String cacheName, String format, ByteString key, boolean lite, boolean priming, ByteString mapTrigger) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        return MapListenerRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setUid(UUID.randomUUID().toString()).setSubscribe(true).setType(MapListenerRequest.RequestType.KEY).setKey(key).setLite(lite).setPriming(priming).setTrigger(Requests.ensureNotNull(mapTrigger)).build();
    }

    public static MapListenerRequest addFilterMapListener(String scope, String cacheName, String format, ByteString filter, long filterId, boolean lite, boolean priming, ByteString mapTrigger) {
        Requests.validateRequest(cacheName, format);
        return MapListenerRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setUid(UUID.randomUUID().toString()).setSubscribe(true).setType(MapListenerRequest.RequestType.FILTER).setFilter(Requests.ensureNotNull(filter)).setFilterId(filterId).setLite(lite).setPriming(priming).setTrigger(Requests.ensureNotNull(mapTrigger)).build();
    }

    public static AggregateRequest aggregate(String scope, String cacheName, String format, ByteString filter, ByteString aggregator) {
        Requests.validateRequest(cacheName, format);
        if (aggregator == null || aggregator.isEmpty()) {
            throw new IllegalArgumentException("the serialized aggregator cannot be null or empty");
        }
        return AggregateRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(Requests.ensureNotNull(filter)).setAggregator(aggregator).build();
    }

    public static AggregateRequest aggregate(String scope, String cacheName, String format, Iterable<ByteString> keys, ByteString aggregator) {
        Requests.validateRequest(cacheName, format);
        if (keys == null) {
            throw new IllegalArgumentException("the keys parameter cannot be null or empty");
        }
        if (aggregator == null || aggregator.isEmpty()) {
            throw new IllegalArgumentException("the serialized aggregator cannot be null or empty");
        }
        return AggregateRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).addAllKeys(keys).setAggregator(aggregator).build();
    }

    public static ClearRequest clear(String scope, String cacheName) {
        Requests.validateRequest(cacheName);
        return ClearRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).build();
    }

    public static ContainsEntryRequest containsEntry(String scope, String cacheName, String format, ByteString key, ByteString value) {
        return ContainsEntryRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setValue(value).build();
    }

    public static ContainsKeyRequest containsKey(String scope, String cacheName, String format, ByteString key) {
        Requests.validateRequest(cacheName, format);
        return ContainsKeyRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).build();
    }

    public static ContainsValueRequest containsValue(String scope, String cacheName, String format, ByteString value) {
        Requests.validateRequest(cacheName, format);
        return ContainsValueRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setValue(value).build();
    }

    public static DestroyRequest destroy(String scope, String cacheName) {
        Requests.validateRequest(cacheName);
        return DestroyRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).build();
    }

    public static EntrySetRequest entrySet(String scope, String cacheName, String format, ByteString filter) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        return EntrySetRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).build();
    }

    public static EntrySetRequest entrySet(String scope, String cacheName, String format, ByteString filter, ByteString comparator) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        if (comparator == null || comparator.isEmpty()) {
            throw new IllegalArgumentException("the serialized comparator cannot be null or empty");
        }
        return EntrySetRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).setComparator(comparator).build();
    }

    public static GetRequest get(String scope, String cacheName, String format, ByteString key) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        return GetRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).build();
    }

    public static GetAllRequest getAll(String scope, String cacheName, String format, Iterable<ByteString> keys) {
        Requests.validateRequest(cacheName, format);
        if (keys == null) {
            throw new IllegalArgumentException("the keys iterable cannot be null or empty");
        }
        return GetAllRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).addAllKey(keys).build();
    }

    public static InvokeRequest invoke(String scope, String cacheName, String format, ByteString key, ByteString processor) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (processor == null || processor.isEmpty()) {
            throw new IllegalArgumentException("the serialized processor cannot be null or empty");
        }
        return InvokeRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setProcessor(processor).build();
    }

    public static InvokeAllRequest invokeAll(String scope, String cacheName, String format, Iterable<ByteString> keys, ByteString processor) {
        Requests.validateRequest(cacheName, format);
        if (keys == null) {
            throw new IllegalArgumentException("the keys parameter cannot be null or empty");
        }
        if (processor == null || processor.isEmpty()) {
            throw new IllegalArgumentException("the serialized processor cannot be null or empty");
        }
        return InvokeAllRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).addAllKeys(keys).setProcessor(processor).build();
    }

    public static InvokeAllRequest invokeAll(String scope, String cacheName, String format, ByteString filter, ByteString processor) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        if (processor == null || processor.isEmpty()) {
            throw new IllegalArgumentException("the serialized processor cannot be null or empty");
        }
        return InvokeAllRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).setProcessor(processor).build();
    }

    public static IsEmptyRequest isEmpty(String scope, String cacheName) {
        Requests.validateRequest(cacheName);
        return IsEmptyRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).build();
    }

    public static KeySetRequest keySet(String scope, String cacheName, String format, ByteString filter) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        return KeySetRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).build();
    }

    public static PageRequest page(String scope, String cacheName, String format, ByteString cookie) {
        Requests.validateRequest(cacheName, format);
        PageRequest.Builder builder = PageRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format);
        if (cookie != null && !cookie.isEmpty()) {
            builder.setCookie(cookie);
        }
        return builder.build();
    }

    public static PutRequest put(String scope, String cacheName, String format, ByteString key, ByteString value) {
        return Requests.put(scope, cacheName, format, key, value, 0L);
    }

    public static PutRequest put(String scope, String cacheName, String format, ByteString key, ByteString value, long ttl) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("the serialized value cannot be null");
        }
        return PutRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setValue(value).setTtl(ttl).build();
    }

    public static PutAllRequest putAll(String scope, String cacheName, String format, Iterable<Entry> entries) {
        Requests.validateRequest(cacheName, format);
        if (entries == null) {
            throw new IllegalArgumentException("the entries parameter cannot be null");
        }
        return PutAllRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).addAllEntry(entries).build();
    }

    public static PutIfAbsentRequest putIfAbsent(String scope, String cacheName, String format, ByteString key, ByteString value) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("the serialized value cannot be null");
        }
        return PutIfAbsentRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setValue(value).build();
    }

    public static RemoveRequest remove(String scope, String cacheName, String format, ByteString key) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        return RemoveRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).build();
    }

    public static RemoveMappingRequest remove(String scope, String cacheName, String format, ByteString key, ByteString value) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("the serialized value cannot be null");
        }
        return RemoveMappingRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setValue(value).build();
    }

    public static RemoveIndexRequest removeIndex(String scope, String cacheName, String format, ByteString extractor) {
        Requests.validateRequest(cacheName, format);
        if (extractor == null || extractor.isEmpty()) {
            throw new IllegalArgumentException("the serialized extractor cannot be null or empty");
        }
        return RemoveIndexRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setExtractor(extractor).build();
    }

    public static MapListenerRequest removeKeyMapListener(String scope, String cacheName, String format, ByteString key, boolean priming, ByteString mapTrigger) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        return MapListenerRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setSubscribe(false).setType(MapListenerRequest.RequestType.KEY).setKey(key).setPriming(priming).setTrigger(Requests.ensureNotNull(mapTrigger)).build();
    }

    public static MapListenerRequest removeFilterMapListener(String scope, String cacheName, String format, ByteString filter, long filterId, boolean lite, boolean priming, ByteString mapTrigger) {
        Requests.validateRequest(cacheName, format);
        return MapListenerRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setSubscribe(false).setType(MapListenerRequest.RequestType.FILTER).setFilter(Requests.ensureNotNull(filter)).setFilterId(filterId).setLite(lite).setPriming(priming).setTrigger(Requests.ensureNotNull(mapTrigger)).build();
    }

    public static ReplaceRequest replace(String scope, String cacheName, String format, ByteString key, ByteString value) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("the serialized value cannot be null");
        }
        return ReplaceRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setValue(value).build();
    }

    public static ReplaceMappingRequest replace(String scope, String cacheName, String format, ByteString key, ByteString previousValue, ByteString newValue) {
        Requests.validateRequest(cacheName, format);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("the serialized key cannot be null or empty");
        }
        if (previousValue == null) {
            throw new IllegalArgumentException("the serialized previous value cannot be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("the serialized new value cannot be null");
        }
        return ReplaceMappingRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setKey(key).setPreviousValue(previousValue).setNewValue(newValue).build();
    }

    public static SizeRequest size(String scope, String cacheName) {
        Requests.validateRequest(cacheName);
        return SizeRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).build();
    }

    public static TruncateRequest truncate(String scope, String cacheName) {
        Requests.validateRequest(cacheName);
        return TruncateRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).build();
    }

    public static ValuesRequest values(String scope, String cacheName, String format, ByteString filter) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        return ValuesRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).build();
    }

    public static ValuesRequest values(String scope, String cacheName, String format, ByteString filter, ByteString comparator) {
        Requests.validateRequest(cacheName, format);
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("the serialized filter cannot be null or empty");
        }
        return ValuesRequest.newBuilder().setScope(Requests.ensureScope(scope)).setCache(cacheName).setFormat(format).setFilter(filter).setComparator(Requests.ensureNotNull(comparator)).build();
    }

    private static void validateRequest(String cacheName) {
        Requests.validateRequest(cacheName, DEFAULT_SCOPE);
    }

    private static void validateRequest(String cacheName, String format) {
        if (cacheName == null) {
            throw new IllegalArgumentException("the cache name cannot be null");
        }
        if (format == null) {
            throw new IllegalArgumentException("the serialization format cannot be null");
        }
    }

    private static ByteString ensureNotNull(ByteString b) {
        return b == null ? ByteString.EMPTY : b;
    }

    private static String ensureScope(String scope) {
        return scope != null ? scope : DEFAULT_SCOPE;
    }
}

