/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.tangosol.application.Context;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.net.management.Registry;
import java.util.Optional;
import java.util.concurrent.Executor;

public interface GrpcServiceDependencies {
    public Optional<NamedSerializerFactory> getNamedSerializerFactory();

    public Optional<Executor> getExecutor();

    public Optional<DaemonPool> getDaemonPool();

    public Optional<Long> getTransferThreshold();

    public Optional<Registry> getRegistry();

    public Optional<Context> getContext();

    public static class DefaultDependencies
    implements GrpcServiceDependencies {
        private NamedSerializerFactory m_serializerFactory;
        private Executor m_executor;
        private DaemonPool m_pool;
        private Long m_transferThreshold;
        private Registry m_registry;
        private Context m_context;

        public DefaultDependencies() {
        }

        public DefaultDependencies(GrpcServiceDependencies deps) {
            if (deps != null) {
                deps.getExecutor().ifPresent(this::setExecutor);
                deps.getRegistry().ifPresent(this::setRegistry);
                deps.getNamedSerializerFactory().ifPresent(this::setSerializerFactory);
                deps.getTransferThreshold().ifPresent(this::setTransferThreshold);
                deps.getContext().ifPresent(this::setContext);
                deps.getDaemonPool().ifPresent(this::setDaemonPool);
            }
        }

        @Override
        public Optional<NamedSerializerFactory> getNamedSerializerFactory() {
            return Optional.ofNullable(this.m_serializerFactory);
        }

        public void setSerializerFactory(NamedSerializerFactory serializerFactory) {
            this.m_serializerFactory = serializerFactory;
        }

        @Override
        public Optional<Executor> getExecutor() {
            return Optional.ofNullable(this.m_executor);
        }

        public void setExecutor(Executor executor) {
            this.m_executor = executor;
        }

        @Override
        public Optional<DaemonPool> getDaemonPool() {
            return Optional.ofNullable(this.m_pool);
        }

        public void setDaemonPool(DaemonPool pool) {
            this.m_pool = pool;
        }

        @Override
        public Optional<Long> getTransferThreshold() {
            return Optional.ofNullable(this.m_transferThreshold);
        }

        public void setTransferThreshold(Long transferThreshold) {
            this.m_transferThreshold = transferThreshold;
        }

        @Override
        public Optional<Registry> getRegistry() {
            return Optional.ofNullable(this.m_registry);
        }

        public void setRegistry(Registry registry) {
            this.m_registry = registry;
        }

        @Override
        public Optional<Context> getContext() {
            return Optional.ofNullable(this.m_context);
        }

        public void setContext(Context context) {
            this.m_context = context;
        }
    }
}

