/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.google.protobuf.Int32Value;
import com.oracle.coherence.grpc.AddIndexRequest;
import com.oracle.coherence.grpc.AggregateRequest;
import com.oracle.coherence.grpc.ClearRequest;
import com.oracle.coherence.grpc.ContainsEntryRequest;
import com.oracle.coherence.grpc.ContainsKeyRequest;
import com.oracle.coherence.grpc.ContainsValueRequest;
import com.oracle.coherence.grpc.DestroyRequest;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.EntrySetRequest;
import com.oracle.coherence.grpc.GetAllRequest;
import com.oracle.coherence.grpc.GetRequest;
import com.oracle.coherence.grpc.InvokeAllRequest;
import com.oracle.coherence.grpc.InvokeRequest;
import com.oracle.coherence.grpc.IsEmptyRequest;
import com.oracle.coherence.grpc.KeySetRequest;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.MapListenerResponse;
import com.oracle.coherence.grpc.NamedCacheServiceGrpc;
import com.oracle.coherence.grpc.OptionalValue;
import com.oracle.coherence.grpc.PageRequest;
import com.oracle.coherence.grpc.PutAllRequest;
import com.oracle.coherence.grpc.PutIfAbsentRequest;
import com.oracle.coherence.grpc.PutRequest;
import com.oracle.coherence.grpc.RemoveIndexRequest;
import com.oracle.coherence.grpc.RemoveMappingRequest;
import com.oracle.coherence.grpc.RemoveRequest;
import com.oracle.coherence.grpc.ReplaceMappingRequest;
import com.oracle.coherence.grpc.ReplaceRequest;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.SizeRequest;
import com.oracle.coherence.grpc.TruncateRequest;
import com.oracle.coherence.grpc.ValuesRequest;
import com.oracle.coherence.grpc.proxy.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.GrpcProxyMetrics;
import com.oracle.coherence.grpc.proxy.NamedCacheService;
import com.oracle.coherence.grpc.proxy.NamedCacheServiceImpl;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletionStage;

public class NamedCacheServiceGrpcImpl
extends NamedCacheServiceGrpc.NamedCacheServiceImplBase
implements BindableGrpcProxyService {
    private final NamedCacheService m_service;

    public NamedCacheServiceGrpcImpl() {
        this(new NamedCacheServiceImpl.DefaultDependencies());
    }

    public NamedCacheServiceGrpcImpl(NamedCacheServiceImpl.Dependencies deps) {
        this(NamedCacheServiceImpl.newInstance(deps));
    }

    public NamedCacheServiceGrpcImpl(NamedCacheService service) {
        this.m_service = service;
    }

    @Override
    public GrpcProxyMetrics getMetrics() {
        return this.m_service.getMetrics();
    }

    public void addIndex(AddIndexRequest request, StreamObserver<Empty> observer) {
        this.m_service.addIndex(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void aggregate(AggregateRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.aggregate(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void clear(ClearRequest request, StreamObserver<Empty> observer) {
        CompletionStage<Empty> stage = this.m_service.clear(request);
        stage.handle((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void containsEntry(ContainsEntryRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.containsEntry(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void containsKey(ContainsKeyRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.containsKey(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void containsValue(ContainsValueRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.containsValue(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void destroy(DestroyRequest request, StreamObserver<Empty> observer) {
        this.m_service.destroy(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void entrySet(EntrySetRequest request, StreamObserver<Entry> observer) {
        this.m_service.entrySet(request, (StreamObserver<Entry>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public StreamObserver<MapListenerRequest> events(StreamObserver<MapListenerResponse> observer) {
        return this.m_service.events((StreamObserver<MapListenerResponse>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void get(GetRequest request, StreamObserver<OptionalValue> observer) {
        this.m_service.get(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void getAll(GetAllRequest request, StreamObserver<Entry> observer) {
        this.m_service.getAll(request, (StreamObserver<Entry>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void invoke(InvokeRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.invoke(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void invokeAll(InvokeAllRequest request, StreamObserver<Entry> observer) {
        this.m_service.invokeAll(request, (StreamObserver<Entry>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void isEmpty(IsEmptyRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.isEmpty(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void keySet(KeySetRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.keySet(request, (StreamObserver<BytesValue>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void nextEntrySetPage(PageRequest request, StreamObserver<EntryResult> observer) {
        this.m_service.nextEntrySetPage(request, (StreamObserver<EntryResult>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void nextKeySetPage(PageRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.nextKeySetPage(request, (StreamObserver<BytesValue>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    public void put(PutRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.put(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void putAll(PutAllRequest request, StreamObserver<Empty> observer) {
        this.m_service.putAll(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void putIfAbsent(PutIfAbsentRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.putIfAbsent(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void remove(RemoveRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.remove(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void removeIndex(RemoveIndexRequest request, StreamObserver<Empty> observer) {
        this.m_service.removeIndex(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void removeMapping(RemoveMappingRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.removeMapping(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void replace(ReplaceRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.replace(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void replaceMapping(ReplaceMappingRequest request, StreamObserver<BoolValue> observer) {
        this.m_service.replaceMapping(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void size(SizeRequest request, StreamObserver<Int32Value> observer) {
        this.m_service.size(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void truncate(TruncateRequest request, StreamObserver<Empty> observer) {
        this.m_service.truncate(request).handleAsync((result, err) -> this.handleUnary((Object)result, (Throwable)err, (StreamObserver)SafeStreamObserver.ensureSafeObserver((StreamObserver)observer)));
    }

    public void values(ValuesRequest request, StreamObserver<BytesValue> observer) {
        this.m_service.values(request, (StreamObserver<BytesValue>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    <R> Void handleUnary(R result, Throwable err, StreamObserver<R> observer) {
        if (err != null) {
            observer.onError(err);
        } else {
            observer.onNext(result);
            observer.onCompleted();
        }
        return null;
    }
}

