/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.proxy.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.GrpcMetricsInterceptor;
import com.oracle.coherence.grpc.proxy.GrpcServerBuilderProvider;
import com.oracle.coherence.grpc.proxy.GrpcServerConfiguration;
import com.oracle.coherence.grpc.proxy.NamedCacheServiceGrpcImpl;
import com.tangosol.application.Context;
import com.tangosol.application.LifecycleListener;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.Coherence;
import com.tangosol.net.events.CoherenceLifecycleEvent;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;

public class GrpcServerController {
    public static final GrpcServerController INSTANCE = new GrpcServerController();
    public static final String PROP_ENABLED = "coherence.grpc.enabled";
    private Server m_server;
    private Server m_inProcessServer;
    private String m_inProcessName;
    private boolean m_fEnabled = true;
    private CompletableFuture<Void> m_startFuture = new CompletableFuture();

    private GrpcServerController() {
    }

    public synchronized void start() {
        if (this.isRunning() || !this.m_fEnabled) {
            return;
        }
        try {
            this.m_inProcessName = Config.getProperty((String)"coherence.grpc.inprocess.name", (String)"default");
            int port = Config.getInteger((String)"coherence.grpc.server.port", (int)1408);
            GrpcServerBuilderProvider provider = StreamSupport.stream(ServiceLoader.load(GrpcServerBuilderProvider.class).spliterator(), false).sorted().findFirst().orElse(GrpcServerBuilderProvider.INSTANCE);
            ServerBuilder<?> serverBuilder = provider.getServerBuilder(port);
            InProcessServerBuilder inProcBuilder = provider.getInProcessServerBuilder(this.m_inProcessName);
            if (serverBuilder == null) {
                serverBuilder = GrpcServerBuilderProvider.INSTANCE.getServerBuilder(port);
            }
            if (inProcBuilder == null) {
                inProcBuilder = GrpcServerBuilderProvider.INSTANCE.getInProcessServerBuilder(this.m_inProcessName);
            }
            for (BindableGrpcProxyService service : this.createGrpcServices()) {
                GrpcMetricsInterceptor interceptor = new GrpcMetricsInterceptor(service.getMetrics());
                ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor});
                serverBuilder.addService(definition);
                inProcBuilder.addService(definition);
            }
            this.configure(serverBuilder, inProcBuilder);
            Server server = serverBuilder.build();
            Server inProcessServer = inProcBuilder.build();
            server.start();
            Logger.info(() -> "Coherence gRPC proxy is now listening for connections on 0.0.0.0:" + port);
            inProcessServer.start();
            Logger.info(() -> "Coherence gRPC in-process proxy '" + this.m_inProcessName + "' is now listening for connections");
            this.m_server = server;
            this.m_inProcessServer = inProcessServer;
            this.markStarted();
        }
        catch (IOException e) {
            if (!this.m_startFuture.isDone()) {
                this.m_startFuture.completeExceptionally(e);
            }
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.stopServer(this.m_server, "server");
            this.stopServer(this.m_inProcessServer, "in-process server");
            this.m_inProcessServer = null;
            this.m_server = null;
            this.m_startFuture = new CompletableFuture();
        }
    }

    public void markStarted() {
        if (!this.m_startFuture.isDone()) {
            this.m_startFuture.complete(null);
        }
    }

    public CompletionStage<Void> whenStarted() {
        return this.m_startFuture;
    }

    public boolean isRunning() {
        return this.m_server != null && !this.m_server.isShutdown();
    }

    public int getPort() {
        if (this.isRunning()) {
            return this.m_server.getPort();
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    public String getInProcessName() {
        if (this.isRunning()) {
            return this.m_inProcessName;
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    public List<BindableGrpcProxyService> createGrpcServices() {
        return Collections.singletonList(new NamedCacheServiceGrpcImpl());
    }

    public void setEnabled(boolean fEnabled) {
        this.m_fEnabled = fEnabled;
    }

    private void configure(ServerBuilder<?> serverBuilder, InProcessServerBuilder inProcessServerBuilder) {
        ServiceLoader<GrpcServerConfiguration> loader = ServiceLoader.load(GrpcServerConfiguration.class);
        for (GrpcServerConfiguration cfg : loader) {
            try {
                cfg.configure(serverBuilder, inProcessServerBuilder);
            }
            catch (Throwable t) {
                Logger.err((String)("Caught exception calling GrpcServerConfiguration " + cfg));
                Logger.err((Throwable)t);
            }
        }
    }

    private void stopServer(Server server, String sName) {
        boolean fStopped = false;
        server.shutdown();
        Logger.finest((String)("Awaiting termination of Coherence gRPC proxy " + sName));
        try {
            fStopped = server.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!fStopped) {
            Logger.finest((String)("Forcing termination of Coherence gRPC proxy " + sName));
            server.shutdownNow();
        }
        Logger.fine((String)("Stopped Coherence gRPC proxy " + sName));
    }

    public static class Listener
    implements LifecycleListener,
    Coherence.LifecycleListener {
        public void onEvent(CoherenceLifecycleEvent event) {
            switch ((CoherenceLifecycleEvent.Type)event.getType()) {
                case STARTED: {
                    if (!Config.getBoolean((String)GrpcServerController.PROP_ENABLED, (boolean)true)) break;
                    INSTANCE.start();
                    break;
                }
                case STOPPED: {
                    if (!Coherence.getInstances().isEmpty()) break;
                    INSTANCE.stop();
                }
            }
        }

        public void preStart(Context ctx) {
        }

        public void postStart(Context ctx) {
            if (Config.getBoolean((String)GrpcServerController.PROP_ENABLED, (boolean)true)) {
                INSTANCE.start();
            }
        }

        public void preStop(Context ctx) {
            INSTANCE.stop();
        }

        public void postStop(Context ctx) {
        }
    }
}

