/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.grpc.proxy.GrpcConnectionMetrics;
import com.oracle.coherence.grpc.proxy.GrpcProxyMetrics;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Objects;

public class GrpcMetricsInterceptor
implements ServerInterceptor {
    private final GrpcProxyMetrics f_metrics;
    private final GrpcConnectionMetrics f_connectionMetrics;

    public GrpcMetricsInterceptor(GrpcProxyMetrics metrics) {
        this(metrics, GrpcConnectionMetrics.getInstance());
    }

    GrpcMetricsInterceptor(GrpcProxyMetrics metrics, GrpcConnectionMetrics connectionMetrics) {
        this.f_metrics = Objects.requireNonNull(metrics);
        this.f_connectionMetrics = Objects.requireNonNull(connectionMetrics);
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.f_connectionMetrics.register(call);
        ResponseCountingServerCall<ReqT, RespT> counting = new ResponseCountingServerCall<ReqT, RespT>(this.f_metrics, call);
        switch (call.getMethodDescriptor().getType()) {
            case UNARY: {
                return new RequestTimingCallListener(next.startCall(counting, headers), this.f_metrics);
            }
            case CLIENT_STREAMING: 
            case SERVER_STREAMING: {
                ServerCall.Listener serverCall = next.startCall(counting, headers);
                return new StreamingTimingCallListener(serverCall, this.f_metrics);
            }
            case BIDI_STREAMING: {
                long nStart = System.nanoTime();
                ServerCall.Listener bidiCall = next.startCall(counting, headers);
                MessageTimingCallListener bidiListener = new MessageTimingCallListener(bidiCall, this.f_metrics);
                long time = System.nanoTime() - nStart;
                this.f_metrics.addRequestDuration(time);
                return bidiListener;
            }
        }
        return next.startCall(call, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static class StreamingTimingCallListener<ReqT>
    extends MessageTimingCallListener<ReqT> {
        public StreamingTimingCallListener(ServerCall.Listener<ReqT> delegate, GrpcProxyMetrics metrics) {
            super(delegate, metrics);
        }

        public void onHalfClose() {
            long nStartNanos = System.nanoTime();
            super.onHalfClose();
            long nDuration = System.nanoTime() - nStartNanos;
            this.f_metrics.addRequestDuration(nDuration);
        }
    }

    private static class RequestTimingCallListener<ReqT>
    extends MessageTimingCallListener<ReqT> {
        private long m_nStartNanos = System.nanoTime();

        public RequestTimingCallListener(ServerCall.Listener<ReqT> delegate, GrpcProxyMetrics metrics) {
            super(delegate, metrics);
        }

        public void onHalfClose() {
            this.m_nStartNanos = System.nanoTime();
            super.onHalfClose();
        }

        public void onCancel() {
            super.onCancel();
            long time = System.nanoTime() - this.m_nStartNanos;
            this.f_metrics.addRequestDuration(time);
        }

        public void onComplete() {
            super.onComplete();
            long time = System.nanoTime() - this.m_nStartNanos;
            this.f_metrics.addRequestDuration(time);
        }
    }

    private static class MessageTimingCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        protected final GrpcProxyMetrics f_metrics;

        public MessageTimingCallListener(ServerCall.Listener<ReqT> delegate, GrpcProxyMetrics metrics) {
            super(delegate);
            this.f_metrics = metrics;
        }

        public void onMessage(ReqT message) {
            long nStartNanos = System.nanoTime();
            super.onMessage(message);
            long nDuration = System.nanoTime() - nStartNanos;
            this.f_metrics.markReceived();
            this.f_metrics.addMessageDuration(nDuration);
        }
    }

    static class ResponseCountingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        protected final GrpcProxyMetrics f_metrics;

        ResponseCountingServerCall(GrpcProxyMetrics metrics, ServerCall<ReqT, RespT> delegate) {
            super(delegate);
            this.f_metrics = metrics;
        }

        public void sendMessage(RespT message) {
            super.sendMessage(message);
            this.f_metrics.markSent();
        }

        public void close(Status status, Metadata responseHeaders) {
            super.close(status, responseHeaders);
            if (status.getCode() == Status.Code.OK) {
                this.f_metrics.markSuccess();
            } else {
                this.f_metrics.markError();
            }
        }
    }
}

