/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.grpc.CredentialsHelper;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Resources;
import io.grpc.Grpc;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.annotation.Priority;

public interface GrpcServerBuilderProvider
extends Comparable<GrpcServerBuilderProvider> {
    public static final int DEFAULT_PRIORITY = 0;
    public static final GrpcServerBuilderProvider INSTANCE = new GrpcServerBuilderProvider(){

        @Override
        public ServerBuilder<?> getServerBuilder(int nPort) {
            ServerCredentials credentials = CredentialsHelper.createServerCredentials();
            return Grpc.newServerBuilderForPort((int)nPort, (ServerCredentials)credentials);
        }

        @Override
        public InProcessServerBuilder getInProcessServerBuilder(String sName) {
            return InProcessServerBuilder.forName((String)sName);
        }

        private String resolvePassword() throws IOException {
            String sTlsPass = Config.getProperty((String)"coherence.grpc.server.tls.password");
            if (sTlsPass != null) {
                return sTlsPass;
            }
            String sURI = Config.getProperty((String)"coherence.grpc.server.tls.password.uri");
            if (sURI != null) {
                URL url = Resources.findFileOrResource((String)sURI, null);
                if (url == null) {
                    throw new FileNotFoundException("Cannot locate password file: " + sURI);
                }
                try (InputStream in = url.openStream();){
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String string = reader.readLine();
                    return string;
                }
            }
            return null;
        }
    };

    public ServerBuilder<?> getServerBuilder(int var1);

    public InProcessServerBuilder getInProcessServerBuilder(String var1);

    default public int getPriority() {
        Priority annotation = this.getClass().getAnnotation(Priority.class);
        return annotation == null ? 0 : annotation.value();
    }

    @Override
    default public int compareTo(GrpcServerBuilderProvider o) {
        return 0 - Integer.compare(this.getPriority(), o.getPriority());
    }
}

