/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.config.ConfigurationException;
import com.tangosol.util.Resources;
import io.grpc.Grpc;
import io.grpc.InsecureServerCredentials;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.TlsServerCredentials;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettySslContextServerCredentials;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.annotation.Priority;

public interface GrpcServerBuilderProvider
extends Comparable<GrpcServerBuilderProvider> {
    public static final int DEFAULT_PRIORITY = 0;
    public static final GrpcServerBuilderProvider INSTANCE = new GrpcServerBuilderProvider(){

        @Override
        public ServerBuilder<?> getServerBuilder(int nPort) {
            ServerCredentials credentials;
            String sCredentials = Config.getProperty((String)"coherence.grpc.server.credentials", (String)"insecure");
            if ("insecure".equalsIgnoreCase(sCredentials)) {
                Logger.info((String)"Creating gRPC server using insecure credentials");
                credentials = InsecureServerCredentials.create();
            } else if ("tls".equalsIgnoreCase(sCredentials)) {
                try {
                    ClientAuth clientAuth;
                    String sTlsCert = Config.getProperty((String)"coherence.grpc.server.tls.cert");
                    String sTlsKey = Config.getProperty((String)"coherence.grpc.server.tls.key");
                    String sTlsPass = Config.getProperty((String)"coherence.grpc.server.tls.password");
                    String sTlsCA = Config.getProperty((String)"coherence.grpc.server.tls.ca");
                    String sClientAuth = Config.getProperty((String)"coherence.grpc.server.tls.client", (String)ClientAuth.NONE.name()).toUpperCase();
                    if (sTlsKey == null || sTlsCert == null) {
                        String sReason = "Invalid gRPC configuration, " + (sTlsKey == null ? "no key file specified" : "no cert file specfied");
                        throw new ConfigurationException(sReason, "When configuring gRPC TLS both the key and cert files must be configured key=\"" + sTlsKey + "\" cert=\"" + sTlsCert + "\"");
                    }
                    URL urlCert = Resources.findFileOrResource((String)sTlsCert, null);
                    if (urlCert == null) {
                        throw new ConfigurationException("Cannot find configured TLS cert: " + sTlsCert, "Ensure the TLS cert exists");
                    }
                    URL urlKey = Resources.findFileOrResource((String)sTlsKey, null);
                    if (urlKey == null) {
                        throw new ConfigurationException("Cannot find configured TLS key: " + sTlsCert, "Ensure the TLS key exists");
                    }
                    if (sTlsCA == null || ClientAuth.NONE.name().equals(sClientAuth)) {
                        credentials = TlsServerCredentials.newBuilder().keyManager(urlCert.openStream(), urlKey.openStream(), sTlsPass).build();
                    }
                    URL urlCA = Resources.findFileOrResource((String)sTlsCA, null);
                    if (urlCA == null) {
                        throw new ConfigurationException("Cannot find configured TLS CA: " + sTlsCA, "Ensure the TLS CA exists");
                    }
                    try {
                        clientAuth = ClientAuth.valueOf((String)sClientAuth);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ConfigurationException("Cannot find configured TLS client auth value: " + sClientAuth, "Valid values are one of " + Arrays.toString(ClientAuth.values()));
                    }
                    SslContextBuilder builder = SslContextBuilder.forServer((InputStream)urlCert.openStream(), (InputStream)urlKey.openStream(), (String)sTlsPass).trustManager(urlCA.openStream()).clientAuth(clientAuth);
                    Logger.info((String)("Creating gRPC server using TLS credentials. key=" + urlKey + " cert=" + urlCert + " ca=" + urlCA + " clientAuth=" + sClientAuth));
                    credentials = NettySslContextServerCredentials.create((SslContext)GrpcSslContexts.configure((SslContextBuilder)builder).build());
                }
                catch (IOException e) {
                    throw Exceptions.ensureRuntimeException((Throwable)e);
                }
            } else {
                throw new ConfigurationException("Invalid gRPC credentials type \"" + sCredentials + "\"", "Valid values are \"insecure\" or \"tls\"");
            }
            return Grpc.newServerBuilderForPort((int)nPort, (ServerCredentials)credentials);
        }

        @Override
        public InProcessServerBuilder getInProcessServerBuilder(String sName) {
            return InProcessServerBuilder.forName((String)sName);
        }
    };

    public ServerBuilder<?> getServerBuilder(int var1);

    public InProcessServerBuilder getInProcessServerBuilder(String var1);

    default public int getPriority() {
        Priority annotation = this.getClass().getAnnotation(Priority.class);
        return annotation == null ? 0 : annotation.value();
    }

    @Override
    default public int compareTo(GrpcServerBuilderProvider o) {
        return 0 - Integer.compare(this.getPriority(), o.getPriority());
    }
}

