/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.Entry;
import com.oracle.coherence.grpc.EntryResult;
import com.oracle.coherence.grpc.OptionalValue;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import io.grpc.Status;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class CacheRequestHolder<Req, Res> {
    protected final Req f_request;
    protected final AsyncNamedCache<Binary, Binary> f_asyncNamedCache;
    protected final String f_sFormat;
    protected final Executor f_executor;
    protected final Supplier<NamedCache<?, ?>> f_cacheSupplier;
    protected Converter<Binary, Binary> m_converterDown;
    protected Converter<Binary, Binary> m_converterKeyDown;
    protected Converter<Binary, Binary> m_converterUp;
    protected final Serializer f_serializer;
    protected Object m_result;

    protected CacheRequestHolder(Req request, AsyncNamedCache<Binary, Binary> cache, Supplier<NamedCache<?, ?>> cacheSupplier, String sFormat, Serializer serializer, Executor executor) {
        this.f_request = request;
        this.f_asyncNamedCache = cache;
        this.f_cacheSupplier = cacheSupplier;
        this.f_sFormat = sFormat;
        this.f_serializer = serializer;
        this.f_executor = executor;
    }

    protected Req getRequest() {
        return this.f_request;
    }

    protected Res getResult() {
        return (Res)this.m_result;
    }

    protected <T> T getDeserializedResult() {
        return (T)ExternalizableHelper.fromBinary((Binary)((Binary)this.m_result), (Serializer)this.getCacheSerializer());
    }

    protected <T> T fromCacheBinary(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getCacheSerializer());
    }

    protected <T> T deserialize(Binary binary) {
        return (T)ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.getCacheSerializer());
    }

    protected <T> T deserializeRequest(ByteString bytes) {
        return (T)ExternalizableHelper.fromBinary((Binary)BinaryHelper.toBinary((ByteString)bytes), (Serializer)this.f_serializer);
    }

    protected <T> CacheRequestHolder<Req, T> setResult(T t) {
        this.m_result = t;
        return this;
    }

    protected <T> CompletionStage<CacheRequestHolder<Req, T>> runAsync(CompletionStage<T> stage) {
        return stage.handleAsync((r, err) -> {
            if (err == null) {
                return this.setResult(r);
            }
            throw Status.INTERNAL.withCause(err).withDescription(err.getMessage()).asRuntimeException();
        }, this.f_executor);
    }

    protected String getCacheName() {
        return this.f_asyncNamedCache.getNamedCache().getCacheName();
    }

    protected AsyncNamedCache<Binary, Binary> getAsyncCache() {
        return this.f_asyncNamedCache;
    }

    protected NamedCache<Binary, Binary> getCache() {
        return this.f_asyncNamedCache.getNamedCache();
    }

    protected <K, V> NamedCache<K, V> getNonPassThruCache() {
        return this.f_cacheSupplier.get();
    }

    protected Serializer getSerializer() {
        return this.f_serializer;
    }

    protected Serializer getCacheSerializer() {
        return this.f_asyncNamedCache.getNamedCache().getCacheService().getSerializer();
    }

    protected Binary convertUp(Binary binary) {
        if (binary == null) {
            return null;
        }
        return (Binary)this.ensureConverterUp().convert((Object)binary);
    }

    protected Binary convertKeyDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinaryKey((ByteString)bytes);
        return this.convertKeyDown(binary);
    }

    protected Binary convertKeyDown(Binary binary) {
        return (Binary)this.ensureConverterKeyDown().convert((Object)binary);
    }

    protected Binary convertDown(Supplier<ByteString> supplier) {
        return this.convertDown(supplier.get());
    }

    protected Binary convertDown(ByteString bytes) {
        Binary binary = BinaryHelper.toBinary((ByteString)bytes);
        return this.convertDown(binary);
    }

    protected Binary convertDown(Binary binary) {
        return (Binary)this.ensureConverterDown().convert((Object)binary);
    }

    protected BytesValue deserializeToBytesValue(Binary binary) {
        return this.toBytesValue((Binary)this.deserialize(binary));
    }

    protected BytesValue toBytesValue(Binary binary) {
        return BytesValue.of((ByteString)this.toByteString(binary));
    }

    protected ByteString toByteString(Binary binary) {
        return BinaryHelper.toByteString((Binary)((Binary)this.ensureConverterUp().apply((Object)binary)));
    }

    protected Entry toEntry(Binary binKey, Binary binValue) {
        return Entry.newBuilder().setKey(BinaryHelper.toByteString((Binary)((Binary)this.ensureConverterUp().apply((Object)binKey)))).setValue(BinaryHelper.toByteString((Binary)((Binary)this.ensureConverterUp().apply((Object)binValue)))).build();
    }

    protected EntryResult toEntryResult(Map.Entry<Binary, Binary> entry) {
        return EntryResult.newBuilder().setKey(BinaryHelper.toByteString((Binary)((Binary)this.ensureConverterUp().apply((Object)entry.getKey())))).setValue(BinaryHelper.toByteString((Binary)((Binary)this.ensureConverterUp().apply((Object)entry.getValue())))).build();
    }

    protected OptionalValue toOptionalValue(Binary binary) {
        if (binary != null) {
            Binary converted = this.convertUp(binary);
            return OptionalValue.newBuilder().setValue(BinaryHelper.toByteString((Binary)converted)).setPresent(true).build();
        }
        return OptionalValue.newBuilder().setPresent(false).build();
    }

    protected Converter<Binary, Binary> ensureConverterKeyDown() {
        if (this.m_converterKeyDown == null) {
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            Serializer serializerCache = cacheService.getSerializer();
            String cacheFormat = serializerCache.getName();
            if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof DefaultSerializer) {
                cacheFormat = "java";
            } else if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof ConfigurablePofContext) {
                cacheFormat = "pof";
            }
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat)) {
                this.m_converterKeyDown = BinaryHelper::toBinaryKey;
            } else {
                BackingMapManagerContext context = cacheService.getBackingMapManager().getContext();
                Converter converterKey = context.getKeyToInternalConverter();
                this.m_converterKeyDown = new DownConverter(this.f_serializer, (Converter<Object, Binary>)converterKey);
            }
        }
        return this.m_converterKeyDown;
    }

    protected Converter<Binary, Binary> ensureConverterDown() {
        if (this.m_converterDown == null) {
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            Serializer serializerCache = cacheService.getSerializer();
            String cacheFormat = serializerCache.getName();
            if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof DefaultSerializer) {
                cacheFormat = "java";
            } else if ((cacheFormat == null || cacheFormat.isEmpty()) && serializerCache instanceof ConfigurablePofContext) {
                cacheFormat = "pof";
            }
            if (this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat)) {
                this.m_converterDown = b -> b;
            } else {
                BackingMapManagerContext context = cacheService.getBackingMapManager().getContext();
                Converter converterValue = context.getValueToInternalConverter();
                this.m_converterDown = new DownConverter(this.f_serializer, (Converter<Object, Binary>)converterValue);
            }
        }
        return this.m_converterDown;
    }

    protected Converter<Binary, Binary> ensureConverterUp() {
        if (this.m_converterUp == null) {
            CacheService cacheService = this.f_asyncNamedCache.getNamedCache().getCacheService();
            Serializer serializerCache = cacheService.getSerializer();
            String cacheFormat = serializerCache.getName();
            this.m_converterUp = this.f_sFormat == null || this.f_sFormat.trim().isEmpty() || this.f_sFormat.equals(cacheFormat) ? b -> b : new UpConverter(serializerCache, this.f_serializer);
        }
        return this.m_converterUp;
    }

    protected static class DownConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializer;
        protected final Converter<Object, Binary> f_converter;

        protected DownConverter(Serializer serializer, Converter<Object, Binary> converter) {
            this.f_serializer = serializer;
            this.f_converter = converter;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializer);
            return (Binary)this.f_converter.convert(o);
        }
    }

    protected static class UpConverter
    implements Converter<Binary, Binary> {
        protected final Serializer f_serializerFrom;
        protected final Serializer f_serializerTo;

        protected UpConverter(Serializer serializerFrom, Serializer serializerTo) {
            this.f_serializerFrom = serializerFrom;
            this.f_serializerTo = serializerTo;
        }

        public Binary convert(Binary binary) {
            if (binary == null) {
                return null;
            }
            Object o = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.f_serializerFrom);
            return ExternalizableHelper.toBinary((Object)o, (Serializer)this.f_serializerTo);
        }
    }
}

