/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.grpc.proxy.RefreshableSslContext;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.net.SocketProviderFactory;
import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.ServerCredentials;
import io.grpc.netty.NettySslContextChannelCredentials;
import io.grpc.netty.NettySslContextServerCredentials;
import io.netty.handler.ssl.SslContext;

public class NettyCredentialsHelper {
    private NettyCredentialsHelper() {
    }

    public static ServerCredentials createServerCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            if (depsFactory == null) {
                return InsecureServerCredentials.create();
            }
            String sSocketId = socketBuilder.getId();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId);
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureServerCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, true);
                return NettySslContextServerCredentials.create((SslContext)sslContext);
            }
        }
        return InsecureServerCredentials.create();
    }

    public static ChannelCredentials createChannelCredentials(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            String sSocketId;
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId = socketBuilder.getId());
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return InsecureChannelCredentials.create();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContextDependencies sslContextDependencies = dependencies.getSSLContextDependencies();
                RefreshableSslContext sslContext = new RefreshableSslContext(sslContextDependencies, false);
                return NettySslContextChannelCredentials.create((SslContext)sslContext);
            }
        }
        return InsecureChannelCredentials.create();
    }
}

