/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.helidon;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.proxy.common.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.common.GrpcMetricsInterceptor;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.oracle.coherence.grpc.proxy.common.NamedCacheService;
import com.oracle.coherence.grpc.proxy.common.NamedCacheServiceGrpcImpl;
import com.oracle.coherence.grpc.proxy.helidon.HelidonCredentialsHelper;
import com.oracle.coherence.grpc.proxy.helidon.HelidonNamedCacheService;
import com.tangosol.application.Context;
import com.tangosol.internal.net.service.peer.acceptor.DefaultGrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcAcceptorController;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.ChannelzService;
import io.grpc.protobuf.services.HealthStatusManager;
import io.helidon.common.Builder;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.grpc.GrpcRouting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HelidonGrpcAcceptorController
implements GrpcAcceptorController {
    private GrpcAcceptorDependencies m_dependencies;
    private volatile boolean m_fRunning;
    private WebServer m_server;
    private HealthStatusManager m_healthStatusManager;
    private List<BindableGrpcProxyService> m_listServices;
    private final Lock f_lock = new ReentrantLock();

    public int getPriority() {
        return 1;
    }

    public void setDependencies(GrpcAcceptorDependencies deps) {
        this.m_dependencies = deps;
    }

    public GrpcAcceptorDependencies getDependencies() {
        GrpcAcceptorDependencies deps = this.m_dependencies;
        if (deps == null) {
            deps = this.m_dependencies = new DefaultGrpcAcceptorDependencies();
        }
        return deps;
    }

    public void setDaemonPool(DaemonPool pool) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.m_fRunning) {
            return;
        }
        this.f_lock.lock();
        try {
            WebServer server;
            if (this.m_fRunning) {
                return;
            }
            GrpcAcceptorDependencies deps = this.getDependencies();
            WebServerConfig.Builder serverBuilder = WebServerConfig.builder();
            Context context = deps.getContext();
            GrpcServiceDependencies.DefaultDependencies serviceDeps = new GrpcServiceDependencies.DefaultDependencies();
            serviceDeps.setContext(context);
            serviceDeps.setExecutor(Runnable::run);
            this.m_listServices = HelidonGrpcAcceptorController.createGrpcServices((GrpcServiceDependencies)serviceDeps);
            ArrayList<String> listServiceNames = new ArrayList<String>();
            GrpcRouting.Builder routingBuilder = GrpcRouting.builder();
            for (BindableGrpcProxyService service : this.m_listServices) {
                GrpcMetricsInterceptor interceptor = new GrpcMetricsInterceptor(service.getMetrics());
                ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor});
                routingBuilder.service(definition).build();
                listServiceNames.add(definition.getServiceDescriptor().getName());
            }
            this.m_healthStatusManager = new HealthStatusManager();
            routingBuilder.service(null, this.m_healthStatusManager.getHealthService()).build();
            routingBuilder.service(null, (BindableService)ChannelzService.newInstance((int)deps.getChannelzPageSize())).build();
            HelidonCredentialsHelper.createTlsConfig(deps.getSocketProviderBuilder()).ifPresent(arg_0 -> ((WebServerConfig.Builder)serverBuilder).tls(arg_0));
            this.m_server = server = ((WebServerConfig.Builder)((WebServerConfig.Builder)serverBuilder.port(deps.getLocalPort())).addRouting((Builder)routingBuilder)).build().start();
            this.m_healthStatusManager.setStatus("$GRPC:GrpcProxy", HealthCheckResponse.ServingStatus.SERVING);
            listServiceNames.forEach(s -> this.m_healthStatusManager.setStatus(s, HealthCheckResponse.ServingStatus.SERVING));
            this.m_fRunning = true;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void stop() {
        if (this.m_fRunning) {
            this.f_lock.lock();
            try {
                if (this.m_fRunning) {
                    this.m_fRunning = false;
                    this.m_healthStatusManager.enterTerminalState();
                    this.m_healthStatusManager = null;
                    this.stopServer(this.m_server, "server");
                    this.m_server = null;
                    this.m_listServices = null;
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
    }

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public String getLocalAddress() {
        return this.m_dependencies.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.m_server == null || !this.m_server.isRunning()) {
            throw new IllegalStateException("The gRPC server is not started");
        }
        return this.m_server.port();
    }

    public String getInProcessName() {
        return null;
    }

    public List<BindableGrpcProxyService> getBindableServices() {
        return this.m_listServices;
    }

    public static List<BindableGrpcProxyService> createGrpcServices(GrpcServiceDependencies depsService) {
        NamedCacheService.DefaultDependencies deps = new NamedCacheService.DefaultDependencies(depsService);
        deps.setExecutor(Runnable::run);
        NamedCacheServiceGrpcImpl cacheService = new NamedCacheServiceGrpcImpl((NamedCacheService)HelidonNamedCacheService.newInstance((NamedCacheService.Dependencies)deps));
        return List.of(cacheService);
    }

    private void stopServer(WebServer server, String sName) {
        if (server == null) {
            return;
        }
        server.stop();
        Logger.fine((String)("Stopped Coherence gRPC proxy " + sName));
    }
}

