/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.helidon;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.net.SocketProviderFactory;
import io.helidon.common.tls.TlsConfig;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class HelidonCredentialsHelper {
    public static Optional<TlsConfig> createTlsConfig(SocketProviderBuilder socketBuilder) {
        if (socketBuilder != null) {
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            if (depsFactory == null) {
                return Optional.empty();
            }
            String sSocketId = socketBuilder.getId();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId);
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return Optional.empty();
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContext sslContext = dependencies.getSSLContext();
                TlsConfig tlsConfig = ((TlsConfig.Builder)TlsConfig.builder().sslContext(sslContext)).buildPrototype();
                return Optional.of(tlsConfig);
            }
        }
        return Optional.empty();
    }
}

