/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.GrpcService;
import com.oracle.coherence.grpc.GrpcServiceProtocol;
import com.oracle.coherence.grpc.messages.common.v1.BinaryKeyAndValue;
import com.oracle.coherence.grpc.messages.proxy.v1.InitRequest;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.message.Request;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.io.Serializer;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.messaging.Response;
import com.tangosol.util.Binary;
import com.tangosol.util.UUID;
import io.grpc.stub.StreamObserver;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseProxyProtocol<Req extends Message, Resp extends Message>
implements GrpcServiceProtocol<Req, Resp> {
    protected static final Lock f_lock = new ReentrantLock();
    protected GrpcService m_service;
    protected ExtensibleConfigurableCacheFactory m_ccf;
    protected CacheServiceProxy m_proxy;
    protected Serializer m_serializer;
    protected Connection m_connection;
    protected final Set<Integer> m_destroyedIds = new HashSet<Integer>();
    protected StreamObserver<Resp> m_eventObserver;
    private Context m_context;

    public Serializer getSerializer() {
        return this.m_serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GrpcService service, InitRequest request, int nVersion, UUID clientUUID, StreamObserver<Resp> observer) {
        f_lock.lock();
        try {
            String sScope = request.getScope();
            String sFormat = request.getFormat();
            ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)service.getCCF(sScope);
            this.m_service = service;
            this.m_context = service.getDependencies().getContext().orElse(null);
            this.m_ccf = eccf;
            this.m_serializer = service.getSerializer(sFormat, this.m_ccf.getConfigClassLoader());
            this.m_connection = new Connection();
            this.m_eventObserver = observer;
            this.m_connection.setId(clientUUID);
            this.m_proxy = new CacheServiceProxy();
            this.m_proxy.setCacheFactory((ConfigurableCacheFactory)this.m_ccf);
            this.m_proxy.setSerializer(this.m_serializer);
            this.initInternal(service, request, nVersion, clientUUID);
        }
        finally {
            f_lock.unlock();
        }
    }

    protected abstract void initInternal(GrpcService var1, InitRequest var2, int var3, UUID var4);

    public void onRequest(Req request, StreamObserver<Resp> observer) {
        ContainerContext containerContext;
        ContainerContext containerContext2 = containerContext = this.m_context == null ? null : this.m_context.getContainerContext();
        if (containerContext != null) {
            containerContext.runInDomainPartitionContext(() -> this.onRequestInternal(request, observer));
        } else {
            this.onRequestInternal(request, observer);
        }
    }

    protected abstract void onRequestInternal(Req var1, StreamObserver<Resp> var2);

    public void close() {
    }

    protected void complete(boolean f, int id, StreamObserver<Resp> observer) {
        this.complete((Message)BoolValue.of((boolean)f), id, observer);
    }

    protected void complete(int n, int id, StreamObserver<Resp> observer) {
        this.complete((Message)Int32Value.of((int)n), id, observer);
    }

    protected void complete(Binary binary, int id, StreamObserver<Resp> observer) {
        this.complete((Message)BinaryHelper.toBytesValue((Binary)binary), id, observer);
    }

    protected void complete(Request request, StreamObserver<Resp> observer) {
        Response response = request.ensureResponse();
        if (response.isFailure()) {
            observer.onError((Throwable)response.getResult());
        } else {
            observer.onCompleted();
        }
    }

    protected void complete(Binary binKey, Request request, int id, StreamObserver<Resp> observer) {
        Response response = request.ensureResponse();
        if (response.isFailure()) {
            observer.onError((Throwable)response.getResult());
        } else {
            Binary binValue = (Binary)response.getResult();
            this.completeKeyValue(binKey, binValue, id, observer);
        }
    }

    protected void completeKeyValue(Binary binKey, Binary binValue, int id, StreamObserver<Resp> observer) {
        BinaryKeyAndValue keyAndValue = BinaryKeyAndValue.newBuilder().setKey(BinaryHelper.toByteString((Binary)binKey)).setValue(BinaryHelper.toByteString((Binary)binValue)).build();
        this.complete((Message)keyAndValue, id, observer);
    }

    protected void complete(Message message, int id, StreamObserver<Resp> observer) {
        observer.onNext(this.response(id, Any.pack((Message)message)));
        observer.onCompleted();
    }

    protected void completeMapStream(Request request, int id, StreamObserver<Resp> observer) {
        Response response = request.ensureResponse();
        if (response.isFailure()) {
            observer.onError((Throwable)response.getResult());
        } else {
            Map map = (Map)response.getResult();
            this.completeMapStream(map, id, observer);
        }
    }

    protected void completeMapStream(Map<Binary, Binary> map, int id, StreamObserver<Resp> observer) {
        for (Map.Entry<Binary, Binary> entry : map.entrySet()) {
            BinaryKeyAndValue keyAndValue = BinaryKeyAndValue.newBuilder().setKey(BinaryHelper.toByteString((Binary)entry.getKey())).setValue(BinaryHelper.toByteString((Binary)entry.getValue())).build();
            observer.onNext(this.response(id, Any.pack((Message)keyAndValue)));
        }
        observer.onCompleted();
    }

    protected void completeSetStream(Request request, int id, StreamObserver<Resp> observer) {
        Response response = request.ensureResponse();
        if (response.isFailure()) {
            observer.onError((Throwable)response.getResult());
        } else {
            this.completeSetStream((Set)response.getResult(), id, observer);
        }
    }

    protected void completeSetStream(Set<Binary> set, int id, StreamObserver<Resp> observer) {
        for (Binary binary : set) {
            observer.onNext(this.response(id, Any.pack((Message)BinaryHelper.toBytesValue((Binary)binary))));
        }
        observer.onCompleted();
    }

    protected abstract Resp response(int var1, Any var2);

    protected <T extends Message> T unpack(Req request, Class<T> type) {
        try {
            Any any = this.getMessage(request);
            return (T)any.unpack(type);
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)("Could not unpack message field of type " + type.getName()));
        }
    }

    protected abstract Any getMessage(Req var1);

    protected <T> T fromBinary(Binary binary) {
        if (binary == null) {
            return null;
        }
        return (T)BinaryHelper.fromBinary((Binary)binary, (Serializer)this.m_serializer);
    }

    protected <T> T fromByteString(ByteString bytes) {
        if (bytes.isEmpty()) {
            return null;
        }
        return (T)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)this.m_serializer);
    }

    protected <T> T fromByteString(ByteString bytes, T defaultValue) {
        if (bytes.isEmpty()) {
            return defaultValue;
        }
        Object oResult = BinaryHelper.fromByteString((ByteString)bytes, (Serializer)this.m_serializer);
        return (T)(oResult == null ? defaultValue : oResult);
    }
}

