/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common.cache;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.GrpcService;
import com.oracle.coherence.grpc.NamedCacheProtocol;
import com.oracle.coherence.grpc.messages.cache.v1.EnsureCacheRequest;
import com.oracle.coherence.grpc.messages.cache.v1.ExecuteRequest;
import com.oracle.coherence.grpc.messages.cache.v1.IndexRequest;
import com.oracle.coherence.grpc.messages.cache.v1.KeyOrFilter;
import com.oracle.coherence.grpc.messages.cache.v1.KeysOrFilter;
import com.oracle.coherence.grpc.messages.cache.v1.MapEventMessage;
import com.oracle.coherence.grpc.messages.cache.v1.MapListenerRequest;
import com.oracle.coherence.grpc.messages.cache.v1.NamedCacheRequest;
import com.oracle.coherence.grpc.messages.cache.v1.NamedCacheRequestType;
import com.oracle.coherence.grpc.messages.cache.v1.NamedCacheResponse;
import com.oracle.coherence.grpc.messages.cache.v1.PutAllRequest;
import com.oracle.coherence.grpc.messages.cache.v1.PutRequest;
import com.oracle.coherence.grpc.messages.cache.v1.QueryRequest;
import com.oracle.coherence.grpc.messages.cache.v1.ReplaceMappingRequest;
import com.oracle.coherence.grpc.messages.cache.v1.ResponseType;
import com.oracle.coherence.grpc.messages.common.v1.BinaryKeyAndValue;
import com.oracle.coherence.grpc.messages.common.v1.CollectionOfBytesValues;
import com.oracle.coherence.grpc.messages.common.v1.OptionalValue;
import com.oracle.coherence.grpc.messages.proxy.v1.InitRequest;
import com.oracle.coherence.grpc.proxy.common.BaseProxyProtocol;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.message.Request;
import com.tangosol.coherence.component.net.extend.messageFactory.NamedCacheFactory;
import com.tangosol.coherence.component.net.extend.proxy.NamedCacheProxy;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.util.collection.ConvertingNamedCache;
import com.tangosol.internal.util.processor.BinaryProcessors;
import com.tangosol.internal.util.processor.CacheProcessors;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.NamedCache;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UUID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.InKeySetFilter;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.LongStream;

public class NamedCacheProxyProtocol
extends BaseProxyProtocol<NamedCacheRequest, NamedCacheResponse>
implements NamedCacheProtocol<NamedCacheRequest, NamedCacheResponse> {
    protected final LongArray<NamedCacheProxy> m_aProxy = new SparseArray();
    protected boolean m_fClosed;

    public Class<NamedCacheRequest> getRequestType() {
        return NamedCacheRequest.class;
    }

    public Class<NamedCacheResponse> getResponseType() {
        return NamedCacheResponse.class;
    }

    @Override
    public Serializer getSerializer() {
        return this.m_serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        f_lock.lock();
        try {
            this.m_fClosed = true;
            for (NamedCacheProxy proxy : this.m_aProxy) {
                com.tangosol.net.messaging.Channel channel = proxy.getChannel();
                proxy.unregisterChannel(channel);
            }
            this.m_aProxy.clear();
        }
        finally {
            f_lock.unlock();
        }
        super.close();
    }

    @Override
    protected void initInternal(GrpcService service, InitRequest request, int nVersion, UUID clientUUID) {
    }

    @Override
    protected NamedCacheResponse response(int id, Any any) {
        return NamedCacheResponse.newBuilder().setType(ResponseType.Message).setMessage(any).build();
    }

    @Override
    protected Any getMessage(NamedCacheRequest request) {
        return request.getMessage();
    }

    @Override
    protected void onRequestInternal(NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        NamedCacheRequestType requestType = request.getType();
        int cacheId = request.getCacheId();
        if (requestType == NamedCacheRequestType.EnsureCache) {
            this.onEnsureCache(this.unpack(request, EnsureCacheRequest.class), observer);
        } else {
            if (cacheId == 0) {
                throw new IllegalArgumentException("Missing channel id in request, has an EnsureCache request been sent" + String.valueOf(requestType));
            }
            if (this.m_destroyedIds.contains(cacheId)) {
                throw new IllegalStateException("The cache with id " + cacheId + " has been explicitly destroyed");
            }
            NamedCacheProxy proxy = (NamedCacheProxy)this.m_aProxy.get((long)cacheId);
            if (proxy == null) {
                throw new IllegalStateException("No cache proxy exist for id " + cacheId + " request=" + String.valueOf(requestType));
            }
            switch (requestType) {
                case Aggregate: {
                    this.onAggregate(proxy, request, observer);
                    break;
                }
                case Clear: {
                    this.onClear(proxy, observer);
                    break;
                }
                case ContainsEntry: {
                    this.onContainsEntry(proxy, request, observer);
                    break;
                }
                case ContainsKey: {
                    this.onContainsKey(proxy, request, observer);
                    break;
                }
                case ContainsValue: {
                    this.onContainsValue(proxy, request, observer);
                    break;
                }
                case Destroy: {
                    this.onDestroyCache(cacheId, observer);
                    break;
                }
                case Get: {
                    this.onGet(proxy, request, observer);
                    break;
                }
                case GetAll: {
                    this.onGetAll(proxy, request, observer);
                    break;
                }
                case Index: {
                    this.onIndex(proxy, request, observer);
                    break;
                }
                case Invoke: {
                    this.onInvoke(proxy, request, observer);
                    break;
                }
                case IsEmpty: {
                    this.onIsEmpty(proxy, observer);
                    break;
                }
                case IsReady: {
                    this.onIsReady(proxy, observer);
                    break;
                }
                case MapListener: {
                    this.onMapListener(proxy, request, observer);
                    break;
                }
                case PageOfEntries: {
                    this.onPageOfEntries(proxy, request, observer);
                    break;
                }
                case PageOfKeys: {
                    this.onPageOfKeys(proxy, request, observer);
                    break;
                }
                case Put: {
                    this.onPut(proxy, request, observer);
                    break;
                }
                case PutAll: {
                    this.onPutAll(proxy, request, observer);
                    break;
                }
                case PutIfAbsent: {
                    this.onPutIfAbsent(proxy, request, observer);
                    break;
                }
                case QueryEntries: {
                    this.onQueryEntrySet(proxy, request, observer);
                    break;
                }
                case QueryKeys: {
                    this.onQueryKeySet(proxy, request, observer);
                    break;
                }
                case QueryValues: {
                    this.onQueryValues(proxy, request, observer);
                    break;
                }
                case Remove: {
                    this.onRemove(proxy, request, observer);
                    break;
                }
                case RemoveMapping: {
                    this.onRemoveMapping(proxy, request, observer);
                    break;
                }
                case Replace: {
                    this.onReplace(proxy, request, observer);
                    break;
                }
                case ReplaceMapping: {
                    this.onReplaceMapping(proxy, request, observer);
                    break;
                }
                case Size: {
                    this.onSize(proxy, observer);
                    break;
                }
                case Truncate: {
                    this.onTruncate(proxy, observer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized request: " + String.valueOf(requestType));
                }
            }
        }
    }

    protected void onAggregate(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        ExecuteRequest execute = this.unpack(request, ExecuteRequest.class);
        InvocableMap.EntryAggregator aggregator = (InvocableMap.EntryAggregator)this.fromByteString(execute.getAgent());
        if (execute.hasKeys()) {
            KeysOrFilter keysOrFilter = execute.getKeys();
            if (keysOrFilter.hasKey()) {
                Binary binKey = BinaryHelper.toBinary((ByteString)keysOrFilter.getKey());
                Binary binResult = (Binary)proxy.aggregate(List.of(binKey), aggregator);
                this.completeKeyValue(binKey, binResult, proxy.getCacheId(), observer);
            } else if (keysOrFilter.hasKeys()) {
                CollectionOfBytesValues keys = keysOrFilter.getKeys();
                List<Binary> listKeys = keys.getValuesList().stream().map(BinaryHelper::toBinary).toList();
                Binary binResult = (Binary)proxy.aggregate(listKeys, aggregator);
                this.complete(binResult, proxy.getCacheId(), observer);
            } else if (keysOrFilter.hasFilter()) {
                Filter filter = (Filter)this.fromByteString(keysOrFilter.getFilter());
                Binary binResult = (Binary)proxy.aggregate((Filter)Objects.requireNonNullElse(filter, AlwaysFilter.INSTANCE()), aggregator);
                this.complete(binResult, proxy.getCacheId(), observer);
            } else {
                Binary binResult = (Binary)proxy.aggregate(aggregator);
                this.complete(binResult, proxy.getCacheId(), observer);
            }
        } else {
            Binary binResult = (Binary)proxy.aggregate(aggregator);
            this.complete(binResult, proxy.getCacheId(), observer);
        }
    }

    protected void onClear(NamedCacheProxy proxy, StreamObserver<NamedCacheResponse> observer) {
        proxy.clear();
        observer.onCompleted();
    }

    protected void onContainsEntry(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        BinaryKeyAndValue keyAndValue = this.unpack(request, BinaryKeyAndValue.class);
        Binary binKey = BinaryHelper.toBinary((ByteString)keyAndValue.getKey());
        Binary binValue = BinaryHelper.toBinary((ByteString)keyAndValue.getValue());
        boolean fContains = proxy.entrySet().contains(new SimpleMapEntry((Object)binKey, (Object)binValue));
        this.complete(fContains, proxy.getCacheId(), observer);
    }

    protected void onContainsKey(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary binKey = this.unpackBinary(request);
        this.complete(proxy.containsKey((Object)binKey), proxy.getCacheId(), observer);
    }

    protected void onContainsValue(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary binValue = this.unpackBinary(request);
        this.complete(proxy.containsValue((Object)binValue), proxy.getCacheId(), observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDestroyCache(int nId, StreamObserver<NamedCacheResponse> observer) {
        f_lock.lock();
        try {
            if (this.m_fClosed) {
                throw new IllegalStateException("this proxy channel is closed");
            }
            NamedCacheProxy proxy = (NamedCacheProxy)this.m_aProxy.remove((long)nId);
            if (proxy != null) {
                proxy.getNamedCache().destroy();
            }
            this.m_destroyedIds.add(nId);
        }
        finally {
            f_lock.unlock();
        }
        observer.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnsureCache(EnsureCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        f_lock.lock();
        try {
            int cacheId;
            if (this.m_fClosed) {
                throw new IllegalStateException("this proxy channel is closed");
            }
            while ((cacheId = Base.getRandom().nextInt(Integer.MAX_VALUE)) == 0 || this.m_aProxy.get((long)cacheId) != null || this.m_destroyedIds.contains(cacheId)) {
            }
            NamedCache cache = this.m_proxy.ensureCache(request.getCache(), null);
            NamedCacheProxy cacheProxy = new NamedCacheProxy();
            cacheProxy.setNamedCache(cache);
            cacheProxy.setCacheId(cacheId);
            cacheProxy.addMapListener((MapListener)new CacheListener(cacheId));
            Serializer serializerThis = this.m_proxy.getSerializer();
            Serializer serializerThat = CacheServiceProxy.getSerializer((NamedCache)cache);
            boolean fCompatible = ExternalizableHelper.isSerializerCompatible((Serializer)serializerThis, (Serializer)serializerThat);
            ChannelStub channelStub = new ChannelStub(cacheId, fCompatible);
            cacheProxy.registerChannel((com.tangosol.net.messaging.Channel)channelStub);
            this.m_aProxy.set((long)cacheId, (Object)cacheProxy);
            observer.onNext((Object)this.response(cacheId).build());
            observer.onCompleted();
        }
        finally {
            f_lock.unlock();
        }
    }

    protected void onGet(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary binKey = this.unpackBinary(request);
        OptionalValue.Builder builder = OptionalValue.newBuilder();
        ChannelStub channel = (ChannelStub)proxy.getChannel();
        Binary binResult = null;
        if (channel.isSerializerCompatible()) {
            binResult = (Binary)proxy.get((Object)binKey);
        } else {
            Binary binKeyConv;
            ConvertingNamedCache cache = (ConvertingNamedCache)proxy.getNamedCache();
            Binary binary = (Binary)cache.invokePassThru((Object)(binKeyConv = (Binary)cache.getConverterKeyUp().convert(cache.getConverterKeyDown().convert((Object)binKey))), BinaryProcessors.get());
            if (binary != null) {
                Object oResult = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)cache.getService().getSerializer());
                binResult = (Binary)cache.getConverterValueUp().convert(oResult);
            }
        }
        if (binResult == null || Binary.NO_BINARY.equals((Object)binKey)) {
            builder.setPresent(false);
        } else {
            builder.setPresent(true);
            builder.setValue(BinaryHelper.toByteString((Binary)binResult));
        }
        observer.onNext((Object)this.response(proxy.getCacheId()).setType(ResponseType.Message).setMessage(Any.pack((com.google.protobuf.Message)builder.build())).build());
        observer.onCompleted();
    }

    protected void onGetAll(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        int cacheId = proxy.getCacheId();
        CollectionOfBytesValues colKeys = this.unpack(request, CollectionOfBytesValues.class);
        List<Binary> listKeys = colKeys.getValuesList().stream().map(BinaryHelper::toBinary).toList();
        BiConsumer<Binary, Binary> callback = (k, v) -> {
            BinaryKeyAndValue keyAndValue = BinaryKeyAndValue.newBuilder().setKey(BinaryHelper.toByteString((Binary)k)).setValue(BinaryHelper.toByteString((Binary)v)).build();
            observer.onNext((Object)NamedCacheResponse.newBuilder().setCacheId(cacheId).setType(ResponseType.Message).setMessage(Any.pack((com.google.protobuf.Message)keyAndValue)).build());
        };
        this.async(proxy).ifPresentOrElse(asyncCache -> asyncCache.invokeAll((Collection)listKeys, BinaryProcessors.get(), callback).join(), () -> proxy.getAll((Collection)listKeys).forEach(callback));
        observer.onCompleted();
    }

    protected void onIndex(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        IndexRequest indexRequest = this.unpack(request, IndexRequest.class);
        ValueExtractor extractor = (ValueExtractor)this.fromByteString(indexRequest.getExtractor());
        if (indexRequest.getAdd()) {
            boolean fSorted = indexRequest.getSorted();
            Comparator comparator = (Comparator)this.fromByteString(indexRequest.getComparator());
            proxy.addIndex(extractor, fSorted, comparator);
        } else {
            proxy.removeIndex(extractor);
        }
        observer.onCompleted();
    }

    protected void onInvoke(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        ExecuteRequest execute = this.unpack(request, ExecuteRequest.class);
        InvocableMap.EntryProcessor processor = (InvocableMap.EntryProcessor)this.fromByteString(execute.getAgent());
        KeysOrFilter keysOrFilter = execute.getKeys();
        KeysOrFilter.KeyOrFilterCase type = keysOrFilter.getKeyOrFilterCase();
        if (type == KeysOrFilter.KeyOrFilterCase.KEY) {
            Binary binKey = BinaryHelper.toBinary((ByteString)keysOrFilter.getKey());
            Binary binValue = (Binary)proxy.invoke((Object)binKey, processor);
            this.completeKeyValue(binKey, binValue, proxy.getCacheId(), observer);
        } else if (type == KeysOrFilter.KeyOrFilterCase.KEYS) {
            CollectionOfBytesValues keys = keysOrFilter.getKeys();
            List<Binary> listKeys = keys.getValuesList().stream().map(BinaryHelper::toBinary).toList();
            Map map = proxy.invokeAll(listKeys, processor);
            this.completeMapStream(map, proxy.getCacheId(), observer);
        } else {
            AlwaysFilter filter = keysOrFilter.hasFilter() ? (Filter)BinaryHelper.fromByteString((ByteString)keysOrFilter.getFilter(), (Serializer)this.m_serializer) : AlwaysFilter.INSTANCE();
            Map map = proxy.invokeAll((Filter)filter, processor);
            this.completeMapStream(map, proxy.getCacheId(), observer);
        }
    }

    protected void onIsEmpty(NamedCacheProxy proxy, StreamObserver<NamedCacheResponse> observer) {
        this.complete(proxy.isEmpty(), proxy.getCacheId(), observer);
    }

    protected void onIsReady(NamedCacheProxy proxy, StreamObserver<NamedCacheResponse> observer) {
        this.complete(proxy.isReady(), proxy.getCacheId(), observer);
    }

    protected void onMapListener(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        MapListenerRequest listenerRequest = this.unpack(request, MapListenerRequest.class);
        boolean fAdd = listenerRequest.getSubscribe();
        KeyOrFilter keyOrFilter = listenerRequest.getKeyOrFilter();
        if (keyOrFilter.getKeyOrFilterCase() == KeyOrFilter.KeyOrFilterCase.KEY) {
            NamedCacheFactory.ListenerKeyRequest listenerKeyRequest = this.createListenerKeyRequest(proxy, listenerRequest);
            listenerKeyRequest.setAdd(fAdd);
            listenerKeyRequest.run();
            this.complete((Request)listenerKeyRequest, observer);
        } else {
            NamedCacheFactory.ListenerFilterRequest listenerFilterRequest = this.createListenerFilterRequest(proxy, listenerRequest);
            listenerFilterRequest.setAdd(fAdd);
            listenerFilterRequest.run();
            this.complete((Request)listenerFilterRequest, observer);
        }
    }

    protected NamedCacheFactory.ListenerKeyRequest createListenerKeyRequest(NamedCacheProxy proxy, MapListenerRequest request) {
        NamedCacheFactory.ListenerKeyRequest listenerKeyRequest = new NamedCacheFactory.ListenerKeyRequest();
        listenerKeyRequest.setNamedCache((NamedCache)proxy);
        listenerKeyRequest.setChannel(proxy.getChannel());
        Binary binKey = BinaryHelper.toBinary((ByteString)request.getKeyOrFilter().getKey());
        listenerKeyRequest.setKey((Object)binKey);
        listenerKeyRequest.setLite(request.getLite());
        listenerKeyRequest.setPriming(request.getPriming());
        listenerKeyRequest.setNamedCache((NamedCache)proxy);
        return listenerKeyRequest;
    }

    protected NamedCacheFactory.ListenerFilterRequest createListenerFilterRequest(NamedCacheProxy proxy, MapListenerRequest request) {
        Filter filter;
        MapTrigger trigger = (MapTrigger)this.fromByteString(request.getTrigger());
        AlwaysFilter dflt = trigger == null ? AlwaysFilter.INSTANCE : null;
        KeyOrFilter keyOrFilter = request.getKeyOrFilter();
        Filter filter2 = filter = keyOrFilter.getKeyOrFilterCase() == KeyOrFilter.KeyOrFilterCase.FILTER ? (Filter)this.fromByteString(keyOrFilter.getFilter(), dflt) : null;
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = new InKeySetFilter(null, ((InKeySetFilter)filter).getKeys());
            filterKeys.ensureConverted(k -> ExternalizableHelper.toBinary((Object)k, (Serializer)this.m_serializer));
            filter = filterKeys;
        }
        NamedCacheFactory.ListenerFilterRequest listenerFilterRequest = new NamedCacheFactory.ListenerFilterRequest();
        listenerFilterRequest.setNamedCache((NamedCache)proxy);
        listenerFilterRequest.setChannel(proxy.getChannel());
        listenerFilterRequest.setFilter(filter);
        listenerFilterRequest.setFilterId(request.getFilterId());
        listenerFilterRequest.setLite(request.getLite());
        listenerFilterRequest.setPriming(request.getPriming());
        listenerFilterRequest.setNamedCache((NamedCache)proxy);
        listenerFilterRequest.setTrigger(trigger);
        return listenerFilterRequest;
    }

    protected void onPageOfEntries(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary cookie;
        Map map;
        BytesValue cookieBytes = request.hasMessage() ? this.unpack(request, BytesValue.class) : null;
        Binary binCookie = cookieBytes == null || cookieBytes.getValue().isEmpty() ? null : BinaryHelper.toBinary((BytesValue)cookieBytes);
        NamedCacheFactory.QueryRequest qr = new NamedCacheFactory.QueryRequest();
        qr.setCookie(binCookie);
        qr.setKeysOnly(false);
        qr.setNamedCache((NamedCache)proxy);
        qr.setChannel(proxy.getChannel());
        while (true) {
            qr.run();
            if (qr.ensureResponse().isFailure()) {
                this.complete((Request)qr, observer);
                return;
            }
            NamedCacheFactory.PartialResponse response = (NamedCacheFactory.PartialResponse)qr.ensureResponse();
            map = (Map)response.getResult();
            cookie = response.getCookie();
            if (!map.isEmpty() || cookie == null) break;
            qr.setCookie(response.getCookie());
        }
        observer.onNext((Object)this.response(proxy).setMessage(Any.pack((com.google.protobuf.Message)BinaryHelper.toBytesValue((Binary)cookie))).build());
        this.completeMapStream(map, proxy.getCacheId(), observer);
    }

    protected void onPageOfKeys(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary cookie;
        Set set;
        BytesValue cookieBytes = request.hasMessage() ? this.unpack(request, BytesValue.class) : null;
        Binary binCookie = cookieBytes == null || cookieBytes.getValue().isEmpty() ? null : BinaryHelper.toBinary((BytesValue)cookieBytes);
        NamedCacheFactory.QueryRequest qr = new NamedCacheFactory.QueryRequest();
        qr.setCookie(binCookie);
        qr.setKeysOnly(true);
        qr.setNamedCache((NamedCache)proxy);
        qr.setChannel(proxy.getChannel());
        while (true) {
            qr.run();
            if (qr.ensureResponse().isFailure()) {
                this.complete((Request)qr, observer);
                return;
            }
            NamedCacheFactory.PartialResponse response = (NamedCacheFactory.PartialResponse)qr.ensureResponse();
            set = (Set)response.getResult();
            cookie = response.getCookie();
            if (!set.isEmpty() || cookie == null) break;
            qr.setCookie(response.getCookie());
        }
        observer.onNext((Object)this.response(proxy).setMessage(Any.pack((com.google.protobuf.Message)BinaryHelper.toBytesValue((Binary)cookie))).build());
        this.completeSetStream(set, proxy.getCacheId(), observer);
    }

    protected void onPut(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        PutRequest putRequest = this.unpack(request, PutRequest.class);
        long ttl = putRequest.hasTtl() ? putRequest.getTtl() : 0L;
        Binary binKey = BinaryHelper.toBinary((ByteString)putRequest.getKey());
        Binary binValue = BinaryHelper.toBinary((ByteString)putRequest.getValue());
        Binary binResult = (Binary)proxy.put((Object)binKey, (Object)binValue, ttl);
        this.complete(binResult, proxy.getCacheId(), observer);
    }

    protected void onPutAll(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        PutAllRequest putRequest = this.unpack(request, PutAllRequest.class);
        List entries = putRequest.getEntriesList();
        if (!entries.isEmpty()) {
            HashMap<Binary, Binary> map = new HashMap<Binary, Binary>();
            for (BinaryKeyAndValue keyAndValue : entries) {
                map.put(BinaryHelper.toBinary((ByteString)keyAndValue.getKey()), BinaryHelper.toBinary((ByteString)keyAndValue.getValue()));
            }
            long ttl = putRequest.getTtl();
            if (ttl == 0L) {
                proxy.putAll(map);
            } else {
                proxy.async().putAll(map, ttl).join();
            }
        }
        observer.onCompleted();
    }

    protected void onPutIfAbsent(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary binResult;
        PutRequest putRequest = this.unpack(request, PutRequest.class);
        Binary binKey = BinaryHelper.toBinary((ByteString)putRequest.getKey());
        Binary binValue = BinaryHelper.toBinary((ByteString)putRequest.getValue());
        if (((ChannelStub)proxy.getChannel()).isSerializerCompatible()) {
            binResult = (Binary)proxy.invoke((Object)binKey, BinaryProcessors.putIfAbsent((Binary)binValue, (long)0L));
            binResult = (Binary)ExternalizableHelper.fromBinary((Binary)binResult, (Serializer)proxy.getCacheService().getSerializer());
        } else {
            binResult = (Binary)proxy.putIfAbsent((Object)binKey, this.fromBinary(binValue));
        }
        this.complete(binResult, proxy.getCacheId(), observer);
    }

    protected void onQueryEntrySet(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        QueryRequest query = this.unpack(request, QueryRequest.class);
        AlwaysFilter filter = query.hasFilter() ? (Filter)this.fromByteString(query.getFilter()) : AlwaysFilter.INSTANCE();
        Comparator comparator = query.hasComparator() ? (Comparator)this.fromByteString(query.getComparator()) : null;
        int cacheId = proxy.getCacheId();
        Consumer<Map.Entry> callback = entry -> {
            BinaryKeyAndValue keyAndValue = BinaryKeyAndValue.newBuilder().setKey(BinaryHelper.toByteString((Binary)((Binary)entry.getKey()))).setValue(BinaryHelper.toByteString((Binary)((Binary)entry.getValue()))).build();
            observer.onNext((Object)NamedCacheResponse.newBuilder().setCacheId(cacheId).setType(ResponseType.Message).setMessage(Any.pack((com.google.protobuf.Message)keyAndValue)).build());
        };
        if (comparator == null) {
            this.async(proxy).ifPresentOrElse(arg_0 -> NamedCacheProxyProtocol.lambda$onQueryEntrySet$5((Filter)filter, callback, arg_0), () -> NamedCacheProxyProtocol.lambda$onQueryEntrySet$6(proxy, (Filter)filter, callback));
        } else {
            Set set = proxy.entrySet((Filter)filter, comparator);
            for (Map.Entry entry2 : set) {
                callback.accept(entry2);
            }
        }
        observer.onCompleted();
    }

    protected void onQueryKeySet(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        QueryRequest query = this.unpack(request, QueryRequest.class);
        AlwaysFilter filter = query.hasFilter() ? (Filter)this.fromByteString(query.getFilter()) : AlwaysFilter.INSTANCE();
        int cacheId = proxy.getCacheId();
        Consumer<Binary> callback = binary -> observer.onNext((Object)NamedCacheResponse.newBuilder().setCacheId(cacheId).setType(ResponseType.Message).setMessage(Any.pack((com.google.protobuf.Message)BinaryHelper.toBytesValue((Binary)binary))).build());
        this.async(proxy).ifPresentOrElse(arg_0 -> NamedCacheProxyProtocol.lambda$onQueryKeySet$8((Filter)filter, callback, arg_0), () -> NamedCacheProxyProtocol.lambda$onQueryKeySet$9(proxy, (Filter)filter, callback));
        observer.onCompleted();
    }

    protected void onQueryValues(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        QueryRequest query = this.unpack(request, QueryRequest.class);
        AlwaysFilter filter = query.hasFilter() ? (Filter)this.fromByteString(query.getFilter()) : AlwaysFilter.INSTANCE();
        int cacheId = proxy.getCacheId();
        Consumer<Binary> callback = binary -> observer.onNext((Object)NamedCacheResponse.newBuilder().setCacheId(cacheId).setType(ResponseType.Message).setMessage(Any.pack((com.google.protobuf.Message)BinaryHelper.toBytesValue((Binary)binary))).build());
        this.async(proxy).ifPresentOrElse(arg_0 -> NamedCacheProxyProtocol.lambda$onQueryValues$11((Filter)filter, callback, arg_0), () -> NamedCacheProxyProtocol.lambda$onQueryValues$12(proxy, (Filter)filter, callback));
        observer.onCompleted();
    }

    protected void onRemove(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        Binary binKey = this.unpackBinary(request);
        Binary binResult = (Binary)proxy.remove((Object)binKey);
        this.complete(binResult, proxy.getCacheId(), observer);
    }

    protected void onRemoveMapping(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        BinaryKeyAndValue keyAndValue = this.unpack(request, BinaryKeyAndValue.class);
        Binary binKey = BinaryHelper.toBinary((ByteString)keyAndValue.getKey());
        Object oValue = this.fromByteString(keyAndValue.getValue());
        Binary binResult = (Binary)proxy.invoke((Object)binKey, CacheProcessors.remove(oValue));
        Boolean fRemoved = (Boolean)this.fromBinary(binResult);
        this.complete(fRemoved, proxy.getCacheId(), observer);
    }

    protected void onReplace(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        BinaryKeyAndValue keyAndValue = this.unpack(request, BinaryKeyAndValue.class);
        Binary binKey = BinaryHelper.toBinary((ByteString)keyAndValue.getKey());
        Binary binValue = BinaryHelper.toBinary((ByteString)keyAndValue.getValue());
        Object oValue = this.fromBinary(binValue);
        Binary binResult = (Binary)proxy.replace((Object)binKey, oValue);
        this.complete(binResult, proxy.getCacheId(), observer);
    }

    protected void onReplaceMapping(NamedCacheProxy proxy, NamedCacheRequest request, StreamObserver<NamedCacheResponse> observer) {
        ReplaceMappingRequest mappingRequest = this.unpack(request, ReplaceMappingRequest.class);
        Binary binKey = BinaryHelper.toBinary((ByteString)mappingRequest.getKey());
        Binary binValuePrev = BinaryHelper.toBinary((ByteString)mappingRequest.getPreviousValue());
        Object oValuePrev = this.fromBinary(binValuePrev);
        Binary binValueNew = BinaryHelper.toBinary((ByteString)mappingRequest.getNewValue());
        Object oValueNew = this.fromBinary(binValueNew);
        Binary binResult = (Binary)proxy.invoke((Object)binKey, CacheProcessors.replace(oValuePrev, oValueNew));
        boolean fReplaced = (Boolean)this.fromBinary(binResult);
        this.complete(fReplaced, proxy.getCacheId(), observer);
    }

    protected void onSize(NamedCacheProxy proxy, StreamObserver<NamedCacheResponse> observer) {
        this.complete(proxy.size(), proxy.getCacheId(), observer);
    }

    protected void onTruncate(NamedCacheProxy proxy, StreamObserver<NamedCacheResponse> observer) {
        proxy.truncate();
        observer.onCompleted();
    }

    protected NamedCacheResponse.Builder response(NamedCacheProxy proxy) {
        return this.response(proxy.getCacheId());
    }

    protected NamedCacheResponse.Builder response(int cacheId) {
        return NamedCacheResponse.newBuilder().setCacheId(cacheId);
    }

    protected Optional<AsyncNamedCache<Binary, Binary>> async(NamedCacheProxy proxy) {
        try {
            return Optional.of(proxy.async());
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    protected Binary unpackBinary(NamedCacheRequest request) {
        BytesValue binaryValue = this.unpack(request, BytesValue.class);
        return BinaryHelper.toBinary((ByteString)binaryValue.getValue());
    }

    private static /* synthetic */ void lambda$onQueryValues$12(NamedCacheProxy proxy, Filter filter, Consumer callback) {
        proxy.values(filter).forEach(callback);
    }

    private static /* synthetic */ void lambda$onQueryValues$11(Filter filter, Consumer callback, AsyncNamedCache asyncCache) {
        asyncCache.values(filter, callback).join();
    }

    private static /* synthetic */ void lambda$onQueryKeySet$9(NamedCacheProxy proxy, Filter filter, Consumer callback) {
        proxy.keySet(filter).forEach(callback);
    }

    private static /* synthetic */ void lambda$onQueryKeySet$8(Filter filter, Consumer callback, AsyncNamedCache asyncCache) {
        asyncCache.keySet(filter, callback).join();
    }

    private static /* synthetic */ void lambda$onQueryEntrySet$6(NamedCacheProxy proxy, Filter filter, Consumer callback) {
        proxy.entrySet(filter).forEach(callback);
    }

    private static /* synthetic */ void lambda$onQueryEntrySet$5(Filter filter, Consumer callback, AsyncNamedCache asyncCache) {
        asyncCache.entrySet(filter, callback).join();
    }

    protected class CacheListener
    implements NamedCacheDeactivationListener {
        private final int m_cacheId;

        public CacheListener(int cacheId) {
            this.m_cacheId = cacheId;
        }

        public void entryInserted(MapEvent evt) {
        }

        public void entryUpdated(MapEvent evt) {
            this.send(ResponseType.Truncated);
        }

        public void entryDeleted(MapEvent evt) {
            this.send(ResponseType.Destroyed);
        }

        private void send(ResponseType type) {
            NamedCacheResponse event = NamedCacheResponse.newBuilder().setCacheId(this.m_cacheId).setType(type).build();
            NamedCacheProxyProtocol.this.m_eventObserver.onNext((Object)event);
        }
    }

    protected class ChannelStub
    extends Channel {
        protected final int m_cacheId;
        protected final boolean m_fCompatible;

        public ChannelStub(int cacheId, boolean fCompatible) {
            com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol protocol = new com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol();
            NamedCacheFactory factory = new NamedCacheFactory();
            factory.setProtocol((Protocol)protocol);
            factory.setVersion(protocol.getCurrentVersion());
            this.setMessageFactory((Protocol.MessageFactory)factory);
            this.m_cacheId = cacheId;
            this.m_fCompatible = fCompatible;
        }

        public void send(Message message) {
            if (message instanceof NamedCacheFactory.MapEvent) {
                long[] filterIds;
                Binary binNew;
                NamedCacheFactory.MapEvent event = (NamedCacheFactory.MapEvent)message;
                int nId = event.getId();
                boolean fSynthetic = event.isSynthetic();
                boolean fPriming = event.isPriming();
                boolean fUpdate = nId == 2;
                Object oKey = event.getKey();
                Object oValueOld = event.getValueOld();
                Object oValueNew = event.getValueNew();
                boolean fVersionUpdate = fSynthetic && fPriming && fUpdate && oKey == null && oValueNew == null && oValueOld == null;
                MapEventMessage.Builder builder = MapEventMessage.newBuilder().setId(nId).setKey(BinaryHelper.toByteString((Binary)((Binary)event.getKey()))).setPriming(fPriming).setSynthetic(fSynthetic).setExpired(event.isExpired()).setVersionUpdate(fVersionUpdate).setTransformationState(MapEventMessage.TransformationState.forNumber((int)event.getTransformationState()));
                Binary binOld = (Binary)event.getValueOld();
                if (binOld != null) {
                    builder.setOldValue(BinaryHelper.toByteString((Binary)binOld));
                }
                if ((binNew = (Binary)event.getValueNew()) != null) {
                    builder.setNewValue(BinaryHelper.toByteString((Binary)binNew));
                }
                if ((filterIds = event.getFilterIds()) != null && filterIds.length > 0) {
                    builder.addAllFilterIds(LongStream.of(filterIds).boxed().toList());
                }
                NamedCacheResponse response = NamedCacheResponse.newBuilder().setCacheId(this.m_cacheId).setType(ResponseType.MapEvent).setMessage(Any.pack((com.google.protobuf.Message)builder.build())).build();
                NamedCacheProxyProtocol.this.m_eventObserver.onNext((Object)response);
            }
        }

        public Connection getConnection() {
            return new ConnectionStub();
        }

        public Peer getConnectionManager() {
            return new ConnectionManagerStub();
        }

        public boolean isSerializerCompatible() {
            return this.m_fCompatible;
        }
    }

    protected static class ConnectionManagerStub
    extends Acceptor {
        public ConnectionManagerStub() {
            super("GrpcAcceptor", null, false);
        }

        public String toString() {
            return "GrpcAcceptor";
        }
    }

    protected static class ConnectionStub
    extends com.tangosol.coherence.component.net.extend.Connection {
        protected ConnectionStub() {
        }

        public String toString() {
            return "GrpcConnection";
        }

        public ConnectionManager getConnectionManager() {
            return new ConnectionManagerStub();
        }
    }
}

