/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.helidon;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.oracle.coherence.grpc.client.common.AbstractGrpcChannelFactory;
import com.oracle.coherence.grpc.client.common.GrpcRemoteService;
import com.oracle.coherence.grpc.client.helidon.HelidonCredentialsHelper;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.grpc.RemoteGrpcServiceDependencies;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.grpc.GrpcChannelDependencies;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientCall;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.HeaderNames;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientConfig;
import io.helidon.webclient.grpc.GrpcClientProtocolConfig;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

public class HelidonGrpcChannelFactory
extends AbstractGrpcChannelFactory {
    public int getPriority() {
        return 1;
    }

    public Channel getChannel(GrpcRemoteService<?> service) {
        RemoteGrpcServiceDependencies depsService = service.getDependencies();
        OperationalContext ctx = (OperationalContext)service.getCluster();
        String sService = service.getServiceName();
        String sKey = AbstractGrpcChannelFactory.GrpcServiceInfo.createKey(service);
        String sRemoteService = depsService.getRemoteServiceName();
        String sRemoteCluster = depsService.getRemoteClusterName();
        GrpcChannelDependencies depsChannel = depsService.getChannelDependencies();
        AbstractGrpcChannelFactory.GrpcServiceInfo info = new AbstractGrpcChannelFactory.GrpcServiceInfo(ctx, sService, sRemoteService, sRemoteCluster, depsChannel);
        long nDeadline = depsService.getDeadline();
        if (nDeadline <= 0L) {
            nDeadline = 30000L;
        }
        this.m_mapServiceInfo.put(sKey, info);
        AbstractGrpcChannelFactory.AddressProviderNameResolver resolver = new AbstractGrpcChannelFactory.AddressProviderNameResolver(depsChannel, info, null);
        ChannelWrapper wrapper = new ChannelWrapper(resolver, nDeadline);
        HelidonCredentialsHelper.createTlsConfig(depsChannel.getSocketProviderBuilder()).ifPresent(wrapper::tlsConfig);
        depsChannel.getAuthorityOverride().ifPresent(wrapper::overrideAuthority);
        return wrapper;
    }

    protected ChannelCredentials createChannelCredentials(SocketProviderBuilder builder) {
        return null;
    }

    protected static class ChannelWrapper
    extends Channel {
        private final AbstractGrpcChannelFactory.AddressProviderNameResolver m_resolver;
        private final Listener m_listener;
        private String m_sAuthority;
        private TlsConfig m_tlsConfig;
        private String m_sScheme = "http";
        private Channel m_channel;
        private final ReentrantLock f_lock = new ReentrantLock();
        private List<EquivalentAddressGroup> m_listAddress = Collections.emptyList();
        private long m_nDeadline = 30000L;

        public ChannelWrapper(AbstractGrpcChannelFactory.AddressProviderNameResolver resolver, long nDeadline) {
            this.m_listener = new Listener();
            this.m_resolver = resolver;
            this.m_nDeadline = nDeadline;
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> descriptor, CallOptions options) {
            final ClientCall call = this.ensureChannel().newCall(descriptor, options);
            return new ForwardingClientCall<RequestT, ResponseT>(){

                public void start(final ClientCall.Listener<ResponseT> listener, Metadata headers) {
                    ForwardingClientCallListener forwardingListener = new ForwardingClientCallListener<ResponseT>(){

                        protected ClientCall.Listener<ResponseT> delegate() {
                            return listener;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onClose(Status status, Metadata trailers) {
                            super.onClose(status, trailers);
                            Channel channel = m_channel;
                            f_lock.lock();
                            try {
                                if (channel != null && channel == m_channel) {
                                    m_channel = null;
                                }
                            }
                            finally {
                                f_lock.unlock();
                            }
                        }
                    };
                    super.start((ClientCall.Listener)forwardingListener, headers);
                }

                protected ClientCall<RequestT, ResponseT> delegate() {
                    return call;
                }
            };
        }

        public String authority() {
            return this.m_sAuthority == null ? this.ensureChannel().authority() : this.m_sAuthority;
        }

        public void overrideAuthority(String sAuthority) {
            this.m_sAuthority = sAuthority;
        }

        public Listener getListener() {
            return this.m_listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Channel ensureChannel() {
            Channel channel = this.m_channel;
            if (this.m_channel == null) {
                this.f_lock.lock();
                try {
                    channel = this.m_channel;
                    if (channel == null) {
                        this.m_resolver.start((NameResolver.Listener2)this.m_listener);
                        URI uri = this.m_listAddress.stream().map(this::toURI).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("No remote addresses are available"));
                        GrpcClientProtocolConfig config = ((GrpcClientProtocolConfig.Builder)((GrpcClientProtocolConfig.Builder)((GrpcClientProtocolConfig.Builder)GrpcClientProtocolConfig.builder().pollWaitTime(Duration.ofSeconds(10L))).heartbeatPeriod(Duration.ofSeconds(5L))).abortPollTimeExpired(false)).build();
                        GrpcClientConfig.Builder builder = (GrpcClientConfig.Builder)((GrpcClientConfig.Builder)((GrpcClientConfig.Builder)GrpcClient.builder().protocolConfig(config)).baseUri(uri)).addHeader(HeaderNames.USER_AGENT, "Coherence Java Client");
                        if (this.m_tlsConfig != null) {
                            builder.tls(this.m_tlsConfig);
                        }
                        GrpcClient client = builder.build();
                        channel = this.m_channel = client.channel();
                    }
                }
                finally {
                    this.f_lock.unlock();
                }
            }
            return channel;
        }

        protected URI toURI(EquivalentAddressGroup eag) {
            return eag.getAddresses().stream().map(this::toURI).findFirst().orElse(null);
        }

        protected URI toURI(SocketAddress address) {
            int nPort;
            String sHost;
            if (address instanceof InetSocketAddress) {
                sHost = ((InetSocketAddress)address).getHostName();
                nPort = ((InetSocketAddress)address).getPort();
            } else if (address instanceof InetSocketAddress32) {
                sHost = ((InetSocketAddress32)address).getHostName();
                nPort = ((InetSocketAddress32)address).getPort();
            } else {
                throw new IllegalArgumentException("Invalid socket address type: " + String.valueOf(address));
            }
            if ("localhost".equalsIgnoreCase(sHost)) {
                try {
                    sHost = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return URI.create(this.m_sScheme + "://" + sHost + ":" + nPort);
        }

        protected void tlsConfig(TlsConfig tlsConfig) {
            this.m_tlsConfig = tlsConfig;
            this.m_sScheme = tlsConfig == null ? "http" : "https";
        }

        protected class Listener
        extends NameResolver.Listener2 {
            protected Listener() {
            }

            public void onResult(NameResolver.ResolutionResult result) {
                ChannelWrapper.this.f_lock.lock();
                try {
                    ChannelWrapper.this.m_listAddress = result.getAddresses();
                }
                finally {
                    ChannelWrapper.this.f_lock.unlock();
                }
            }

            public void onError(Status error) {
                Logger.err((String)("Error resolving gRPC endpoints due to: " + String.valueOf(error)));
            }
        }
    }
}

