/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.helidon;

import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.net.SocketProviderFactory;
import io.helidon.common.tls.TlsConfig;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class HelidonCredentialsHelper {
    public static Optional<TlsConfig> createTlsConfig(SocketProviderBuilder socketBuilder) {
        TlsConfig.Builder builder = TlsConfig.builder();
        if (socketBuilder != null) {
            SocketProviderFactory.Dependencies depsFactory = socketBuilder.getDependencies();
            if (depsFactory == null) {
                return Optional.empty();
            }
            String sSocketId = socketBuilder.getId();
            SocketProviderFactory.Dependencies.ProviderType type = depsFactory.getProviderType(sSocketId);
            if (type == SocketProviderFactory.Dependencies.ProviderType.GRPC) {
                return Optional.of(((TlsConfig.Builder)TlsConfig.builder().enabled(false)).buildPrototype());
            }
            SSLSocketProvider.Dependencies dependencies = depsFactory.getSSLDependencies(sSocketId);
            if (dependencies != null) {
                SSLContext sslContext = dependencies.getSSLContext();
                builder.sslContext(sslContext);
            } else {
                builder.enabled(false);
            }
        } else {
            builder.enabled(false);
        }
        return Optional.of(builder.buildPrototype());
    }
}

