/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common.config;

import com.oracle.coherence.common.util.Options;
import com.oracle.coherence.grpc.client.common.topics.GrpcRemoteTopicService;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.scheme.BaseGrpcTopicScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.Cluster;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.Service;
import com.tangosol.net.TopicService;
import com.tangosol.net.topic.NamedTopic;

public class GrpcTopicScheme
extends BaseGrpcTopicScheme
implements ClusterDependencies.ServiceProvider<TopicService> {
    protected ClusterDependencies.ServiceProvider<TopicService> getServiceProvider() {
        return this;
    }

    public TopicService createService(String sName, Cluster cluster) {
        GrpcRemoteTopicService service = new GrpcRemoteTopicService();
        service.setServiceName(sName);
        service.setCluster(cluster);
        return service;
    }

    public TopicService ensureConfiguredService(ParameterResolver resolver, MapBuilder.Dependencies deps) {
        return this.getOrEnsureService(deps);
    }

    public GrpcTopicScheme getNamedCollectionBuilder(Class<? extends NamedCollection> clz, Options<NamedCollection.Option> options) {
        if (clz.isAssignableFrom(NamedTopic.class)) {
            return this;
        }
        return null;
    }

    private TopicService getOrEnsureService(MapBuilder.Dependencies deps) {
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)deps.getConfigurableCacheFactory();
        Service service = eccf.ensureService((ServiceScheme)this);
        if (!(service instanceof TopicService)) {
            throw new IllegalArgumentException("Error: ensureTopic is using service " + service.getInfo().getServiceName() + ", which is a " + String.valueOf(service.getClass()) + " not a TopicService");
        }
        return (TopicService)service;
    }
}

