/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client.common;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class SingleValueStreamObserver<T>
implements StreamObserver<T> {
    private int m_cNext;
    private T m_oResult;
    private final CompletableFuture<T> f_future = new CompletableFuture();

    public void onNext(T value) {
        if (this.m_cNext++ == 0) {
            this.m_oResult = value;
        } else {
            this.f_future.completeExceptionally(new IllegalStateException("More than one result received."));
        }
    }

    public void onError(Throwable t) {
        this.f_future.completeExceptionally(t);
    }

    public void onCompleted() {
        this.f_future.complete(this.m_oResult);
    }

    public CompletionStage<T> completionStage() {
        return this.f_future;
    }
}

